/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.dsql.utils;

import cn.tenmg.sqltool.dsql.macro.Macro;
import cn.tenmg.sqltool.dsql.utils.DSQLUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.script.ScriptException;

public abstract class MacroUtils {
    private static final char BLANK_SPACE = ' ';
    private static final char MACRO_LOGIC_START = '(';
    private static final char MACRO_LOGIC_END = ')';
    private static final Map<String, Macro> MACROS = new HashMap<String, Macro>();

    public static final StringBuilder execute(StringBuilder dsql, Map<String, Object> context, Map<String, Object> params, boolean returnEmptyWhenNoMacro) {
        int len = dsql.length();
        char a = ' ';
        char b = ' ';
        StringBuilder macroName = new StringBuilder();
        StringBuilder paramName = null;
        HashMap<String, Object> usedParams = new HashMap<String, Object>();
        for (int i = 0; i < len; ++i) {
            char c = dsql.charAt(i);
            if (c == '(') {
                if (macroName.length() > 0) {
                    Macro macro = MACROS.get(macroName.toString());
                    if (macro == null) {
                        if (returnEmptyWhenNoMacro) {
                            return new StringBuilder();
                        }
                        return dsql;
                    }
                    StringBuilder logic = new StringBuilder();
                    boolean isString = false;
                    boolean isParam = false;
                    int deep = 0;
                    while (++i < len) {
                        a = b;
                        b = c;
                        c = dsql.charAt(i);
                        if (isString) {
                            if (DSQLUtils.isStringEnd(a, b, c)) {
                                isString = false;
                            }
                            logic.append(c);
                            continue;
                        }
                        if (c == ')') {
                            if (deep == 0) {
                                if (logic.length() > 0) {
                                    return MacroUtils.execute(dsql, context, usedParams, macro, logic.toString(), i);
                                }
                                return dsql;
                            }
                            logic.append(c);
                            --deep;
                            continue;
                        }
                        if (c == '(') {
                            logic.append(c);
                            ++deep;
                            continue;
                        }
                        if (isParam) {
                            if (DSQLUtils.isParamChar(c)) {
                                paramName.append(c);
                            } else {
                                isParam = false;
                                String name = paramName.toString();
                                usedParams.put(name, params.get(name));
                            }
                            logic.append(c);
                            continue;
                        }
                        if (DSQLUtils.isParamBegin(b, c)) {
                            isParam = true;
                            paramName = new StringBuilder();
                            paramName.append(c);
                            logic.setCharAt(logic.length() - 1, c);
                            continue;
                        }
                        logic.append(c);
                    }
                    return dsql;
                }
                if (returnEmptyWhenNoMacro) {
                    return new StringBuilder();
                }
                return dsql;
            }
            if (c <= ' ') {
                if (macroName.length() > 0) {
                    Macro macro = MACROS.get(macroName.toString());
                    if (macro == null) {
                        if (returnEmptyWhenNoMacro) {
                            return new StringBuilder();
                        }
                        return dsql;
                    }
                    return MacroUtils.execute(dsql, context, usedParams, macro, null, i - 1);
                }
                if (returnEmptyWhenNoMacro) {
                    return new StringBuilder();
                }
                return dsql;
            }
            macroName.append(c);
            a = b;
            b = c;
        }
        return dsql;
    }

    private static final StringBuilder execute(StringBuilder dsql, Map<String, Object> context, Map<String, Object> params, Macro macro, String logic, int macroEndIndex) {
        Object result = null;
        try {
            result = macro.excute(logic, context, params);
        }
        catch (ScriptException e) {
            return dsql;
        }
        if (result == null) {
            return dsql;
        }
        if (result instanceof Boolean) {
            if (((Boolean)result).booleanValue()) {
                dsql.delete(0, macroEndIndex + 1);
                return dsql;
            }
            return new StringBuilder();
        }
        return new StringBuilder(result.toString()).append((CharSequence)dsql.delete(0, macroEndIndex + 1));
    }

    static {
        ServiceLoader<Macro> loader = ServiceLoader.load(Macro.class);
        for (Macro macro : loader) {
            MACROS.put(macro.getClass().getSimpleName().toLowerCase(), macro);
        }
    }
}

