/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.dialect;

import cn.tenmg.sqltool.sql.SQLMetaData;
import cn.tenmg.sqltool.sql.dialect.AbstractSQLDialect;
import cn.tenmg.sqltool.sql.utils.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class SQLServerDialect
extends AbstractSQLDialect {
    private static final long serialVersionUID = -253323537155093627L;
    private static final String UPDATE_SET_TEMPLATE = "${columnName} = ?";
    private static final String UPDATE_SET_IF_NOT_NULL_TEMPLATE = "${columnName} = ISNULL(?, ${columnName})";
    private static final String INSERT_IF_NOT_EXISTS = "MERGE INTO ${tableName} X USING (SELECT ${fields}) Y ON (${condition}) WHEN NOT MATCHED THEN INSERT (${columns}) VALUES(${values});";
    private static final String SAVE = "MERGE INTO ${tableName} X USING (SELECT ${fields}) Y ON (${condition}) WHEN MATCHED THEN UPDATE SET ${sets} WHEN NOT MATCHED THEN INSERT (${columns}) VALUES(${values});";
    private static final String FIELDS = "fields";
    private static final String CONDITION = "condition";
    private static final String SPACE = " ";
    private static final List<String> EXT_SQL_TEMPLATE_PARAM_NAMES = Arrays.asList("fields", "condition");
    private static final List<String> NEEDS_COMMA_PARAM_NAMES = Arrays.asList("fields", "columns", "values");
    private static final String SET_TEMPLATE = "X.${columnName} = Y.${columnName}";
    private static final String SET_IF_NOT_NULL_TEMPLATE = "X.${columnName} = ISNULL(Y.${columnName}, X.${columnName})";
    private static final String SQLTOOL_RN = " 1 RN__,";
    private static final String PAGE_WRAP_START = "SELECT %s FROM (\n";
    private static final String SUBQUERY_START = "SELECT 1 RN__,SQLTOOL.* FROM (\n";
    private static final String SUBQUERY_END = "\n) SQLTOOL";
    private static final String ORDER_BY = "\nORDER BY RN__";
    private static final String PAGE_WRAP_END = " OFFSET %d ROW FETCH NEXT %d ROW ONLY";
    private static final SQLServerDialect INSTANCE = new SQLServerDialect();

    public static final SQLServerDialect getInstance() {
        return INSTANCE;
    }

    @Override
    String getUpdateSetTemplate() {
        return UPDATE_SET_TEMPLATE;
    }

    @Override
    String getUpdateSetIfNotNullTemplate() {
        return UPDATE_SET_IF_NOT_NULL_TEMPLATE;
    }

    @Override
    List<String> getExtSQLTemplateParamNames() {
        return EXT_SQL_TEMPLATE_PARAM_NAMES;
    }

    @Override
    String getSaveSQLTemplate() {
        return SAVE;
    }

    @Override
    String getInsertIfNotExistsSQLTemplate() {
        return INSERT_IF_NOT_EXISTS;
    }

    @Override
    List<String> getNeedsCommaParamNames() {
        return NEEDS_COMMA_PARAM_NAMES;
    }

    @Override
    void handleColumnWhenSave(String columnName, Map<String, StringBuilder> templateParams) {
        templateParams.get(FIELDS).append('?').append(SPACE).append(columnName);
        templateParams.get("columns").append(columnName);
        templateParams.get("values").append("Y.").append(columnName);
    }

    @Override
    void handleIdColumnWhenSave(String columnName, Map<String, StringBuilder> templateParams, boolean notFirst) {
        StringBuilder condition = templateParams.get(CONDITION);
        if (notFirst) {
            condition.append(" AND ");
        }
        condition.append("X.").append(columnName).append(" = ").append("Y.").append(columnName);
    }

    @Override
    String getSetTemplate() {
        return SET_TEMPLATE;
    }

    @Override
    String getSetIfNotNullTemplate() {
        return SET_IF_NOT_NULL_TEMPLATE;
    }

    @Override
    public String pageSql(Connection con, String sql, Map<String, ?> params, SQLMetaData sqlMetaData, int pageSize, long currentPage) throws SQLException {
        int selectIndex = sqlMetaData.getSelectIndex();
        if (selectIndex < 0) {
            return sql;
        }
        int offsetIndex = sqlMetaData.getOffsetIndex();
        int length = sqlMetaData.getLength();
        int embedStartIndex = sqlMetaData.getEmbedStartIndex();
        int embedEndIndex = sqlMetaData.getEmbedEndIndex();
        if (offsetIndex > 0) {
            String pageStart = SQLServerDialect.pageStart(SQLUtils.getColumnLabels(con, sql, params, sqlMetaData));
            if (embedStartIndex > 0) {
                if (embedEndIndex < length) {
                    return sql.substring(0, embedStartIndex).concat(pageStart).concat(SUBQUERY_START).concat(sql.substring(embedStartIndex, embedEndIndex)).concat(SUBQUERY_END).concat(ORDER_BY).concat(SQLServerDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END).concat(sql.substring(embedEndIndex));
                }
                return sql.substring(0, embedStartIndex).concat(pageStart).concat(SUBQUERY_START).concat(sql.substring(embedStartIndex)).concat(SUBQUERY_END).concat(ORDER_BY).concat(SQLServerDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END);
            }
            if (embedEndIndex < length) {
                return pageStart.concat(SUBQUERY_START).concat(sql.substring(0, embedEndIndex)).concat(SUBQUERY_END).concat(ORDER_BY).concat(SQLServerDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END).concat(sql.substring(embedEndIndex));
            }
            return pageStart.concat(SUBQUERY_START).concat(sql).concat(SUBQUERY_END).concat(ORDER_BY).concat(SQLServerDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END);
        }
        int orderByIndex = sqlMetaData.getOrderByIndex();
        if (orderByIndex > 0) {
            if (embedEndIndex < length) {
                return sql.substring(0, embedEndIndex).concat(SQLServerDialect.pageEnd(pageSize, currentPage)).concat(sql.substring(embedEndIndex));
            }
            return sql.concat(SQLServerDialect.pageEnd(pageSize, currentPage));
        }
        String pageStart = SQLServerDialect.pageStart(SQLUtils.getColumnLabels(con, sql, params, sqlMetaData));
        int selectEndIndex = selectIndex + SELECT_LEN;
        if (embedStartIndex > 0) {
            if (embedEndIndex < length) {
                return sql.substring(0, embedStartIndex).concat(pageStart).concat(sql.substring(embedStartIndex, selectIndex)).concat(sql.substring(selectIndex, selectEndIndex)).concat(SQLTOOL_RN).concat(sql.substring(selectEndIndex, embedEndIndex)).concat(ORDER_BY).concat(SQLServerDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END).concat(sql.substring(embedEndIndex));
            }
            return sql.substring(0, embedStartIndex).concat(pageStart).concat(sql.substring(embedStartIndex, selectIndex)).concat(sql.substring(selectIndex, selectEndIndex)).concat(SQLTOOL_RN).concat(sql.substring(selectEndIndex)).concat(ORDER_BY).concat(SQLServerDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END);
        }
        if (embedEndIndex < length) {
            return pageStart.concat(sql.substring(0, selectEndIndex)).concat(SQLTOOL_RN).concat(sql.substring(selectEndIndex, embedEndIndex)).concat(ORDER_BY).concat(SQLServerDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END).concat(sql.substring(embedEndIndex));
        }
        return pageStart.concat(sql.substring(0, selectEndIndex)).concat(SQLTOOL_RN).concat(sql.substring(selectEndIndex)).concat(ORDER_BY).concat(SQLServerDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END);
    }

    private static String pageStart(String[] columnLabels) {
        return String.format(PAGE_WRAP_START, String.join((CharSequence)", ", columnLabels));
    }

    private static String pageEnd(int pageSize, long currentPage) {
        return String.format(PAGE_WRAP_END, (currentPage - 1L) * (long)pageSize, pageSize);
    }
}

