/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.transaction;

import cn.tenmg.sqltool.DSQLFactory;
import cn.tenmg.sqltool.dsql.NamedSQL;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.SQL;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.executer.ExecuteUpdateSQLExecuter;
import cn.tenmg.sqltool.sql.executer.GetSQLExecuter;
import cn.tenmg.sqltool.sql.executer.SelectSQLExecuter;
import cn.tenmg.sqltool.sql.parser.DeleteDMLParser;
import cn.tenmg.sqltool.sql.parser.GetDMLParser;
import cn.tenmg.sqltool.sql.parser.InsertDMLParser;
import cn.tenmg.sqltool.sql.parser.UpdateDMLParser;
import cn.tenmg.sqltool.sql.utils.SQLUtils;
import cn.tenmg.sqltool.transaction.CurrentConnectionHolder;
import cn.tenmg.sqltool.utils.CollectionUtils;
import cn.tenmg.sqltool.utils.JSONUtils;
import cn.tenmg.sqltool.utils.JdbcUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransactionExecutor
implements Serializable {
    private static final long serialVersionUID = -4415310449248911047L;
    private static final Logger log = LogManager.getLogger(TransactionExecutor.class);
    private boolean showSql = true;
    private DSQLFactory DSQLFactory;
    private SQLDialect dialect;

    public TransactionExecutor(boolean showSql, DSQLFactory DSQLFactory2, SQLDialect dialect) {
        this.showSql = showSql;
        this.DSQLFactory = DSQLFactory2;
        this.dialect = dialect;
    }

    public int insert(Object obj) throws SQLException {
        DML dml = InsertDMLParser.getInstance().parse(obj.getClass());
        String sql = dml.getSql();
        List<Object> params = JdbcUtils.getParams(obj, dml.getFields());
        if (this.showSql && log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Execute SQL: ").append(sql).append(", ").append("parameters: ").append(JSONUtils.toJSONString(params));
            log.info(sb.toString());
        }
        return JdbcUtils.execute(CurrentConnectionHolder.get(), null, sql, params, ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int insert(List<T> rows) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        DML dml = InsertDMLParser.getInstance().parse(((Serializable)rows.get(0)).getClass());
        String sql = dml.getSql();
        if (this.showSql && log.isInfoEnabled()) {
            log.info("Execute SQL: ".concat(sql));
        }
        return JdbcUtils.executeBatch(CurrentConnectionHolder.get(), this.showSql, rows, InsertDMLParser.getInstance());
    }

    public <T extends Serializable> int update(T obj) throws SQLException {
        SQL sql = this.dialect.update(obj);
        return JdbcUtils.execute(CurrentConnectionHolder.get(), null, sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int update(T obj, String ... hardFields) throws SQLException {
        SQL sql = this.dialect.update(obj, hardFields);
        return JdbcUtils.execute(CurrentConnectionHolder.get(), null, sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int update(List<T> rows) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JdbcUtils.update(CurrentConnectionHolder.get(), this.showSql, rows, this.dialect.update(((Serializable)rows.get(0)).getClass()));
    }

    public <T extends Serializable> int update(List<T> rows, String ... hardFields) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JdbcUtils.update(CurrentConnectionHolder.get(), this.showSql, rows, this.dialect.update(((Serializable)rows.get(0)).getClass(), hardFields));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Serializable> int hardUpdate(T obj) throws SQLException {
        int n;
        PreparedStatement ps;
        block10: {
            DML dml = UpdateDMLParser.getInstance().parse(obj.getClass());
            ps = null;
            try {
                String sql = dml.getSql();
                ps = CurrentConnectionHolder.get().prepareStatement(sql);
                List<Object> params = JdbcUtils.getParams(obj, dml.getFields());
                JdbcUtils.setParams(ps, params);
                if (this.showSql && log.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Execute SQL: ").append(sql).append(", ").append("parameters: ").append(JSONUtils.toJSONString(params));
                    log.info(sb.toString());
                }
                n = ps.executeUpdate();
                if (ps == null) break block10;
            }
            catch (SQLException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.clearBatch();
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                        }
                    }
                    JdbcUtils.close(ps);
                    throw throwable;
                }
            }
            try {
                ps.clearBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        JdbcUtils.close(ps);
        return n;
    }

    public <T extends Serializable> int hardUpdate(List<T> rows) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JdbcUtils.hardUpdate(CurrentConnectionHolder.get(), this.showSql, rows);
    }

    public <T extends Serializable> int save(T obj) throws SQLException {
        SQL sql = this.dialect.save(obj);
        return JdbcUtils.execute(CurrentConnectionHolder.get(), null, sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int save(T obj, String ... hardFields) throws SQLException {
        SQL sql = this.dialect.save(obj, hardFields);
        return JdbcUtils.execute(CurrentConnectionHolder.get(), null, sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int save(List<T> rows) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JdbcUtils.save(CurrentConnectionHolder.get(), this.showSql, rows, this.dialect.save(((Serializable)rows.get(0)).getClass()));
    }

    public <T extends Serializable> int save(List<T> rows, String ... hardFields) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JdbcUtils.save(CurrentConnectionHolder.get(), this.showSql, rows, this.dialect.save(((Serializable)rows.get(0)).getClass(), hardFields));
    }

    public <T extends Serializable> int hardSave(T obj) throws SQLException {
        SQL sql = this.dialect.hardSave(obj);
        return JdbcUtils.execute(CurrentConnectionHolder.get(), null, sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int hardSave(List<T> rows) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JdbcUtils.hardSave(CurrentConnectionHolder.get(), this.dialect, this.showSql, rows);
    }

    public <T extends Serializable> int delete(T obj) throws SQLException {
        DML dml = DeleteDMLParser.getInstance().parse(obj.getClass());
        return JdbcUtils.execute(CurrentConnectionHolder.get(), null, dml.getSql(), JdbcUtils.getParams(obj, dml.getFields()), ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int delete(List<T> rows) throws SQLException {
        return JdbcUtils.executeBatch(CurrentConnectionHolder.get(), this.showSql, rows, DeleteDMLParser.getInstance());
    }

    public <T extends Serializable> T get(T obj) throws SQLException {
        Class<?> type = obj.getClass();
        DML dml = GetDMLParser.getInstance().parse(type);
        return (T)((Serializable)JdbcUtils.execute(CurrentConnectionHolder.get(), null, dml.getSql(), JdbcUtils.getParams(obj, dml.getFields()), new GetSQLExecuter(type), this.showSql));
    }

    public <T extends Serializable> T get(Class<T> type, String dsql, Object ... params) throws SQLException {
        return this.get(this.DSQLFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> T get(Class<T> type, String dsql, Map<String, ?> params) throws SQLException {
        return this.get(this.DSQLFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Object ... params) throws SQLException {
        return this.select(this.DSQLFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Map<String, ?> params) throws SQLException {
        return this.select(this.DSQLFactory.parse(dsql, params), type);
    }

    public boolean execute(String dsql, Object ... params) throws SQLException {
        return this.execute(this.DSQLFactory.parse(dsql, params));
    }

    public boolean execute(String dsql, Map<String, ?> params) throws SQLException {
        return this.execute(this.DSQLFactory.parse(dsql, params));
    }

    public int executeUpdate(String dsql, Object ... params) throws SQLException {
        return this.executeUpdate(this.DSQLFactory.parse(dsql, params));
    }

    public int executeUpdate(String dsql, Map<String, ?> params) throws SQLException {
        return this.executeUpdate(this.DSQLFactory.parse(dsql, params));
    }

    private boolean execute(NamedSQL namedSQL) throws SQLException {
        SQL sql = SQLUtils.toSQL(namedSQL.getScript(), namedSQL.getParams());
        PreparedStatement ps = null;
        boolean rs = false;
        Connection con = CurrentConnectionHolder.get();
        try {
            String script = sql.getScript();
            List<Object> params = sql.getParams();
            ps = con.prepareStatement(script);
            JdbcUtils.setParams(ps, sql.getParams());
            if (this.showSql && log.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Execute SQL: ").append(script).append(", ").append("parameters: ").append(JSONUtils.toJSONString(params));
                String id = namedSQL.getId();
                if (id != null) {
                    sb.append(", ").append("id: ").append(id);
                }
                log.info(sb.toString());
            }
            rs = ps.execute();
        }
        catch (SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                throw e;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(ps);
                throw throwable;
            }
        }
        JdbcUtils.close(ps);
        return rs;
    }

    private int executeUpdate(NamedSQL namedSQL) throws SQLException {
        SQL sql = SQLUtils.toSQL(namedSQL.getScript(), namedSQL.getParams());
        PreparedStatement ps = null;
        int count = 0;
        Connection con = CurrentConnectionHolder.get();
        try {
            String script = sql.getScript();
            List<Object> params = sql.getParams();
            ps = con.prepareStatement(script);
            JdbcUtils.setParams(ps, params);
            if (this.showSql && log.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Execute SQL: ").append(script).append(", ").append("parameters: ").append(JSONUtils.toJSONString(params));
                String id = namedSQL.getId();
                if (id != null) {
                    sb.append(", ").append("id: ").append(id);
                }
                log.info(sb.toString());
            }
            count = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                throw e;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(ps);
                throw throwable;
            }
        }
        JdbcUtils.close(ps);
        return count;
    }

    private <T extends Serializable> T get(NamedSQL namedSQL, Class<T> type) throws SQLException {
        SQL sql = SQLUtils.toSQL(namedSQL.getScript(), namedSQL.getParams());
        return (T)((Serializable)JdbcUtils.execute(CurrentConnectionHolder.get(), namedSQL.getId(), sql.getScript(), sql.getParams(), new GetSQLExecuter<T>(type), this.showSql));
    }

    private <T extends Serializable> List<T> select(NamedSQL namedSQL, Class<T> type) throws SQLException {
        SQL sql = SQLUtils.toSQL(namedSQL.getScript(), namedSQL.getParams());
        return (List)JdbcUtils.execute(CurrentConnectionHolder.get(), namedSQL.getId(), sql.getScript(), sql.getParams(), new SelectSQLExecuter<T>(type), this.showSql);
    }
}

