/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.dao;

import cn.tenmg.dsql.DSQLFactory;
import cn.tenmg.dsql.factory.XMLFileDSQLFactory;
import cn.tenmg.dsql.utils.CollectionUtils;
import cn.tenmg.sqltool.dao.AbstractDao;
import cn.tenmg.sqltool.datasource.DataSourceFactory;
import cn.tenmg.sqltool.exception.IllegalConfigException;
import cn.tenmg.sqltool.exception.InitializeDataSourceException;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.utils.SQLDialectUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class DistributedDao
extends AbstractDao
implements Serializable {
    private static final long serialVersionUID = -5961378350698776883L;
    private static final String DATASOURCE_PREFIX = "sqltool.datasource.";
    private static final String DEFAULT_NAME = "default";
    private static final String DATASOURCE_REGEX = "^".concat("sqltool.datasource.".replaceAll("\\.", "\\\\.")).concat("([\\S]+\\.){0,1}[^\\.]+$");
    private static final int DATASOURCE_PREFIX_LEN = "sqltool.datasource.".length();
    private static final Map<String, DataSource> dataSources = new HashMap<String, DataSource>();
    private static DataSource defaultDataSource;
    private static volatile boolean uninitialized;
    private Properties properties;
    private DSQLFactory DSQLFactory;
    private boolean showSql;
    private int defaultBatchSize = 500;

    private DistributedDao(Properties properties) {
        this.properties = properties;
        String basePackages = properties.getProperty("sqltool.basePackages");
        String suffix = properties.getProperty("sqltool.suffix");
        this.DSQLFactory = suffix == null ? new XMLFileDSQLFactory(basePackages) : new XMLFileDSQLFactory(basePackages, suffix);
        this.showSql = Boolean.valueOf(properties.getProperty("sqltool.showSql", "false"));
        this.defaultBatchSize = Integer.valueOf(properties.getProperty("sqltool.defaultBatchSize", "500"));
    }

    public static DistributedDao build(Properties properties) {
        return new DistributedDao(properties);
    }

    @Override
    public DSQLFactory getDSQLFactory() {
        return this.DSQLFactory;
    }

    @Override
    public DataSource getDefaultDataSource() {
        if (uninitialized) {
            DistributedDao.initialized(this.properties);
        }
        return defaultDataSource;
    }

    @Override
    public DataSource getDataSource(String name) {
        if (uninitialized) {
            DistributedDao.initialized(this.properties);
        }
        return dataSources.get(name);
    }

    @Override
    protected SQLDialect getSQLDialect(DataSource dataSource) {
        if (uninitialized) {
            DistributedDao.initialized(this.properties);
        }
        return super.getSQLDialect(dataSource);
    }

    @Override
    boolean isShowSql() {
        return this.showSql;
    }

    @Override
    int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    private static synchronized void initialized(Properties properties) {
        Properties datasourceConfig;
        String name;
        if (uninitialized) {
            return;
        }
        HashMap<String, Properties> datasourceConfigs = new HashMap<String, Properties>();
        String firstName = null;
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (!key.matches(DATASOURCE_REGEX)) continue;
            String param = key.substring(DATASOURCE_PREFIX_LEN);
            int index = param.indexOf(".");
            if (index > 0) {
                name = param.substring(0, index);
                param = param.substring(index);
            } else {
                name = DEFAULT_NAME;
            }
            if (firstName == null) {
                firstName = name;
            }
            if ((datasourceConfig = (Properties)datasourceConfigs.get(name)) == null) {
                datasourceConfig = new Properties();
                datasourceConfigs.put(name, datasourceConfig);
            }
            datasourceConfig.put(param, value);
        }
        if (CollectionUtils.isEmpty(datasourceConfigs)) {
            throw new IllegalConfigException("No datasource is configured, please check the configuration");
        }
        datasourceConfig = (Properties)datasourceConfigs.get(DEFAULT_NAME);
        if (datasourceConfig == null) {
            name = firstName;
            datasourceConfig = (Properties)datasourceConfigs.get(firstName);
        } else {
            name = DEFAULT_NAME;
        }
        try {
            defaultDataSource = DataSourceFactory.createDataSource(datasourceConfig);
            dataSources.put(name, defaultDataSource);
            DistributedDao.cacheSQLDialect(defaultDataSource, SQLDialectUtils.getSQLDialect(datasourceConfig));
            datasourceConfigs.remove(name);
            for (Map.Entry entry : datasourceConfigs.entrySet()) {
                name = (String)entry.getKey();
                datasourceConfig = (Properties)entry.getValue();
                DataSource dataSource = DataSourceFactory.createDataSource(datasourceConfig);
                dataSources.put(name, dataSource);
                DistributedDao.cacheSQLDialect(dataSource, SQLDialectUtils.getSQLDialect(datasourceConfig));
            }
        }
        catch (Exception e) {
            throw new InitializeDataSourceException("An exception occurred while initializing datasource(s)", e);
        }
        uninitialized = false;
    }

    static {
        uninitialized = true;
    }
}

