/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.dialect;

import cn.tenmg.sql.paging.SQLPagingDialect;
import cn.tenmg.sql.paging.dialect.OraclePagingDialect;
import cn.tenmg.sqltool.sql.dialect.AbstractSQLDialect;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class OracleDialect
extends AbstractSQLDialect {
    private static final String UPDATE_SET_TEMPLATE = "${columnName} = ?";
    private static final String UPDATE_SET_IF_NOT_NULL_TEMPLATE = "${columnName} = NVL(?, ${columnName})";
    private static final String INSERT_IF_NOT_EXISTS = "MERGE INTO ${tableName} X USING (SELECT ${fields} FROM DUAL) Y ON (${condition}) WHEN NOT MATCHED THEN INSERT (${columns}) VALUES(${values})";
    private static final String SAVE = "MERGE INTO ${tableName} X USING (SELECT ${fields} FROM DUAL) Y ON (${condition}) WHEN MATCHED THEN UPDATE SET ${sets} WHEN NOT MATCHED THEN INSERT (${columns}) VALUES(${values})";
    private static final String FIELDS = "fields";
    private static final String CONDITION = "condition";
    private static final String SPACE = " ";
    private static final List<String> EXT_SQL_TEMPLATE_PARAM_NAMES = Arrays.asList("fields", "condition");
    private static final List<String> NEEDS_COMMA_PARAM_NAMES = Arrays.asList("fields", "columns", "values");
    private static final String SET_TEMPLATE = "X.${columnName} = Y.${columnName}";
    private static final String SET_IF_NOT_NULL_TEMPLATE = "X.${columnName} = NVL(Y.${columnName}, X.${columnName})";
    private static final OracleDialect INSTANCE = new OracleDialect();

    private OracleDialect() {
    }

    public static final OracleDialect getInstance() {
        return INSTANCE;
    }

    @Override
    String getUpdateSetTemplate() {
        return UPDATE_SET_TEMPLATE;
    }

    @Override
    String getUpdateSetIfNotNullTemplate() {
        return UPDATE_SET_IF_NOT_NULL_TEMPLATE;
    }

    @Override
    List<String> getExtSQLTemplateParamNames() {
        return EXT_SQL_TEMPLATE_PARAM_NAMES;
    }

    @Override
    String getSaveSQLTemplate() {
        return SAVE;
    }

    @Override
    String getInsertIfNotExistsSQLTemplate() {
        return INSERT_IF_NOT_EXISTS;
    }

    @Override
    List<String> getNeedsCommaParamNames() {
        return NEEDS_COMMA_PARAM_NAMES;
    }

    @Override
    void handleColumnWhenSave(String columnName, Map<String, StringBuilder> templateParams) {
        templateParams.get(FIELDS).append('?').append(SPACE).append(columnName);
        templateParams.get("columns").append(columnName);
        templateParams.get("values").append("Y.").append(columnName);
    }

    @Override
    void handleIdColumnWhenSave(String columnName, Map<String, StringBuilder> templateParams, boolean notFirst) {
        StringBuilder condition = templateParams.get(CONDITION);
        if (notFirst) {
            condition.append(" AND ");
        }
        condition.append("X.").append(columnName).append(" = ").append("Y.").append(columnName);
    }

    @Override
    String getSetTemplate() {
        return SET_TEMPLATE;
    }

    @Override
    String getSetIfNotNullTemplate() {
        return SET_IF_NOT_NULL_TEMPLATE;
    }

    @Override
    SQLPagingDialect getSQLPagingDialect() {
        return OraclePagingDialect.getInstance();
    }
}

