/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.executer;

import cn.tenmg.sqltool.sql.SQLExecuter;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class ReadOnlySQLExecuter<T>
implements SQLExecuter<T> {
    @Override
    public boolean isReadOnly() {
        return true;
    }

    protected static <T> T getValue(ResultSet rs, int columnIndex, Class<T> type) throws SQLException {
        if (BigDecimal.class.isAssignableFrom(type)) {
            return (T)rs.getBigDecimal(columnIndex);
        }
        if (Number.class.isAssignableFrom(type)) {
            Object obj = rs.getObject(columnIndex);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Number) {
                if (Double.class.isAssignableFrom(type)) {
                    obj = ((Number)obj).doubleValue();
                } else if (Float.class.isAssignableFrom(type)) {
                    obj = Float.valueOf(((Number)obj).floatValue());
                } else if (Integer.class.isAssignableFrom(type)) {
                    obj = ((Number)obj).intValue();
                } else if (Long.class.isAssignableFrom(type)) {
                    obj = ((Number)obj).longValue();
                } else if (Short.class.isAssignableFrom(type)) {
                    obj = ((Number)obj).shortValue();
                } else if (Byte.class.isAssignableFrom(type)) {
                    obj = ((Number)obj).byteValue();
                }
            }
            return (T)obj;
        }
        if (String.class.isAssignableFrom(type)) {
            return (T)rs.getString(columnIndex);
        }
        return (T)rs.getObject(columnIndex);
    }
}

