/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool;

import cn.tenmg.sqltool.Dao;
import cn.tenmg.sqltool.dao.BasicDao;
import cn.tenmg.sqltool.exception.IllegalConfigException;
import cn.tenmg.sqltool.utils.PropertiesLoaderUtils;
import java.lang.reflect.Method;
import java.util.Properties;

public abstract class SqltoolFactory {
    public static final String DAO_CONFIG_KEY = "sqltool.dao";
    public static final String DEFAULT_DAO = "cn.tenmg.sqltool.dao.BasicDao";

    public static Dao createDao(Properties properties) {
        return BasicDao.build(properties);
    }

    public static Dao createDao(String pathInClassPath) {
        try {
            Properties properties = PropertiesLoaderUtils.loadFromClassPath(pathInClassPath);
            String dao = properties.getProperty(DAO_CONFIG_KEY);
            if (dao == null) {
                dao = DEFAULT_DAO;
            }
            Class<?> cls = Class.forName(dao);
            Method method = cls.getMethod("build", Properties.class);
            return (Dao)method.invoke(null, properties);
        }
        catch (Exception e) {
            throw new IllegalConfigException("Exception occurred when building database access object", e);
        }
    }
}

