/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.transaction;

import cn.tenmg.dsql.DSQLFactory;
import cn.tenmg.dsql.NamedSQL;
import cn.tenmg.dsql.utils.CollectionUtils;
import cn.tenmg.sql.paging.SQL;
import cn.tenmg.sql.paging.utils.JDBCUtils;
import cn.tenmg.sql.paging.utils.SQLUtils;
import cn.tenmg.sqltool.exception.IllegalCallException;
import cn.tenmg.sqltool.exception.IllegalConfigException;
import cn.tenmg.sqltool.exception.SQLException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.SQLExecuter;
import cn.tenmg.sqltool.sql.executer.ExecuteUpdateSQLExecuter;
import cn.tenmg.sqltool.sql.executer.GetSQLExecuter;
import cn.tenmg.sqltool.sql.executer.SelectSQLExecuter;
import cn.tenmg.sqltool.sql.parser.DeleteDMLParser;
import cn.tenmg.sqltool.sql.parser.GetDMLParser;
import cn.tenmg.sqltool.sql.parser.InsertDMLParser;
import cn.tenmg.sqltool.sql.utils.EntityUtils;
import cn.tenmg.sqltool.transaction.CurrentConnectionHolder;
import cn.tenmg.sqltool.utils.JDBCExecuteUtils;
import cn.tenmg.sqltool.utils.JSONUtils;
import cn.tenmg.sqltool.utils.SQLDialectUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomTransactionExecutor
implements Serializable {
    private static final long serialVersionUID = -1728127905781636407L;
    private static final Logger log = LogManager.getLogger(CustomTransactionExecutor.class);
    private static ThreadLocal<SQLDialect> currentSQLDialect = new ThreadLocal();
    private DSQLFactory DSQLFactory;
    private boolean showSql = true;
    private int defaultBatchSize = 500;

    public DSQLFactory getDSQLFactory() {
        return this.DSQLFactory;
    }

    public void setDSQLFactory(DSQLFactory DSQLFactory2) {
        this.DSQLFactory = DSQLFactory2;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    public void setDefaultBatchSize(int defaultBatchSize) {
        this.defaultBatchSize = defaultBatchSize;
    }

    public void beginTransaction(Map<String, String> options) {
        currentSQLDialect.set(SQLDialectUtils.getSQLDialect(options));
        Connection con = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            CurrentConnectionHolder.set(con);
        }
        catch (java.sql.SQLException e) {
            JDBCUtils.close(con);
            throw new SQLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigException(e);
        }
    }

    public <T extends Serializable> int insert(T obj) throws java.sql.SQLException {
        DML dml = InsertDMLParser.getInstance().parse(obj.getClass());
        List<Object> params = EntityUtils.getParams(obj, dml.getFields());
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), null, dml.getSql(), params, ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int insert(List<T> rows) throws java.sql.SQLException {
        return JDBCExecuteUtils.executeBatch(CurrentConnectionHolder.get(), this.showSql, rows, InsertDMLParser.getInstance());
    }

    public <T extends Serializable> int save(T obj) throws java.sql.SQLException {
        SQL sql = currentSQLDialect.get().save(obj);
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), null, sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int save(T obj, String ... hardFields) throws java.sql.SQLException {
        SQL sql = currentSQLDialect.get().save(obj, hardFields);
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), null, sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int save(List<T> rows) throws java.sql.SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JDBCExecuteUtils.save(CurrentConnectionHolder.get(), this.showSql, rows, currentSQLDialect.get().save(((Serializable)rows.get(0)).getClass()));
    }

    public <T extends Serializable> int save(List<T> rows, String ... hardFields) throws java.sql.SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JDBCExecuteUtils.save(CurrentConnectionHolder.get(), this.showSql, rows, currentSQLDialect.get().save(((Serializable)rows.get(0)).getClass(), hardFields));
    }

    public <T extends Serializable> int hardSave(T obj) throws java.sql.SQLException {
        SQL sql = currentSQLDialect.get().hardSave(obj);
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), null, sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int hardSave(List<T> rows) throws java.sql.SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JDBCExecuteUtils.hardSave(CurrentConnectionHolder.get(), currentSQLDialect.get(), this.showSql, rows);
    }

    public <T extends Serializable> int delete(T obj) throws java.sql.SQLException {
        DML dml = DeleteDMLParser.getInstance().parse(obj.getClass());
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), null, dml.getSql(), EntityUtils.getParams(obj, dml.getFields()), ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int delete(List<T> rows) throws java.sql.SQLException {
        return JDBCExecuteUtils.executeBatch(CurrentConnectionHolder.get(), this.showSql, rows, DeleteDMLParser.getInstance());
    }

    public <T extends Serializable> T get(T obj) throws java.sql.SQLException {
        Class<?> type = obj.getClass();
        DML dml = GetDMLParser.getInstance().parse(type);
        return (T)((Serializable)JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), null, dml.getSql(), EntityUtils.getParams(obj, dml.getFields()), new GetSQLExecuter(type), this.showSql));
    }

    public <T extends Serializable> T get(Class<T> type, String dsql, Object ... params) throws java.sql.SQLException {
        return this.get(CurrentConnectionHolder.get(), this.DSQLFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> T get(Class<T> type, String dsql, Map<String, ?> params) throws java.sql.SQLException {
        return this.get(CurrentConnectionHolder.get(), this.DSQLFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(T obj) throws java.sql.SQLException {
        Class<?> type = obj.getClass();
        DML dml = GetDMLParser.getInstance().parse(type);
        return (List)JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), null, dml.getSql(), EntityUtils.getParams(obj, dml.getFields()), new SelectSQLExecuter(type), this.showSql);
    }

    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Object ... params) throws java.sql.SQLException {
        return this.select(CurrentConnectionHolder.get(), this.DSQLFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Map<String, ?> params) throws java.sql.SQLException {
        return this.select(CurrentConnectionHolder.get(), this.DSQLFactory.parse(dsql, params), type);
    }

    public boolean execute(String dsql, Object ... params) {
        return this.execute(this.DSQLFactory.parse(dsql, params));
    }

    public boolean execute(String dsql, Map<String, ?> params) {
        return this.execute(this.DSQLFactory.parse(dsql, params));
    }

    public int executeUpdate(String dsql, Object ... params) {
        return this.executeUpdate(this.DSQLFactory.parse(dsql, params));
    }

    public int executeUpdate(String dsql, Map<String, ?> params) {
        return this.executeUpdate(this.DSQLFactory.parse(dsql, params));
    }

    public void rollback() {
        Connection con = CustomTransactionExecutor.getCurrentConnection();
        try {
            con.rollback();
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
        finally {
            JDBCUtils.close((Connection)con);
            CurrentConnectionHolder.remove();
            currentSQLDialect.remove();
        }
    }

    public void commit() {
        Connection con = CustomTransactionExecutor.getCurrentConnection();
        try {
            con.commit();
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
        finally {
            JDBCUtils.close((Connection)con);
            CurrentConnectionHolder.remove();
        }
    }

    private <T extends Serializable> T get(Connection con, NamedSQL sql, Class<T> type) throws java.sql.SQLException {
        return (T)((Serializable)this.execute(con, sql, new GetSQLExecuter<T>(type)));
    }

    private <T extends Serializable> List<T> select(Connection con, NamedSQL sql, Class<T> type) throws java.sql.SQLException {
        return (List)this.execute(con, sql, new SelectSQLExecuter<T>(type));
    }

    private boolean execute(NamedSQL namedSQL) {
        Connection con = CustomTransactionExecutor.getCurrentConnection();
        SQL sql = SQLUtils.toSQL((String)namedSQL.getScript(), (Map)namedSQL.getParams());
        PreparedStatement ps = null;
        boolean rs = false;
        try {
            String script = sql.getScript();
            List params = sql.getParams();
            ps = con.prepareStatement(script);
            JDBCUtils.setParams((PreparedStatement)ps, (List)params);
            if (this.showSql) {
                StringBuilder sb = new StringBuilder();
                if (log.isInfoEnabled()) {
                    sb.append("Execute SQL: ").append(script).append(", ").append("parameters: ").append(JSONUtils.toJSONString(params));
                    String id = namedSQL.getId();
                    if (id != null) {
                        sb.append(", ").append("id: ").append(id);
                    }
                    log.info(sb.toString());
                }
            }
            rs = ps.execute();
        }
        catch (java.sql.SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (java.sql.SQLException ex) {
                    ex.printStackTrace();
                }
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(ps);
                throw throwable;
            }
        }
        JDBCUtils.close((Statement)ps);
        return rs;
    }

    private int executeUpdate(NamedSQL namedSQL) {
        Connection con = CustomTransactionExecutor.getCurrentConnection();
        SQL sql = SQLUtils.toSQL((String)namedSQL.getScript(), (Map)namedSQL.getParams());
        PreparedStatement ps = null;
        int count = 0;
        try {
            String script = sql.getScript();
            List params = sql.getParams();
            ps = con.prepareStatement(script);
            JDBCUtils.setParams((PreparedStatement)ps, (List)params);
            if (this.showSql && log.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Execute SQL: ").append(script).append(", ").append("parameters: ").append(JSONUtils.toJSONString(params));
                String id = namedSQL.getId();
                if (id != null) {
                    sb.append(", ").append("id: ").append(id);
                }
                log.info(sb.toString());
            }
            count = ps.executeUpdate();
        }
        catch (java.sql.SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (java.sql.SQLException ex) {
                    ex.printStackTrace();
                }
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(ps);
                throw throwable;
            }
        }
        JDBCUtils.close((Statement)ps);
        return count;
    }

    private <T> T execute(Connection con, NamedSQL namedSQL, SQLExecuter<T> sqlExecuter) throws java.sql.SQLException {
        SQL sql = SQLUtils.toSQL((String)namedSQL.getScript(), (Map)namedSQL.getParams());
        return JDBCExecuteUtils.execute(con, namedSQL.getId(), sql.getScript(), sql.getParams(), sqlExecuter, this.showSql);
    }

    private static Connection getCurrentConnection() {
        Connection con = CurrentConnectionHolder.get();
        if (con == null) {
            throw new IllegalCallException("You must call beginTransaction first before you call this method");
        }
        return con;
    }
}

