/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.utils;

import cn.tenmg.sqltool.SqltoolContext;
import cn.tenmg.sqltool.sql.SQLDialect;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SQLDialectUtils {
    private static final String JDBC_PRODUCT_SPLIT = ":";
    private static final String SQL_DIALECT_PREFIX = "sql.dialect.";
    private static final String GET_INSTANCE_METHOD = "getInstance";
    private static volatile Map<String, SQLDialect> URL_KEY_DIALECTS = new HashMap<String, SQLDialect>();
    private static volatile Map<String, SQLDialect> PRODUCT_KEY_DIALECTS = new HashMap<String, SQLDialect>();

    public static SQLDialect getSQLDialect(Map<String, String> options) {
        return SQLDialectUtils.getSQLDialect(options.get("url"));
    }

    public static SQLDialect getSQLDialect(Properties properties) {
        return SQLDialectUtils.getSQLDialect(properties.getProperty("url"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLDialect getSQLDialect(String url) {
        SQLDialect dialect = null;
        if (URL_KEY_DIALECTS.containsKey(url)) {
            dialect = URL_KEY_DIALECTS.get(url);
        } else if (url != null) {
            Map<String, SQLDialect> map = URL_KEY_DIALECTS;
            synchronized (map) {
                if (URL_KEY_DIALECTS.containsKey(url)) {
                    dialect = URL_KEY_DIALECTS.get(url);
                } else {
                    String tmp = url.substring(url.indexOf(JDBC_PRODUCT_SPLIT) + 1);
                    String product = tmp.substring(0, tmp.indexOf(JDBC_PRODUCT_SPLIT));
                    if (PRODUCT_KEY_DIALECTS.containsKey(product)) {
                        dialect = PRODUCT_KEY_DIALECTS.get(product);
                    } else {
                        Map<String, SQLDialect> map2 = PRODUCT_KEY_DIALECTS;
                        synchronized (map2) {
                            if (PRODUCT_KEY_DIALECTS.containsKey(product)) {
                                dialect = PRODUCT_KEY_DIALECTS.get(product);
                            } else {
                                block23: {
                                    String className = SqltoolContext.getProperty(SQL_DIALECT_PREFIX + tmp.substring(0, tmp.indexOf(JDBC_PRODUCT_SPLIT)));
                                    try {
                                        Class<?> cls = Class.forName(className);
                                        try {
                                            Method method = cls.getMethod(GET_INSTANCE_METHOD, new Class[0]);
                                            if (method == null) break block23;
                                            try {
                                                dialect = (SQLDialect)method.invoke(null, new Object[0]);
                                            }
                                            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                        catch (NoSuchMethodException | SecurityException e) {
                                            try {
                                                dialect = (SQLDialect)cls.newInstance();
                                            }
                                            catch (IllegalAccessException | InstantiationException ex) {
                                                ex.printStackTrace();
                                            }
                                        }
                                    }
                                    catch (ClassNotFoundException e) {
                                        e.printStackTrace();
                                    }
                                }
                                PRODUCT_KEY_DIALECTS.put(product, dialect);
                            }
                        }
                    }
                    PRODUCT_KEY_DIALECTS.put(url, dialect);
                }
            }
        }
        return dialect;
    }
}

