/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.dao;

import cn.tenmg.dsl.Script;
import cn.tenmg.dsql.NamedSQL;
import cn.tenmg.dsql.utils.CollectionUtils;
import cn.tenmg.sql.paging.SQLMetaData;
import cn.tenmg.sql.paging.utils.JDBCUtils;
import cn.tenmg.sql.paging.utils.SQLUtils;
import cn.tenmg.sqltool.Dao;
import cn.tenmg.sqltool.Transaction;
import cn.tenmg.sqltool.data.Page;
import cn.tenmg.sqltool.exception.DetermineSQLDialectException;
import cn.tenmg.sqltool.exception.IllegalConfigException;
import cn.tenmg.sqltool.exception.TransactionException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.DMLParser;
import cn.tenmg.sqltool.sql.MergeSQL;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.SQLExecuter;
import cn.tenmg.sqltool.sql.UpdateSQL;
import cn.tenmg.sqltool.sql.executer.ExecuteSQLExecuter;
import cn.tenmg.sqltool.sql.executer.ExecuteUpdateSQLExecuter;
import cn.tenmg.sqltool.sql.executer.GetSQLExecuter;
import cn.tenmg.sqltool.sql.executer.LongResultSQLExecuter;
import cn.tenmg.sqltool.sql.executer.SelectSQLExecuter;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.sql.parser.DeleteDMLParser;
import cn.tenmg.sqltool.sql.parser.GetDMLParser;
import cn.tenmg.sqltool.sql.parser.InsertDMLParser;
import cn.tenmg.sqltool.sql.parser.UpdateDMLParser;
import cn.tenmg.sqltool.sql.utils.EntityUtils;
import cn.tenmg.sqltool.transaction.CurrentConnectionHolder;
import cn.tenmg.sqltool.transaction.TransactionExecutor;
import cn.tenmg.sqltool.utils.JDBCExecuteUtils;
import cn.tenmg.sqltool.utils.SQLDialectUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDao
implements Dao {
    private static final Logger log = LogManager.getLogger(AbstractDao.class);
    private static final Map<DataSource, SQLDialect> DIALECTS = new HashMap<DataSource, SQLDialect>();

    abstract boolean isShowSql();

    abstract int getDefaultBatchSize();

    protected static synchronized void cacheSQLDialect(DataSource dataSource, SQLDialect dialect) {
        DIALECTS.put(dataSource, dialect);
    }

    protected SQLDialect getSQLDialect(DataSource dataSource) {
        SQLDialect dialect = DIALECTS.get(dataSource);
        if (dialect == null) {
            Connection con = null;
            try {
                con = dataSource.getConnection();
                con.setReadOnly(true);
                String url = con.getMetaData().getURL();
                dialect = SQLDialectUtils.getSQLDialect(url);
                AbstractDao.cacheSQLDialect(dataSource, dialect);
            }
            catch (SQLException e) {
                throw new DetermineSQLDialectException("SQLException occured while getting url of the dataSource", e);
            }
            finally {
                JDBCUtils.close((Connection)con);
            }
        }
        return dialect;
    }

    @Override
    public <T extends Serializable> int insert(T obj) {
        return this.insert(this.getDefaultDataSource(), obj);
    }

    @Override
    public <T extends Serializable> int insert(DataSource dataSource, T obj) {
        return this.execute(dataSource, obj, InsertDMLParser.getInstance(), ExecuteUpdateSQLExecuter.getInstance());
    }

    @Override
    public <T extends Serializable> int insert(List<T> rows) {
        return this.insert(this.getDefaultDataSource(), rows);
    }

    @Override
    public <T extends Serializable> int insert(DataSource dataSource, List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return this.execute(dataSource, rows, InsertDMLParser.getInstance());
    }

    @Override
    public <T extends Serializable> void insertBatch(List<T> rows) {
        this.insertBatch(rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void insertBatch(DataSource dataSource, List<T> rows) {
        this.insertBatch(dataSource, rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void insertBatch(List<T> rows, int batchSize) {
        this.insertBatch(this.getDefaultDataSource(), rows, batchSize);
    }

    @Override
    public <T extends Serializable> void insertBatch(DataSource dataSource, List<T> rows, int batchSize) {
        if (!CollectionUtils.isEmpty(rows)) {
            this.executeBatch(dataSource, rows, InsertDMLParser.getInstance(), batchSize);
        }
    }

    @Override
    public <T extends Serializable> int update(T obj) {
        return this.update(this.getDefaultDataSource(), obj);
    }

    @Override
    public <T extends Serializable> int update(DataSource dataSource, T obj) {
        Script<List<Object>> sql = this.getSQLDialect(dataSource).update(obj);
        return this.execute(dataSource, null, sql.getValue(), (List)sql.getParams(), ExecuteUpdateSQLExecuter.getInstance());
    }

    @Override
    public <T extends Serializable> int update(T obj, String ... hardFields) {
        return this.update(this.getDefaultDataSource(), obj, hardFields);
    }

    @Override
    public <T extends Serializable> int update(DataSource dataSource, T obj, String ... hardFields) {
        Script<List<Object>> sql = this.getSQLDialect(dataSource).update(obj, hardFields);
        return this.execute(dataSource, null, sql.getValue(), (List)sql.getParams(), ExecuteUpdateSQLExecuter.getInstance());
    }

    @Override
    public <T extends Serializable> int update(List<T> rows) {
        return this.update(this.getDefaultDataSource(), rows);
    }

    @Override
    public <T extends Serializable> int update(DataSource dataSource, List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return AbstractDao.update(dataSource, this.isShowSql(), rows, this.getSQLDialect(dataSource).update(((Serializable)rows.get(0)).getClass()));
    }

    @Override
    public <T extends Serializable> int update(List<T> rows, String ... hardFields) {
        return this.update(this.getDefaultDataSource(), rows, hardFields);
    }

    @Override
    public <T extends Serializable> int update(DataSource dataSource, List<T> rows, String ... hardFields) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return AbstractDao.update(dataSource, this.isShowSql(), rows, this.getSQLDialect(dataSource).update(((Serializable)rows.get(0)).getClass(), hardFields));
    }

    @Override
    public <T extends Serializable> void updateBatch(List<T> rows) {
        this.updateBatch(rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void updateBatch(DataSource dataSource, List<T> rows) {
        this.updateBatch(dataSource, rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void updateBatch(List<T> rows, String ... hardFields) {
        this.updateBatch(rows, this.getDefaultBatchSize(), hardFields);
    }

    @Override
    public <T extends Serializable> void updateBatch(DataSource dataSource, List<T> rows, String ... hardFields) {
        this.updateBatch(dataSource, rows, this.getDefaultBatchSize(), hardFields);
    }

    @Override
    public <T extends Serializable> void updateBatch(List<T> rows, int batchSize) {
        this.updateBatch(this.getDefaultDataSource(), rows, batchSize);
    }

    @Override
    public <T extends Serializable> void updateBatch(DataSource dataSource, List<T> rows, int batchSize) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        this.updateBatch(dataSource, rows, batchSize, this.getSQLDialect(dataSource).update(((Serializable)rows.get(0)).getClass()));
    }

    @Override
    public <T extends Serializable> void updateBatch(List<T> rows, int batchSize, String ... hardFields) {
        this.updateBatch(this.getDefaultDataSource(), batchSize, rows, hardFields);
    }

    @Override
    public <T extends Serializable> void updateBatch(DataSource dataSource, List<T> rows, int batchSize, String ... hardFields) {
        this.updateBatch(dataSource, batchSize, rows, hardFields);
    }

    @Override
    public <T extends Serializable> int hardUpdate(T obj) {
        return this.hardUpdate(this.getDefaultDataSource(), obj);
    }

    @Override
    public <T extends Serializable> int hardUpdate(DataSource dataSource, T obj) {
        return this.execute(dataSource, obj, UpdateDMLParser.getInstance(), ExecuteUpdateSQLExecuter.getInstance());
    }

    @Override
    public <T extends Serializable> int hardUpdate(List<T> rows) {
        return this.hardUpdate(this.getDefaultDataSource(), rows);
    }

    @Override
    public <T extends Serializable> int hardUpdate(DataSource dataSource, List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        Connection con = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            con.setReadOnly(false);
            int count = JDBCExecuteUtils.hardUpdate(con, this.isShowSql(), rows);
            con.commit();
            int n = count;
            return n;
        }
        catch (SQLException e) {
            try {
                con.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            throw new cn.tenmg.sqltool.exception.SQLException(e);
        }
        finally {
            JDBCUtils.close((Connection)con);
        }
    }

    @Override
    public <T extends Serializable> void hardUpdateBatch(List<T> rows) {
        this.hardUpdateBatch(rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void hardUpdateBatch(DataSource dataSource, List<T> rows) {
        this.hardUpdateBatch(dataSource, rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void hardUpdateBatch(List<T> rows, int batchSize) {
        this.hardUpdateBatch(this.getDefaultDataSource(), rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void hardUpdateBatch(DataSource dataSource, List<T> rows, int batchSize) {
        if (!CollectionUtils.isEmpty(rows)) {
            DML dml = UpdateDMLParser.getInstance().parse(((Serializable)rows.get(0)).getClass());
            this.executeBatch(dataSource, dml.getSql(), rows, dml.getFields(), batchSize);
        }
    }

    @Override
    public <T extends Serializable> int save(T obj) {
        return this.save(this.getDefaultDataSource(), obj);
    }

    @Override
    public <T extends Serializable> int save(DataSource dataSource, T obj) {
        Script<List<Object>> sql = this.getSQLDialect(dataSource).save(obj);
        return this.execute(dataSource, null, sql.getValue(), (List)sql.getParams(), ExecuteUpdateSQLExecuter.getInstance());
    }

    @Override
    public <T extends Serializable> int save(T obj, String ... hardFields) {
        return this.save(this.getDefaultDataSource(), obj, hardFields);
    }

    @Override
    public <T extends Serializable> int save(DataSource dataSource, T obj, String ... hardFields) {
        Script<List<Object>> sql = this.getSQLDialect(dataSource).save(obj, hardFields);
        return this.execute(dataSource, null, sql.getValue(), (List)sql.getParams(), ExecuteUpdateSQLExecuter.getInstance());
    }

    @Override
    public <T extends Serializable> int save(List<T> rows) {
        return this.save(this.getDefaultDataSource(), rows);
    }

    @Override
    public <T extends Serializable> int save(DataSource dataSource, List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return AbstractDao.save(dataSource, this.isShowSql(), rows, this.getSQLDialect(dataSource).save(((Serializable)rows.get(0)).getClass()));
    }

    @Override
    public <T extends Serializable> int save(List<T> rows, String ... hardFields) {
        return this.save(this.getDefaultDataSource(), rows, hardFields);
    }

    @Override
    public <T extends Serializable> int save(DataSource dataSource, List<T> rows, String ... hardFields) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return AbstractDao.save(dataSource, this.isShowSql(), rows, this.getSQLDialect(dataSource).save(((Serializable)rows.get(0)).getClass(), hardFields));
    }

    @Override
    public <T extends Serializable> void saveBatch(List<T> rows) {
        this.saveBatch(rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void saveBatch(DataSource dataSource, List<T> rows) {
        this.saveBatch(dataSource, rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void saveBatch(List<T> rows, String ... hardFields) {
        this.saveBatch(rows, this.getDefaultBatchSize(), hardFields);
    }

    @Override
    public <T extends Serializable> void saveBatch(DataSource dataSource, List<T> rows, String ... hardFields) {
        this.saveBatch(dataSource, rows, this.getDefaultBatchSize(), hardFields);
    }

    @Override
    public <T extends Serializable> void saveBatch(List<T> rows, int batchSize) {
        this.saveBatch(this.getDefaultDataSource(), rows, batchSize);
    }

    @Override
    public <T extends Serializable> void saveBatch(DataSource dataSource, List<T> rows, int batchSize) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        this.saveBatch(dataSource, rows, batchSize, this.getSQLDialect(dataSource).save(((Serializable)rows.get(0)).getClass()));
    }

    @Override
    public <T extends Serializable> void saveBatch(List<T> rows, int batchSize, String ... hardFields) {
        this.saveBatch(this.getDefaultDataSource(), rows, batchSize, hardFields);
    }

    @Override
    public <T extends Serializable> void saveBatch(DataSource dataSource, List<T> rows, int batchSize, String ... hardFields) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        this.saveBatch(dataSource, rows, batchSize, this.getSQLDialect(dataSource).save(((Serializable)rows.get(0)).getClass(), hardFields));
    }

    @Override
    public <T extends Serializable> int hardSave(T obj) {
        return this.hardSave(this.getDefaultDataSource(), obj);
    }

    @Override
    public <T extends Serializable> int hardSave(DataSource dataSource, T obj) {
        Script<List<Object>> sql = this.getSQLDialect(dataSource).hardSave(obj);
        return this.execute(dataSource, null, sql.getValue(), (List)sql.getParams(), ExecuteUpdateSQLExecuter.getInstance());
    }

    @Override
    public <T extends Serializable> int hardSave(List<T> rows) {
        return this.hardSave(this.getDefaultDataSource(), rows);
    }

    @Override
    public <T extends Serializable> int hardSave(DataSource dataSource, List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        SQLDialect dialect = this.getSQLDialect(dataSource);
        Connection con = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            con.setReadOnly(false);
            int count = JDBCExecuteUtils.hardSave(con, dialect, this.isShowSql(), rows);
            con.commit();
            int n = count;
            return n;
        }
        catch (SQLException e) {
            try {
                con.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            throw new cn.tenmg.sqltool.exception.SQLException(e);
        }
        finally {
            JDBCUtils.close((Connection)con);
        }
    }

    @Override
    public <T extends Serializable> void hardSaveBatch(List<T> rows) {
        this.hardSaveBatch(rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void hardSaveBatch(DataSource dataSource, List<T> rows) {
        this.hardSaveBatch(dataSource, rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void hardSaveBatch(List<T> rows, int batchSize) {
        this.hardSaveBatch(this.getDefaultDataSource(), rows, batchSize);
    }

    @Override
    public <T extends Serializable> void hardSaveBatch(DataSource dataSource, List<T> rows, int batchSize) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        SQLDialect dialect = this.getSQLDialect(dataSource);
        Connection con = null;
        Statement ps = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            con.setReadOnly(false);
            MergeSQL mergeSql = dialect.hardSave(((Serializable)rows.get(0)).getClass());
            String sql = mergeSql.getScript();
            List<FieldMeta> fieldMetas = mergeSql.getFieldMetas();
            if (this.isShowSql() && log.isInfoEnabled()) {
                log.info("Execute SQL: ".concat(sql));
            }
            ps = con.prepareStatement(sql);
            int size = rows.size();
            int times = (int)Math.ceil((double)size / (double)batchSize);
            for (int current = 0; current < times; ++current) {
                int end = (current + 1) * batchSize;
                int last = end < size ? end : size;
                for (int i = current * batchSize; i < last; ++i) {
                    JDBCExecuteUtils.addBatch((PreparedStatement)ps, fieldMetas, rows.get(i));
                }
                ps.executeBatch();
                con.commit();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            try {
                con.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            throw new cn.tenmg.sqltool.exception.SQLException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.clearBatch();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            JDBCUtils.close((Connection)con);
        }
    }

    @Override
    public <T extends Serializable> int delete(T obj) {
        return this.delete(this.getDefaultDataSource(), obj);
    }

    @Override
    public <T extends Serializable> int delete(DataSource dataSource, T obj) {
        return this.execute(dataSource, obj, DeleteDMLParser.getInstance(), ExecuteUpdateSQLExecuter.getInstance());
    }

    @Override
    public <T extends Serializable> int delete(List<T> rows) {
        return this.delete(this.getDefaultDataSource(), rows);
    }

    @Override
    public <T extends Serializable> int delete(DataSource dataSource, List<T> rows) {
        return this.execute(dataSource, rows, DeleteDMLParser.getInstance());
    }

    @Override
    public <T extends Serializable> void deleteBatch(List<T> rows) {
        this.deleteBatch(this.getDefaultDataSource(), rows);
    }

    @Override
    public <T extends Serializable> void deleteBatch(DataSource dataSource, List<T> rows) {
        this.deleteBatch(dataSource, rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void deleteBatch(List<T> rows, int batchSize) {
        this.deleteBatch(this.getDefaultDataSource(), rows, batchSize);
    }

    @Override
    public <T extends Serializable> void deleteBatch(DataSource dataSource, List<T> rows, int batchSize) {
        if (!CollectionUtils.isEmpty(rows)) {
            this.executeBatch(dataSource, rows, DeleteDMLParser.getInstance(), batchSize);
        }
    }

    @Override
    public <T extends Serializable> T get(T obj) {
        return this.get(this.getDefaultDataSource(), obj);
    }

    @Override
    public <T extends Serializable> T get(DataSource dataSource, T obj) {
        return (T)((Serializable)this.execute(dataSource, obj, GetDMLParser.getInstance(), new GetSQLExecuter(obj.getClass())));
    }

    @Override
    public <T extends Serializable> T get(Class<T> type, String dsql, Object ... params) {
        return this.get(this.getDefaultDataSource(), this.parse(dsql, params), type);
    }

    @Override
    public <T extends Serializable> T get(DataSource dataSource, Class<T> type, String dsql, Object ... params) {
        return this.get(dataSource, this.parse(dsql, params), type);
    }

    @Override
    public <T extends Serializable> T get(Class<T> type, String dsql, Map<String, ?> params) {
        return this.get(this.getDefaultDataSource(), this.parse(dsql, params), type);
    }

    @Override
    public <T extends Serializable> T get(DataSource dataSource, Class<T> type, String dsql, Map<String, ?> params) {
        return this.get(dataSource, this.parse(dsql, params), type);
    }

    @Override
    public <T extends Serializable> List<T> select(T obj) {
        return this.select(this.getDefaultDataSource(), obj);
    }

    @Override
    public <T extends Serializable> List<T> select(DataSource dataSource, T obj) {
        Class<?> type = obj.getClass();
        Script<List<Object>> sql = EntityUtils.parseSelect(obj);
        return (List)this.execute(dataSource, null, sql.getValue(), (List)sql.getParams(), new SelectSQLExecuter(type));
    }

    @Override
    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Object ... params) {
        return this.select(this.getDefaultDataSource(), this.parse(dsql, params), type);
    }

    @Override
    public <T extends Serializable> List<T> select(DataSource dataSource, Class<T> type, String dsql, Object ... params) {
        return this.select(dataSource, this.parse(dsql, params), type);
    }

    @Override
    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Map<String, ?> params) {
        return this.select(this.getDefaultDataSource(), this.parse(dsql, params), type);
    }

    @Override
    public <T extends Serializable> List<T> select(DataSource dataSource, Class<T> type, String dsql, Map<String, ?> params) {
        return this.select(dataSource, this.parse(dsql, params), type);
    }

    @Override
    public <T extends Serializable> Page<T> page(Class<T> type, String dsql, long currentPage, int pageSize, Object ... params) {
        return this.page(this.getDefaultDataSource(), type, dsql, currentPage, pageSize, params);
    }

    @Override
    public <T extends Serializable> Page<T> page(DataSource dataSource, Class<T> type, String dsql, long currentPage, int pageSize, Object ... params) {
        return this.page(dataSource, this.parse(dsql, params), currentPage, pageSize, type);
    }

    @Override
    public <T extends Serializable> Page<T> page(Class<T> type, String dsql, String cntDsql, long currentPage, int pageSize, Object ... params) {
        return this.page(this.getDefaultDataSource(), type, dsql, cntDsql, currentPage, pageSize, params);
    }

    @Override
    public <T extends Serializable> Page<T> page(DataSource dataSource, Class<T> type, String dsql, String cntDsql, long currentPage, int pageSize, Object ... params) {
        return this.page(dataSource, this.parse(dsql, params), this.parse(cntDsql, params), currentPage, pageSize, type);
    }

    @Override
    public <T extends Serializable> Page<T> page(Class<T> type, String dsql, long currentPage, int pageSize, Map<String, Object> params) {
        return this.page(this.getDefaultDataSource(), type, dsql, currentPage, pageSize, params);
    }

    @Override
    public <T extends Serializable> Page<T> page(DataSource dataSource, Class<T> type, String dsql, long currentPage, int pageSize, Map<String, Object> params) {
        return this.page(dataSource, this.parse(dsql, params), currentPage, pageSize, type);
    }

    @Override
    public <T extends Serializable> Page<T> page(Class<T> type, String dsql, String cntDsql, long currentPage, int pageSize, Map<String, Object> params) {
        return this.page(this.getDefaultDataSource(), type, dsql, cntDsql, currentPage, pageSize, params);
    }

    @Override
    public <T extends Serializable> Page<T> page(DataSource dataSource, Class<T> type, String dsql, String cntDsql, long currentPage, int pageSize, Map<String, Object> params) {
        return this.page(dataSource, this.parse(dsql, params), this.parse(cntDsql, params), currentPage, pageSize, type);
    }

    @Override
    public boolean execute(String dsql, Object ... params) {
        return this.execute(this.getDefaultDataSource(), this.parse(dsql, params));
    }

    @Override
    public boolean execute(DataSource dataSource, String dsql, Object ... params) {
        return this.execute(dataSource, this.parse(dsql, params));
    }

    @Override
    public boolean execute(String dsql, Map<String, ?> params) {
        return this.execute(this.getDefaultDataSource(), this.parse(dsql, params));
    }

    @Override
    public boolean execute(DataSource dataSource, String dsql, Map<String, ?> params) {
        return this.execute(dataSource, this.parse(dsql, params));
    }

    @Override
    public int executeUpdate(String dsql, Object ... params) {
        return this.executeUpdate(this.getDefaultDataSource(), this.parse(dsql, params));
    }

    @Override
    public int executeUpdate(DataSource dataSource, String dsql, Object ... params) {
        return this.executeUpdate(dataSource, this.parse(dsql, params));
    }

    @Override
    public int executeUpdate(String dsql, Map<String, ?> params) {
        return this.executeUpdate(this.getDefaultDataSource(), this.parse(dsql, params));
    }

    @Override
    public int executeUpdate(DataSource dataSource, String dsql, Map<String, ?> params) {
        return this.executeUpdate(dataSource, this.parse(dsql, params));
    }

    @Override
    public void execute(Transaction transaction) {
        this.execute(this.getDefaultDataSource(), transaction);
    }

    @Override
    public void execute(DataSource dataSource, Transaction transaction) {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            con.setReadOnly(false);
            CurrentConnectionHolder.set(con);
            transaction.execute(new TransactionExecutor(this.isShowSql(), this.getDSQLFactory(), this.getSQLDialect(dataSource)));
            con.commit();
        }
        catch (Exception e) {
            try {
                con.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            if (e instanceof ClassNotFoundException) {
                throw new IllegalConfigException(e);
            }
            if (e instanceof SQLException) {
                throw new cn.tenmg.sqltool.exception.SQLException(e);
            }
            throw new TransactionException(e);
        }
        finally {
            JDBCUtils.close((Connection)con);
            CurrentConnectionHolder.remove();
        }
    }

    private NamedSQL parse(String dsql, Object ... params) {
        return this.getDSQLFactory().parse(dsql, params);
    }

    private NamedSQL parse(String dsql, Map<String, ?> params) {
        return this.getDSQLFactory().parse(dsql, params);
    }

    private Script<List<Object>> toJDBC(NamedSQL namedSQL) {
        return this.getDSQLFactory().toJDBC(namedSQL);
    }

    private Script<List<Object>> toJDBC(String namedscript, Map<String, ?> params) {
        return this.getDSQLFactory().toJDBC(namedscript, params);
    }

    private <T> T execute(DataSource dataSource, Object obj, DMLParser dmlParser, SQLExecuter<T> sqlExecuter) {
        DML dml = dmlParser.parse(obj.getClass());
        return this.execute(dataSource, null, dml.getSql(), EntityUtils.getParams(obj, dml.getFields()), sqlExecuter);
    }

    private <T> T execute(DataSource dataSource, String id, String sql, List<Object> params, SQLExecuter<T> sqlExecuter) {
        Connection con = null;
        T result = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(true);
            con.setReadOnly(sqlExecuter.isReadOnly());
            result = JDBCExecuteUtils.execute(con, id, sql, params, sqlExecuter, this.isShowSql());
        }
        catch (SQLException e) {
            throw new cn.tenmg.sqltool.exception.SQLException(e);
        }
        finally {
            JDBCUtils.close((Connection)con);
        }
        return result;
    }

    private <T extends Serializable> int execute(DataSource dataSource, List<T> rows, DMLParser dmlParser) {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            con.setReadOnly(false);
            int count = JDBCExecuteUtils.executeBatch(con, this.isShowSql(), rows, dmlParser);
            con.commit();
            int n = count;
            return n;
        }
        catch (SQLException e) {
            try {
                con.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            throw new cn.tenmg.sqltool.exception.SQLException(e);
        }
        finally {
            JDBCUtils.close((Connection)con);
        }
    }

    private <T extends Serializable> void executeBatch(DataSource dataSource, List<T> rows, DMLParser dmlParser, int batchSize) {
        DML dml = dmlParser.parse(((Serializable)rows.get(0)).getClass());
        this.executeBatch(dataSource, dml.getSql(), rows, dml.getFields(), batchSize);
    }

    private <T extends Serializable> void executeBatch(DataSource dataSource, String sql, List<T> rows, List<Field> fields, int batchSize) {
        Connection con = null;
        Statement ps = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            con.setReadOnly(false);
            ps = con.prepareStatement(sql);
            if (this.isShowSql() && log.isInfoEnabled()) {
                log.info("Execute SQL: ".concat(sql));
            }
            int size = rows.size();
            int times = (int)Math.ceil((double)size / (double)batchSize);
            for (int current = 0; current < times; ++current) {
                int end = (current + 1) * batchSize;
                int last = end < size ? end : size;
                for (int i = current * batchSize; i < last; ++i) {
                    JDBCExecuteUtils.addBatch((PreparedStatement)ps, rows.get(i), fields);
                }
                ps.executeBatch();
                con.commit();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            try {
                con.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            throw new cn.tenmg.sqltool.exception.SQLException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.clearBatch();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            JDBCUtils.close((Connection)con);
        }
    }

    private static <T> int update(DataSource dataSource, boolean showSql, List<T> rows, UpdateSQL updateSQL) {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            con.setReadOnly(false);
            int count = JDBCExecuteUtils.update(con, showSql, rows, updateSQL);
            con.commit();
            int n = count;
            return n;
        }
        catch (SQLException e) {
            try {
                con.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            throw new cn.tenmg.sqltool.exception.SQLException(e);
        }
        finally {
            JDBCUtils.close((Connection)con);
        }
    }

    private <T extends Serializable> void updateBatch(DataSource dataSource, int batchSize, List<T> rows, String ... hardFields) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        this.updateBatch(dataSource, rows, batchSize, this.getSQLDialect(dataSource).update(((Serializable)rows.get(0)).getClass(), hardFields));
    }

    private <T> void updateBatch(DataSource dataSource, List<T> rows, int batchSize, UpdateSQL updateSql) {
        Connection con = null;
        Statement ps = null;
        try {
            int size = rows.size();
            int current = 0;
            int times = (int)Math.ceil((double)size / (double)batchSize);
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            con.setReadOnly(false);
            String sql = updateSql.getScript();
            List<Field> fields = updateSql.getFields();
            if (this.isShowSql() && log.isInfoEnabled()) {
                log.info("Execute SQL: ".concat(sql));
            }
            ps = con.prepareStatement(sql);
            while (current < times) {
                int end = (current + 1) * batchSize;
                int last = end < size ? end : size;
                for (int i = current * batchSize; i < last; ++i) {
                    JDBCExecuteUtils.addBatch((PreparedStatement)ps, rows.get(i), fields);
                }
                ps.executeBatch();
                con.commit();
                ps.clearBatch();
                ++current;
            }
        }
        catch (SQLException e) {
            try {
                con.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            throw new cn.tenmg.sqltool.exception.SQLException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.clearBatch();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            JDBCUtils.close((Connection)con);
        }
    }

    private static <T> int save(DataSource dataSource, boolean showSql, List<T> rows, MergeSQL mergeSql) {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            con.setReadOnly(false);
            int count = JDBCExecuteUtils.save(con, showSql, rows, mergeSql);
            con.commit();
            int n = count;
            return n;
        }
        catch (SQLException e) {
            try {
                con.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            throw new cn.tenmg.sqltool.exception.SQLException(e);
        }
        finally {
            JDBCUtils.close((Connection)con);
        }
    }

    private <T> void saveBatch(DataSource dataSource, List<T> rows, int batchSize, MergeSQL mergeSql) {
        Connection con = null;
        Statement ps = null;
        try {
            int size = rows.size();
            int current = 0;
            int times = (int)Math.ceil((double)size / (double)batchSize);
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            con.setReadOnly(false);
            String sql = mergeSql.getScript();
            List<FieldMeta> fieldMetas = mergeSql.getFieldMetas();
            if (this.isShowSql() && log.isInfoEnabled()) {
                log.info("Execute SQL: ".concat(sql));
            }
            ps = con.prepareStatement(sql);
            while (current < times) {
                int end = (current + 1) * batchSize;
                int last = end < size ? end : size;
                for (int i = current * batchSize; i < last; ++i) {
                    JDBCExecuteUtils.addBatch((PreparedStatement)ps, fieldMetas, rows.get(i));
                }
                ps.executeBatch();
                con.commit();
                ps.clearBatch();
                ++current;
            }
        }
        catch (SQLException e) {
            try {
                con.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            throw new cn.tenmg.sqltool.exception.SQLException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.clearBatch();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            JDBCUtils.close((Connection)con);
        }
    }

    private <T extends Serializable> T get(DataSource dataSource, NamedSQL namedSQL, Class<T> type) {
        return (T)((Serializable)this.execute(dataSource, namedSQL, new GetSQLExecuter<T>(type)));
    }

    private <T> T execute(DataSource dataSource, NamedSQL namedSQL, SQLExecuter<T> sqlExecuter) {
        Script<List<Object>> sql = this.toJDBC(namedSQL);
        return this.execute(dataSource, namedSQL.getId(), sql.getValue(), (List)sql.getParams(), sqlExecuter);
    }

    private <T extends Serializable> List<T> select(DataSource dataSource, NamedSQL namedSQL, Class<T> type) {
        return (List)this.execute(dataSource, namedSQL, new SelectSQLExecuter<T>(type));
    }

    private boolean execute(DataSource dataSource, NamedSQL namedSQL) {
        return this.execute(dataSource, namedSQL, ExecuteSQLExecuter.getInstance());
    }

    private int executeUpdate(DataSource dataSource, NamedSQL namedSQL) {
        return this.execute(dataSource, namedSQL, ExecuteUpdateSQLExecuter.getInstance());
    }

    private <T extends Serializable> Page<T> page(DataSource dataSource, NamedSQL namedSQL, long currentPage, int pageSize, Class<T> type) {
        Connection con = null;
        Page page = new Page();
        page.setCurrentPage(currentPage);
        page.setPageSize(pageSize);
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(true);
            con.setReadOnly(true);
            boolean showSql = this.isShowSql();
            SQLDialect dialect = this.getSQLDialect(dataSource);
            String id = namedSQL.getId();
            String script = namedSQL.getScript();
            Map params = namedSQL.getParams();
            SQLMetaData sqlMetaData = SQLUtils.getSQLMetaData((String)script);
            Script<List<Object>> sql = this.toJDBC(dialect.countSql(script, sqlMetaData), params);
            Long total = JDBCExecuteUtils.execute(con, id, sql.getValue(), (List)sql.getParams(), LongResultSQLExecuter.getInstance(), showSql);
            page.setTotal(total);
            if (total != null && total > 0L) {
                page.setTotalPage(total % (long)pageSize == 0L ? total / (long)pageSize : total / (long)pageSize + 1L);
                sql = this.toJDBC(dialect.pageSql(con, script, params, sqlMetaData, pageSize, currentPage), params);
                page.setRows((List)JDBCExecuteUtils.execute(con, id, sql.getValue(), (List)sql.getParams(), new SelectSQLExecuter<T>(type), showSql));
            } else {
                page.setTotalPage(0L);
            }
        }
        catch (SQLException e) {
            throw new cn.tenmg.sqltool.exception.SQLException(e);
        }
        finally {
            JDBCUtils.close((Connection)con);
        }
        return page;
    }

    private <T extends Serializable> Page<T> page(DataSource dataSource, NamedSQL namedSQL, NamedSQL countNamedSQL, long currentPage, int pageSize, Class<T> type) {
        Connection con = null;
        Page page = new Page();
        page.setCurrentPage(currentPage);
        page.setPageSize(pageSize);
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(true);
            con.setReadOnly(true);
            boolean showSql = this.isShowSql();
            String script = countNamedSQL.getScript();
            SQLDialect dialect = this.getSQLDialect(dataSource);
            Script<List<Object>> sql = this.toJDBC(dialect.countSql(script, SQLUtils.getSQLMetaData((String)script)), countNamedSQL.getParams());
            Long total = JDBCExecuteUtils.execute(con, countNamedSQL.getId(), sql.getValue(), (List)sql.getParams(), LongResultSQLExecuter.getInstance(), showSql);
            page.setTotal(total);
            if (total != null && total > 0L) {
                page.setTotalPage(total % (long)pageSize == 0L ? total / (long)pageSize : total / (long)pageSize + 1L);
                script = namedSQL.getScript();
                sql = this.toJDBC(dialect.pageSql(con, script, namedSQL.getParams(), SQLUtils.getSQLMetaData((String)script), pageSize, currentPage), namedSQL.getParams());
                page.setRows((List)JDBCExecuteUtils.execute(con, namedSQL.getId(), sql.getValue(), (List)sql.getParams(), new SelectSQLExecuter<T>(type), showSql));
            } else {
                page.setTotalPage(0L);
            }
        }
        catch (SQLException e) {
            throw new cn.tenmg.sqltool.exception.SQLException(e);
        }
        finally {
            JDBCUtils.close((Connection)con);
        }
        return page;
    }
}

