/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool;

import cn.tenmg.dsl.utils.PropertiesLoaderUtils;
import cn.tenmg.sqltool.Dao;
import cn.tenmg.sqltool.exception.IllegalConfigException;
import java.util.Properties;

public abstract class SqltoolFactory {
    public static final String DAO_CONFIG_KEY = "sqltool.dao";
    public static final String DEFAULT_DAO = "cn.tenmg.sqltool.dao.BasicDao";

    public static Dao createDao(Properties properties) {
        try {
            String dao = properties.getProperty(DAO_CONFIG_KEY);
            if (dao == null) {
                dao = DEFAULT_DAO;
            }
            return (Dao)Class.forName(dao).getMethod("build", Properties.class).invoke(null, properties);
        }
        catch (Exception e) {
            throw new IllegalConfigException("Exception occurred when building database access object", e);
        }
    }

    public static Dao createDao(String pathInClassPath) {
        Properties properties;
        try {
            properties = PropertiesLoaderUtils.loadFromClassPath((String)pathInClassPath);
        }
        catch (Exception e) {
            throw new IllegalConfigException("Exception occurred when building database access object", e);
        }
        return SqltoolFactory.createDao(properties);
    }
}

