/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.dialect;

import cn.tenmg.sql.paging.SQLPagingDialect;
import cn.tenmg.sql.paging.dialect.MySQLPagingDialect;
import cn.tenmg.sqltool.sql.dialect.AbstractSQLDialect;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MySQLDialect
extends AbstractSQLDialect {
    private static final String UPDATE_SET_TEMPLATE = "${columnName} = ?";
    private static final String UPDATE_SET_IF_NOT_NULL_TEMPLATE = "${columnName} = IFNULL(?, ${columnName})";
    private static final String INSERT_IF_NOT_EXISTS = "INSERT IGNORE INTO ${tableName} (${columns}) VALUES (${values})";
    private static final String SAVE = "INSERT INTO ${tableName} (${columns}) VALUES (${values}) ON DUPLICATE KEY UPDATE ${sets}";
    private static final List<String> NEEDS_COMMA_PARAM_NAMES = Arrays.asList("columns", "values");
    private static final String SET_TEMPLATE = "${columnName} = VALUES(${columnName})";
    private static final String SET_IF_NOT_NULL_TEMPLATE = "${columnName} = IFNULL(VALUES(${columnName}), ${columnName})";
    private static final MySQLDialect INSTANCE = new MySQLDialect();

    private MySQLDialect() {
    }

    public static final MySQLDialect getInstance() {
        return INSTANCE;
    }

    @Override
    String getUpdateSetTemplate() {
        return UPDATE_SET_TEMPLATE;
    }

    @Override
    String getUpdateSetIfNotNullTemplate() {
        return UPDATE_SET_IF_NOT_NULL_TEMPLATE;
    }

    @Override
    List<String> getExtSQLTemplateParamNames() {
        return null;
    }

    @Override
    String getSaveSQLTemplate() {
        return SAVE;
    }

    @Override
    String getInsertIfNotExistsSQLTemplate() {
        return INSERT_IF_NOT_EXISTS;
    }

    @Override
    List<String> getNeedsCommaParamNames() {
        return NEEDS_COMMA_PARAM_NAMES;
    }

    @Override
    void handleColumnWhenSave(String columnName, Map<String, StringBuilder> templateParams) {
        templateParams.get("columns").append(columnName);
        templateParams.get("values").append('?');
    }

    @Override
    void handleIdColumnWhenSave(String columnName, Map<String, StringBuilder> templateParams, boolean notFirst) {
    }

    @Override
    String getSetTemplate() {
        return SET_TEMPLATE;
    }

    @Override
    String getSetIfNotNullTemplate() {
        return SET_IF_NOT_NULL_TEMPLATE;
    }

    @Override
    SQLPagingDialect getSQLPagingDialect() {
        return MySQLPagingDialect.getInstance();
    }
}

