/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.parser;

import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.sqltool.config.annotion.Column;
import cn.tenmg.sqltool.config.annotion.Id;
import cn.tenmg.sqltool.exception.PkNotFoundException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.meta.EntityMeta;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.sql.parser.AbstractDMLParser;
import cn.tenmg.sqltool.sql.utils.EntityUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DeleteDMLParser
extends AbstractDMLParser {
    private static final String DELETE = "DELETE FROM %s WHERE %s";
    private static final DeleteDMLParser INSTANCE = new DeleteDMLParser();

    private DeleteDMLParser() {
    }

    public static final DeleteDMLParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected <T> void parseDML(DML dml, Class<T> type, String tableName) {
        StringBuilder criteria = new StringBuilder();
        ArrayList<Field> idFields = new ArrayList<Field>();
        boolean criteriaFlag = false;
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        if (entityMeta == null) {
            Class<T> current = type;
            HashSet<String> fieldSet = new HashSet<String>();
            ArrayList<Field> fields = new ArrayList<Field>();
            ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
            while (!Object.class.equals(current)) {
                Field[] declaredFields = current.getDeclaredFields();
                for (int i = 0; i < declaredFields.length; ++i) {
                    Field field = declaredFields[i];
                    String fieldName = field.getName();
                    if (fieldSet.contains(fieldName)) continue;
                    fieldSet.add(fieldName);
                    Column column = field.getAnnotation(Column.class);
                    if (column == null) continue;
                    field.setAccessible(true);
                    fields.add(field);
                    String columnName = column.name();
                    if (StringUtils.isBlank((String)columnName)) {
                        columnName = StringUtils.camelToUnderline((String)fieldName, (boolean)true);
                    }
                    FieldMeta fieldMeta = new FieldMeta(field, columnName);
                    if (field.getAnnotation(Id.class) == null) {
                        fieldMeta.setId(false);
                    } else {
                        fieldMeta.setId(true);
                        idFields.add(field);
                        if (criteriaFlag) {
                            criteria.append(" AND ");
                        } else {
                            criteriaFlag = true;
                        }
                        criteria.append(columnName).append(" = ").append('?');
                    }
                    fieldMetas.add(fieldMeta);
                }
                current = current.getSuperclass();
            }
            EntityUtils.cacheEntityMeta(type, new EntityMeta(EntityUtils.getTableName(type), fieldMetas));
        } else {
            List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
            int size = fieldMetas.size();
            for (int i = 0; i < size; ++i) {
                FieldMeta fieldMeta = fieldMetas.get(i);
                String columnName = fieldMeta.getColumnName();
                if (!fieldMeta.isId()) continue;
                idFields.add(fieldMeta.getField());
                if (criteriaFlag) {
                    criteria.append(" AND ");
                } else {
                    criteriaFlag = true;
                }
                criteria.append(columnName).append(" = ").append('?');
            }
        }
        if (!criteriaFlag) {
            throw new PkNotFoundException("Primary key not found in class ".concat(type.getName()).concat(", please use @Id to config"));
        }
        dml.setSql(String.format(DELETE, tableName, criteria));
        dml.setFields(idFields);
    }
}

