/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.utils;

import cn.tenmg.dsql.factory.XMLFileDSQLFactory;
import cn.tenmg.sql.paging.utils.JDBCUtils;
import cn.tenmg.sqltool.exception.DataAccessException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.DMLParser;
import cn.tenmg.sqltool.sql.MergeSQL;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.SQLExecuter;
import cn.tenmg.sqltool.sql.UpdateSQL;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.sql.parser.UpdateDMLParser;
import cn.tenmg.sqltool.utils.JSONUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JDBCExecuteUtils {
    private static final Logger log = LoggerFactory.getLogger(XMLFileDSQLFactory.class);
    public static final String COMMA_SPACE = ", ";
    public static final String SPACE_AND_SPACE = " AND ";
    public static final String SPACE_EQ_SPACE = " = ";

    public static <T> T execute(Connection con, String id, String sql, List<Object> params, SQLExecuter<T> sqlExecuter, boolean showSql) throws SQLException {
        StringBuilder sb;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(sql);
            JDBCUtils.setParams((PreparedStatement)ps, params);
            if (showSql && log.isInfoEnabled()) {
                sb = new StringBuilder();
                sb.append("Execute SQL: ").append(sql).append(COMMA_SPACE).append("parameters: ").append(JSONUtils.toJSONString(params));
                if (id != null) {
                    sb.append(COMMA_SPACE).append("id: ").append(id);
                }
                log.info(sb.toString());
            }
            rs = sqlExecuter.execute(ps);
            sb = sqlExecuter.execute(ps, rs);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close((Statement)ps);
                throw throwable;
            }
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((Statement)ps);
        return (T)sb;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> int executeBatch(Connection con, boolean showSql, List<T> rows, DMLParser dmlParser) throws SQLException {
        int n;
        Statement ps;
        block11: {
            ps = null;
            try {
                DML dml = dmlParser.parse(((Serializable)rows.get(0)).getClass());
                String sql = dml.getSql();
                List<Field> fields = dml.getFields();
                ps = con.prepareStatement(sql);
                if (showSql && log.isInfoEnabled()) {
                    log.info("Execute SQL: ".concat(sql));
                }
                int size = rows.size();
                for (int i = 0; i < size; ++i) {
                    JDBCExecuteUtils.addBatch((PreparedStatement)ps, rows.get(i), fields);
                }
                n = JDBCExecuteUtils.getCount(ps.executeBatch());
                if (ps == null) break block11;
            }
            catch (SQLException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.clearBatch();
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                        }
                    }
                    JDBCUtils.close(ps);
                    throw throwable;
                }
            }
            try {
                ps.clearBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        JDBCUtils.close((Statement)ps);
        return n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> int update(Connection con, boolean showSql, List<T> rows, UpdateSQL updateSQL) throws SQLException {
        int n;
        Statement ps;
        block14: {
            ps = null;
            try {
                String sql = updateSQL.getScript();
                List<Field> fields = updateSQL.getFields();
                if (showSql && log.isInfoEnabled()) {
                    log.info("Execute SQL: ".concat(sql));
                }
                ps = con.prepareStatement(sql);
                int size = rows.size();
                for (int i = 0; i < size; ++i) {
                    JDBCExecuteUtils.addBatch((PreparedStatement)ps, rows.get(i), fields);
                }
                n = JDBCExecuteUtils.getCount(ps.executeBatch());
                if (ps == null) break block14;
            }
            catch (SQLException e) {
                try {
                    try {
                        con.rollback();
                        throw e;
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    throw e;
                    catch (Exception e2) {
                        throw new DataAccessException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.clearBatch();
                        }
                        catch (SQLException e3) {
                            e3.printStackTrace();
                        }
                    }
                    JDBCUtils.close(ps);
                    throw throwable;
                }
            }
            try {
                ps.clearBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        JDBCUtils.close((Statement)ps);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> int hardUpdate(Connection con, boolean showSql, List<T> rows) throws SQLException {
        int n;
        Statement ps;
        block11: {
            ps = null;
            try {
                DML dml = UpdateDMLParser.getInstance().parse(((Serializable)rows.get(0)).getClass());
                String sql = dml.getSql();
                List<Field> fields = dml.getFields();
                ps = con.prepareStatement(sql);
                if (showSql && log.isInfoEnabled()) {
                    log.info("Execute SQL: ".concat(sql));
                }
                int size = rows.size();
                for (int i = 0; i < size; ++i) {
                    JDBCExecuteUtils.addBatch((PreparedStatement)ps, rows.get(i), fields);
                }
                n = JDBCExecuteUtils.getCount(ps.executeBatch());
                if (ps == null) break block11;
            }
            catch (SQLException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.clearBatch();
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                        }
                    }
                    JDBCUtils.close(ps);
                    throw throwable;
                }
            }
            try {
                ps.clearBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        JDBCUtils.close((Statement)ps);
        return n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> int save(Connection con, boolean showSql, List<T> rows, MergeSQL mergeSql) throws SQLException {
        int n;
        Statement ps;
        block14: {
            ps = null;
            try {
                String sql = mergeSql.getScript();
                List<FieldMeta> fieldMetas = mergeSql.getFieldMetas();
                if (showSql && log.isInfoEnabled()) {
                    log.info("Execute SQL: ".concat(sql));
                }
                ps = con.prepareStatement(sql);
                int size = rows.size();
                for (int i = 0; i < size; ++i) {
                    JDBCExecuteUtils.addBatch((PreparedStatement)ps, fieldMetas, rows.get(i));
                }
                n = JDBCExecuteUtils.getCount(ps.executeBatch());
                if (ps == null) break block14;
            }
            catch (SQLException e) {
                try {
                    try {
                        con.rollback();
                        throw e;
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    throw e;
                    catch (Exception e2) {
                        throw new DataAccessException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.clearBatch();
                        }
                        catch (SQLException e3) {
                            e3.printStackTrace();
                        }
                    }
                    JDBCUtils.close(ps);
                    throw throwable;
                }
            }
            try {
                ps.clearBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        JDBCUtils.close((Statement)ps);
        return n;
    }

    public static <T> int hardSave(Connection con, SQLDialect dialect, boolean showSql, List<T> rows) throws SQLException {
        Statement ps = null;
        try {
            MergeSQL mergeSql = dialect.hardSave(rows.get(0).getClass());
            String sql = mergeSql.getScript();
            List<FieldMeta> fieldMetas = mergeSql.getFieldMetas();
            if (showSql && log.isInfoEnabled()) {
                log.info("Execute SQL: ".concat(sql));
            }
            ps = con.prepareStatement(sql);
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                JDBCExecuteUtils.addBatch((PreparedStatement)ps, fieldMetas, rows.get(i));
            }
            int n = JDBCExecuteUtils.getCount(ps.executeBatch());
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.clearBatch();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                JDBCUtils.close((Statement)ps);
            }
        }
    }

    public static final <T> void addBatch(PreparedStatement ps, List<FieldMeta> fieldMetas, T obj) throws SQLException {
        int size = fieldMetas.size();
        for (int i = 0; i < size; ++i) {
            try {
                ps.setObject(i + 1, fieldMetas.get(i).getField().get(obj));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new DataAccessException(e);
            }
        }
        ps.addBatch();
    }

    public static final <T> void addBatch(PreparedStatement ps, T obj, List<Field> fields) throws SQLException {
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            try {
                ps.setObject(i + 1, fields.get(i).get(obj));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new DataAccessException(e);
            }
        }
        ps.addBatch();
    }

    private static int getCount(int[] counts) {
        int count = 0;
        if (counts != null) {
            for (int i = 0; i < counts.length; ++i) {
                count += counts[i];
            }
        }
        return count;
    }
}

