/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.transaction;

import cn.tenmg.dsl.Script;
import cn.tenmg.dsl.utils.CollectionUtils;
import cn.tenmg.dsql.DSQLFactory;
import cn.tenmg.dsql.NamedSQL;
import cn.tenmg.sql.paging.utils.JDBCUtils;
import cn.tenmg.sqltool.exception.IllegalCallException;
import cn.tenmg.sqltool.exception.IllegalConfigException;
import cn.tenmg.sqltool.exception.SQLExecutorException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.SQLExecuter;
import cn.tenmg.sqltool.sql.executer.ExecuteSQLExecuter;
import cn.tenmg.sqltool.sql.executer.ExecuteUpdateSQLExecuter;
import cn.tenmg.sqltool.sql.executer.GetSQLExecuter;
import cn.tenmg.sqltool.sql.executer.SelectSQLExecuter;
import cn.tenmg.sqltool.sql.parser.DeleteDMLParser;
import cn.tenmg.sqltool.sql.parser.GetDMLParser;
import cn.tenmg.sqltool.sql.parser.InsertDMLParser;
import cn.tenmg.sqltool.sql.utils.EntityUtils;
import cn.tenmg.sqltool.transaction.CurrentConnectionHolder;
import cn.tenmg.sqltool.utils.JDBCExecuteUtils;
import cn.tenmg.sqltool.utils.SQLDialectUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class CustomTransactionExecutor
implements Serializable {
    private static final long serialVersionUID = -1728127905781636407L;
    private static ThreadLocal<SQLDialect> currentSQLDialect = new ThreadLocal();
    private DSQLFactory DSQLFactory;
    private boolean showSql = true;
    private int defaultBatchSize = 500;

    public DSQLFactory getDSQLFactory() {
        return this.DSQLFactory;
    }

    public void setDSQLFactory(DSQLFactory DSQLFactory2) {
        this.DSQLFactory = DSQLFactory2;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    public void setDefaultBatchSize(int defaultBatchSize) {
        this.defaultBatchSize = defaultBatchSize;
    }

    public void beginTransaction(Map<String, String> options) {
        currentSQLDialect.set(SQLDialectUtils.getSQLDialect(options));
        Connection con = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            CurrentConnectionHolder.set(con);
        }
        catch (SQLException e) {
            JDBCUtils.close(con);
            throw new SQLExecutorException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigException(e);
        }
    }

    public <T extends Serializable> int insert(T obj) throws SQLException {
        DML dml = InsertDMLParser.getInstance().parse(obj.getClass());
        List<Object> params = EntityUtils.getParams(obj, dml.getFields());
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), ExecuteUpdateSQLExecuter.getInstance(), null, dml.getSql(), params, this.showSql);
    }

    public <T extends Serializable> int insert(List<T> rows) throws SQLException {
        return JDBCExecuteUtils.executeBatch(CurrentConnectionHolder.get(), InsertDMLParser.getInstance(), rows, this.showSql);
    }

    public <T extends Serializable> int save(T obj) throws SQLException {
        Script<List<Object>> sql = currentSQLDialect.get().save(obj);
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), ExecuteUpdateSQLExecuter.getInstance(), null, sql.getValue(), (List)sql.getParams(), this.showSql);
    }

    public <T extends Serializable> int save(T obj, String ... hardFields) throws SQLException {
        Script<List<Object>> sql = currentSQLDialect.get().save(obj, hardFields);
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), ExecuteUpdateSQLExecuter.getInstance(), null, sql.getValue(), (List)sql.getParams(), this.showSql);
    }

    public <T extends Serializable> int save(List<T> rows) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JDBCExecuteUtils.save(CurrentConnectionHolder.get(), currentSQLDialect.get().save(((Serializable)rows.get(0)).getClass()), rows, this.showSql);
    }

    public <T extends Serializable> int save(List<T> rows, String ... hardFields) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JDBCExecuteUtils.save(CurrentConnectionHolder.get(), currentSQLDialect.get().save(((Serializable)rows.get(0)).getClass(), hardFields), rows, this.showSql);
    }

    public <T extends Serializable> int hardSave(T obj) throws SQLException {
        Script<List<Object>> sql = currentSQLDialect.get().hardSave(obj);
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), ExecuteUpdateSQLExecuter.getInstance(), null, sql.getValue(), (List)sql.getParams(), this.showSql);
    }

    public <T extends Serializable> int hardSave(List<T> rows) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JDBCExecuteUtils.hardSave(CurrentConnectionHolder.get(), currentSQLDialect.get(), rows, this.showSql);
    }

    public <T extends Serializable> int delete(T obj) throws SQLException {
        DML dml = DeleteDMLParser.getInstance().parse(obj.getClass());
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), ExecuteUpdateSQLExecuter.getInstance(), null, dml.getSql(), EntityUtils.getParams(obj, dml.getFields()), this.showSql);
    }

    public <T extends Serializable> int delete(List<T> rows) throws SQLException {
        return JDBCExecuteUtils.executeBatch(CurrentConnectionHolder.get(), DeleteDMLParser.getInstance(), rows, this.showSql);
    }

    public <T extends Serializable> T get(T obj) throws SQLException {
        Class<?> type = obj.getClass();
        DML dml = GetDMLParser.getInstance().parse(type);
        return (T)((Serializable)JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), new GetSQLExecuter(type), null, dml.getSql(), EntityUtils.getParams(obj, dml.getFields()), this.showSql));
    }

    public <T extends Serializable> T get(Class<T> type, String dsql, Object ... params) throws SQLException {
        return this.get(CurrentConnectionHolder.get(), this.DSQLFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> T get(Class<T> type, String dsql, Map<String, ?> params) throws SQLException {
        return this.get(CurrentConnectionHolder.get(), this.DSQLFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(T obj) throws SQLException {
        Class<?> type = obj.getClass();
        DML dml = GetDMLParser.getInstance().parse(type);
        return (List)JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), new SelectSQLExecuter(type), null, dml.getSql(), EntityUtils.getParams(obj, dml.getFields()), this.showSql);
    }

    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Object ... params) throws SQLException {
        return this.select(CurrentConnectionHolder.get(), this.DSQLFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Map<String, ?> params) throws SQLException {
        return this.select(CurrentConnectionHolder.get(), this.DSQLFactory.parse(dsql, params), type);
    }

    public boolean execute(String dsql, Object ... params) throws SQLException {
        return this.execute(this.DSQLFactory.parse(dsql, params));
    }

    public boolean execute(String dsql, Map<String, ?> params) throws SQLException {
        return this.execute(this.DSQLFactory.parse(dsql, params));
    }

    public int executeUpdate(String dsql, Object ... params) throws SQLException {
        return this.executeUpdate(this.DSQLFactory.parse(dsql, params));
    }

    public int executeUpdate(String dsql, Map<String, ?> params) throws SQLException {
        return this.executeUpdate(this.DSQLFactory.parse(dsql, params));
    }

    public void rollback() {
        Connection con = CustomTransactionExecutor.getCurrentConnection();
        try {
            con.rollback();
        }
        catch (SQLException e) {
            throw new SQLExecutorException(e);
        }
        finally {
            JDBCUtils.close((Connection)con);
            CurrentConnectionHolder.remove();
            currentSQLDialect.remove();
        }
    }

    public void commit() {
        Connection con = CustomTransactionExecutor.getCurrentConnection();
        try {
            con.commit();
        }
        catch (SQLException e) {
            throw new SQLExecutorException(e);
        }
        finally {
            JDBCUtils.close((Connection)con);
            CurrentConnectionHolder.remove();
        }
    }

    private <T extends Serializable> T get(Connection con, NamedSQL sql, Class<T> type) throws SQLException {
        return (T)((Serializable)this.execute(con, sql, new GetSQLExecuter<T>(type)));
    }

    private <T extends Serializable> List<T> select(Connection con, NamedSQL sql, Class<T> type) throws SQLException {
        return (List)this.execute(con, sql, new SelectSQLExecuter<T>(type));
    }

    private boolean execute(NamedSQL namedSQL) throws SQLException {
        Script sql = this.DSQLFactory.toJDBC(namedSQL);
        return JDBCExecuteUtils.execute(CustomTransactionExecutor.getCurrentConnection(), ExecuteSQLExecuter.getInstance(), namedSQL.getId(), sql.getValue(), (List)sql.getParams(), this.showSql);
    }

    private int executeUpdate(NamedSQL namedSQL) throws SQLException {
        Script sql = this.DSQLFactory.toJDBC(namedSQL);
        return JDBCExecuteUtils.execute(CustomTransactionExecutor.getCurrentConnection(), ExecuteUpdateSQLExecuter.getInstance(), namedSQL.getId(), sql.getValue(), (List)sql.getParams(), this.showSql);
    }

    private <T> T execute(Connection con, NamedSQL namedSQL, SQLExecuter<T> sqlExecuter) throws SQLException {
        Script sql = this.DSQLFactory.toJDBC(namedSQL);
        return JDBCExecuteUtils.execute(con, sqlExecuter, namedSQL.getId(), sql.getValue(), (List)sql.getParams(), this.showSql);
    }

    private static Connection getCurrentConnection() {
        Connection con = CurrentConnectionHolder.get();
        if (con == null) {
            throw new IllegalCallException("You must call beginTransaction first before you call this method");
        }
        return con;
    }
}

