/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.macro;

import cn.tenmg.dsl.DSLContext;
import cn.tenmg.dsl.NamedScript;
import cn.tenmg.dsl.annotion.Macro;
import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.sql.paging.utils.SQLUtils;
import cn.tenmg.sqltool.data.Page;
import cn.tenmg.sqltool.sql.SQLDialect;
import java.sql.Connection;
import java.util.Map;

@Macro(value="page")
public class Paging
implements cn.tenmg.dsl.Macro {
    private static final ThreadLocal<SQLDialect> currentDialect = new ThreadLocal();
    private static final ThreadLocal<Connection> currentConnection = new ThreadLocal();
    private static final ThreadLocal<Page<?>> currentPage = new ThreadLocal();
    private static final ThreadLocal<Boolean> counted = new ThreadLocal();
    private static final ThreadLocal<Boolean> paged = new ThreadLocal();

    public static boolean isCounted() {
        return Boolean.TRUE.equals(counted.get());
    }

    public static boolean isPaged() {
        return paged.get();
    }

    public static void initCountEnv(SQLDialect dialect) {
        currentDialect.set(dialect);
        counted.set(Boolean.FALSE);
    }

    public static void clear() {
        counted.remove();
        paged.remove();
        currentDialect.remove();
        currentConnection.remove();
        currentPage.remove();
    }

    public static void initPageEnv(SQLDialect dialect, Connection con, Page<?> page) {
        currentDialect.set(dialect);
        currentConnection.set(con);
        currentPage.set(page);
        paged.set(Boolean.FALSE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean execute(DSLContext context, Map<String, Object> attributes, String logic, StringBuilder dslf, Map<String, Object> params) throws Exception {
        SQLDialect dialect = currentDialect.get();
        Page<?> page = currentPage.get();
        if (page != null) {
            paged.set(Boolean.TRUE);
            NamedScript namedScript = DSLUtils.parse((String)logic.trim(), params);
            String namedSql = namedScript.getScript();
            String pageSql = dialect.pageSql(currentConnection.get(), namedSql, namedScript.getParams(), SQLUtils.getSQLMetaData((String)namedSql), page.getPageSize(), page.getCurrentPage());
            dslf.insert(0, StringUtils.concat((String[])new String[]{"(", pageSql, ")"}));
            return false;
        }
        if (dialect == null) {
            dslf.insert(0, StringUtils.concat((String[])new String[]{"(", logic, ")"}));
            return false;
        }
        counted.set(Boolean.TRUE);
        NamedScript namedScript = DSLUtils.parse((String)logic, params);
        String namedSql = namedScript.getScript();
        dslf.setLength(0);
        dslf.append(dialect.countSql(namedSql, SQLUtils.getSQLMetaData((String)namedSql)));
        return true;
    }
}

