/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.dialect;

import cn.tenmg.sql.paging.SQLPagingDialect;
import cn.tenmg.sql.paging.dialect.SQLitePagingDialect;
import cn.tenmg.sqltool.sql.dialect.AbstractSQLDialect;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class SQLiteDialect
extends AbstractSQLDialect {
    private static final String UPDATE_SET_IF_NOT_NULL_TEMPLATE = "${columnName} = IFNULL(?, ${columnName})";
    private static final String INSERT_IF_NOT_EXISTS_TEMPLATE = "INSERT OR IGNORE INTO ${tableName} (${columns}) VALUES (${values})";
    private static final String SAVE_TEMPLATE = "INSERT INTO ${tableName} AS X(${columns}) VALUES (${values}) ON CONFLICT(STAFF_ID) DO UPDATE SET ${sets}";
    private static final String SET_TEMPLATE = "${columnName} = EXCLUDED.${columnName}";
    private static final String IDS = "ids";
    private static final String SET_IF_NOT_NULL_TEMPLATE = "${columnName} = IFNULL(EXCLUDED.${columnName}, X.${columnName})";
    private static final List<String> EXT_SQL_TEMPLATE_PARAM_NAMES = Arrays.asList("ids");
    private static final List<String> NEEDS_COMMA_PARAM_NAMES = Arrays.asList("columns", "values");
    private static final SQLiteDialect INSTANCE = new SQLiteDialect();

    private SQLiteDialect() {
    }

    public static final SQLiteDialect getInstance() {
        return INSTANCE;
    }

    @Override
    SQLPagingDialect getSQLPagingDialect() {
        return SQLitePagingDialect.getInstance();
    }

    @Override
    String getUpdateSetIfNotNullTemplate() {
        return UPDATE_SET_IF_NOT_NULL_TEMPLATE;
    }

    @Override
    List<String> getExtSQLTemplateParamNames() {
        return EXT_SQL_TEMPLATE_PARAM_NAMES;
    }

    @Override
    String getSaveSQLTemplate() {
        return SAVE_TEMPLATE;
    }

    @Override
    String getInsertIfNotExistsSQLTemplate() {
        return INSERT_IF_NOT_EXISTS_TEMPLATE;
    }

    @Override
    List<String> getNeedsCommaParamNames() {
        return NEEDS_COMMA_PARAM_NAMES;
    }

    @Override
    void handleColumnWhenSave(String columnName, Map<String, StringBuilder> templateParams) {
        templateParams.get("columns").append(columnName);
        templateParams.get("values").append('?');
    }

    @Override
    void handleIdColumnWhenSave(String columnName, Map<String, StringBuilder> templateParams, boolean notFirst) {
        StringBuilder ids = templateParams.get(IDS);
        if (notFirst) {
            ids.append(", ");
        }
        ids.append(columnName);
    }

    @Override
    String getSetTemplate() {
        return SET_TEMPLATE;
    }

    @Override
    String getSetIfNotNullTemplate() {
        return SET_IF_NOT_NULL_TEMPLATE;
    }
}

