/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.dao;

import cn.tenmg.dsl.utils.MapUtils;
import cn.tenmg.dsql.DSQLFactory;
import cn.tenmg.dsql.factory.XMLFileDSQLFactory;
import cn.tenmg.sqltool.dao.AbstractDao;
import cn.tenmg.sqltool.datasource.DataSourceFactory;
import cn.tenmg.sqltool.exception.IllegalConfigException;
import cn.tenmg.sqltool.exception.InitializeDataSourceException;
import cn.tenmg.sqltool.utils.SQLDialectUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class BasicDao
extends AbstractDao {
    private static final String DATASOURCE_PREFIX = "sqltool.datasource.";
    private static final String DEFAULT_NAME = "default";
    private static final String DATASOURCE_REGEX = "^".concat("sqltool.datasource.".replaceAll("\\.", "\\\\.")).concat("([\\S]+\\.){0,1}[^\\.]+$");
    private static final int DATASOURCE_PREFIX_LEN = "sqltool.datasource.".length();
    private DataSource defaultDataSource;
    private Map<String, DataSource> dataSources = new HashMap<String, DataSource>();
    private DSQLFactory DSQLFactory;
    private boolean showSql;
    private int defaultBatchSize = 500;

    public void setDefaultDataSource(DataSource defaultDataSource) {
        this.defaultDataSource = defaultDataSource;
    }

    @Override
    public DataSource getDefaultDataSource() {
        return this.defaultDataSource;
    }

    @Override
    public DataSource getDataSource(String name) {
        return this.dataSources.get(name);
    }

    public Map<String, DataSource> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(Map<String, DataSource> dataSources) {
        this.dataSources = dataSources;
    }

    public void setDSQLFactory(DSQLFactory dSQLFactory) {
        this.DSQLFactory = dSQLFactory;
    }

    @Override
    public DSQLFactory getDSQLFactory() {
        return this.DSQLFactory;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    @Override
    public boolean isShowSql() {
        return this.showSql;
    }

    public void setDefaultBatchSize(int defaultBatchSize) {
        this.defaultBatchSize = defaultBatchSize;
    }

    @Override
    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    public BasicDao() {
    }

    public static BasicDao build(Properties properties) {
        return new BasicDao(properties);
    }

    private BasicDao(Properties properties) {
        Properties dataSourceConfig;
        String basePackages = properties.getProperty("sqltool.basePackages");
        String suffix = properties.getProperty("sqltool.suffix");
        this.DSQLFactory = suffix == null ? new XMLFileDSQLFactory(basePackages) : new XMLFileDSQLFactory(basePackages, suffix);
        this.showSql = Boolean.valueOf(properties.getProperty("sqltool.showSql", "false"));
        this.defaultBatchSize = Integer.valueOf(properties.getProperty("sqltool.defaultBatchSize", "500"));
        HashMap<String, Properties> dataSourceConfigs = new HashMap<String, Properties>();
        String firstName = null;
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name;
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (!key.matches(DATASOURCE_REGEX)) continue;
            String param = key.substring(DATASOURCE_PREFIX_LEN);
            int index = param.indexOf(".");
            if (index > 0) {
                name = param.substring(0, index);
                param = param.substring(index + 1);
            } else {
                name = DEFAULT_NAME;
            }
            if (firstName == null) {
                firstName = name;
            }
            if ((dataSourceConfig = (Properties)dataSourceConfigs.get(name)) == null) {
                dataSourceConfig = new Properties();
                dataSourceConfigs.put(name, dataSourceConfig);
            }
            dataSourceConfig.put(param, value);
        }
        if (MapUtils.isEmpty(dataSourceConfigs)) {
            throw new IllegalConfigException("No datasource is configured, please check the configuration");
        }
        String defaultName = DEFAULT_NAME;
        dataSourceConfig = (Properties)dataSourceConfigs.get(DEFAULT_NAME);
        if (dataSourceConfig == null) {
            defaultName = firstName;
            dataSourceConfig = (Properties)dataSourceConfigs.get(firstName);
        }
        try {
            this.defaultDataSource = DataSourceFactory.createDataSource(dataSourceConfig);
            this.dataSources.put(defaultName, this.defaultDataSource);
            BasicDao.cacheSQLDialect(this.defaultDataSource, SQLDialectUtils.getSQLDialect(dataSourceConfig));
            dataSourceConfigs.remove(defaultName);
            for (Map.Entry entry : dataSourceConfigs.entrySet()) {
                dataSourceConfig = (Properties)entry.getValue();
                DataSource dataSource = DataSourceFactory.createDataSource(dataSourceConfig);
                this.dataSources.put((String)entry.getKey(), dataSource);
                BasicDao.cacheSQLDialect(dataSource, SQLDialectUtils.getSQLDialect(dataSourceConfig));
            }
        }
        catch (Exception e) {
            throw new InitializeDataSourceException("An exception occurred while initializing datasource(s)", e);
        }
        this.closeDataSourcesWhenShutdown(this.dataSources.values());
    }
}

