/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.utils;

import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.sql.paging.utils.JDBCUtils;
import cn.tenmg.sqltool.exception.DataAccessException;
import cn.tenmg.sqltool.exception.SQLExecutorException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.DMLParser;
import cn.tenmg.sqltool.sql.MergeSQL;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.SQLExecuter;
import cn.tenmg.sqltool.sql.UpdateSQL;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.sql.parser.UpdateDMLParser;
import cn.tenmg.sqltool.utils.JSONUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JDBCExecuteUtils {
    private static final Logger log = LoggerFactory.getLogger(JDBCExecuteUtils.class);
    public static final String COMMA_SPACE = ", ";
    public static final String SPACE_AND_SPACE = " AND ";
    public static final String SPACE_EQ_SPACE = " = ";
    private static final String LINE_SPLITOR = System.lineSeparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(Connection con, SQLExecuter<T> sqlExecuter, String id, String sql, List<Object> params, boolean showSql) throws SQLException {
        T t;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(sql);
            JDBCUtils.setParams((PreparedStatement)ps, params);
            if (showSql && log.isInfoEnabled()) {
                log.info(JDBCExecuteUtils.logPrefix(id, sql).append(sql).append(COMMA_SPACE).append("parameters: ").append(JSONUtils.toJSONString(params)).toString());
            }
            rs = sqlExecuter.execute(ps);
            t = sqlExecuter.execute(ps, rs);
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((Statement)ps);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((Statement)ps);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> int executeBatch(Connection con, DMLParser dmlParser, List<T> rows, boolean showSql) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            DML dml = dmlParser.parse(rows.get(0).getClass());
            String sql = dml.getSql();
            List<Field> fields = dml.getFields();
            ps = con.prepareStatement(sql);
            if (showSql && log.isInfoEnabled()) {
                JDBCExecuteUtils.log(sql);
            }
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                JDBCExecuteUtils.addBatch(ps, rows.get(i), fields);
            }
            n = JDBCExecuteUtils.getCount(ps.executeBatch());
        }
        catch (Throwable throwable) {
            JDBCUtils.clear(ps);
            throw throwable;
        }
        JDBCUtils.clear((Statement)ps);
        return n;
    }

    public static <T> void saveBatch(DataSource dataSource, MergeSQL mergeSql, List<T> rows, int batchSize, boolean showSql) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            int size = rows.size();
            int current = 0;
            int times = (int)Math.ceil((double)size / (double)batchSize);
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            con.setReadOnly(false);
            String sql = mergeSql.getScript();
            List<FieldMeta> fieldMetas = mergeSql.getFieldMetas();
            if (showSql && log.isInfoEnabled()) {
                JDBCExecuteUtils.log(sql);
            }
            ps = con.prepareStatement(sql);
            while (current < times) {
                int end = (current + 1) * batchSize;
                int last = end < size ? end : size;
                for (int i = current * batchSize; i < last; ++i) {
                    JDBCExecuteUtils.addBatch(ps, fieldMetas, rows.get(i));
                }
                ps.executeBatch();
                con.commit();
                ps.clearBatch();
                ++current;
            }
        }
        catch (SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                throw new SQLExecutorException(e);
            }
            catch (Throwable throwable) {
                JDBCUtils.clear(ps);
                JDBCUtils.close((Connection)con);
                throw throwable;
            }
        }
        JDBCUtils.clear((Statement)ps);
        JDBCUtils.close((Connection)con);
    }

    public static <T> void executeBatch(DataSource dataSource, String sql, List<T> rows, List<Field> fields, int batchSize, boolean showSql) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            con.setReadOnly(false);
            ps = con.prepareStatement(sql);
            if (showSql && log.isInfoEnabled()) {
                JDBCExecuteUtils.log(sql);
            }
            int size = rows.size();
            int times = (int)Math.ceil((double)size / (double)batchSize);
            for (int current = 0; current < times; ++current) {
                int end = (current + 1) * batchSize;
                int last = end < size ? end : size;
                for (int i = current * batchSize; i < last; ++i) {
                    JDBCExecuteUtils.addBatch(ps, rows.get(i), fields);
                }
                ps.executeBatch();
                con.commit();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                throw new SQLExecutorException(e);
            }
            catch (Throwable throwable) {
                JDBCUtils.clear(ps);
                JDBCUtils.close((Connection)con);
                throw throwable;
            }
        }
        JDBCUtils.clear((Statement)ps);
        JDBCUtils.close((Connection)con);
    }

    public static <T> void updateBatch(DataSource dataSource, UpdateSQL updateSql, List<T> rows, int batchSize, boolean showSql) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            int size = rows.size();
            int current = 0;
            int times = (int)Math.ceil((double)size / (double)batchSize);
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            con.setReadOnly(false);
            String sql = updateSql.getScript();
            List<Field> fields = updateSql.getFields();
            if (showSql && log.isInfoEnabled()) {
                JDBCExecuteUtils.log(sql);
            }
            ps = con.prepareStatement(sql);
            while (current < times) {
                int end = (current + 1) * batchSize;
                int last = end < size ? end : size;
                for (int i = current * batchSize; i < last; ++i) {
                    JDBCExecuteUtils.addBatch(ps, rows.get(i), fields);
                }
                ps.executeBatch();
                con.commit();
                ps.clearBatch();
                ++current;
            }
        }
        catch (SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                throw new SQLExecutorException(e);
            }
            catch (Throwable throwable) {
                JDBCUtils.clear(ps);
                JDBCUtils.close((Connection)con);
                throw throwable;
            }
        }
        JDBCUtils.clear((Statement)ps);
        JDBCUtils.close((Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> int update(Connection con, UpdateSQL updateSQL, List<T> rows, boolean showSql) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            String sql = updateSQL.getScript();
            List<Field> fields = updateSQL.getFields();
            if (showSql && log.isInfoEnabled()) {
                JDBCExecuteUtils.log(sql);
            }
            ps = con.prepareStatement(sql);
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                JDBCExecuteUtils.addBatch(ps, rows.get(i), fields);
            }
            n = JDBCExecuteUtils.getCount(ps.executeBatch());
        }
        catch (Throwable throwable) {
            JDBCUtils.clear(ps);
            throw throwable;
        }
        JDBCUtils.clear((Statement)ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> int hardUpdate(Connection con, List<T> rows, boolean showSql) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            DML dml = UpdateDMLParser.getInstance().parse(rows.get(0).getClass());
            String sql = dml.getSql();
            List<Field> fields = dml.getFields();
            ps = con.prepareStatement(sql);
            if (showSql && log.isInfoEnabled()) {
                JDBCExecuteUtils.log(sql);
            }
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                JDBCExecuteUtils.addBatch(ps, rows.get(i), fields);
            }
            n = JDBCExecuteUtils.getCount(ps.executeBatch());
        }
        catch (Throwable throwable) {
            JDBCUtils.clear(ps);
            throw throwable;
        }
        JDBCUtils.clear((Statement)ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> int save(Connection con, MergeSQL mergeSql, List<T> rows, boolean showSql) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            String sql = mergeSql.getScript();
            List<FieldMeta> fieldMetas = mergeSql.getFieldMetas();
            if (showSql && log.isInfoEnabled()) {
                JDBCExecuteUtils.log(sql);
            }
            ps = con.prepareStatement(sql);
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                JDBCExecuteUtils.addBatch(ps, fieldMetas, rows.get(i));
            }
            n = JDBCExecuteUtils.getCount(ps.executeBatch());
        }
        catch (Throwable throwable) {
            JDBCUtils.clear(ps);
            throw throwable;
        }
        JDBCUtils.clear((Statement)ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> int hardSave(Connection con, SQLDialect dialect, List<T> rows, boolean showSql) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            MergeSQL mergeSql = dialect.hardSave(rows.get(0).getClass());
            String sql = mergeSql.getScript();
            List<FieldMeta> fieldMetas = mergeSql.getFieldMetas();
            if (showSql && log.isInfoEnabled()) {
                JDBCExecuteUtils.log(sql);
            }
            ps = con.prepareStatement(sql);
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                JDBCExecuteUtils.addBatch(ps, fieldMetas, rows.get(i));
            }
            n = JDBCExecuteUtils.getCount(ps.executeBatch());
        }
        catch (Throwable throwable) {
            JDBCUtils.clear(ps);
            throw throwable;
        }
        JDBCUtils.clear((Statement)ps);
        return n;
    }

    private static final <T> void addBatch(PreparedStatement ps, List<FieldMeta> fieldMetas, T obj) throws SQLException {
        int size = fieldMetas.size();
        for (int i = 0; i < size; ++i) {
            try {
                ps.setObject(i + 1, fieldMetas.get(i).getField().get(obj));
                continue;
            }
            catch (Exception e) {
                throw new DataAccessException(e);
            }
        }
        ps.addBatch();
    }

    private static final <T> void addBatch(PreparedStatement ps, T obj, List<Field> fields) throws SQLException {
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            try {
                ps.setObject(i + 1, fields.get(i).get(obj));
                continue;
            }
            catch (Exception e) {
                throw new DataAccessException(e);
            }
        }
        ps.addBatch();
    }

    private static int getCount(int[] counts) {
        int count = 0;
        if (counts != null) {
            for (int i = 0; i < counts.length; ++i) {
                count += counts[i];
            }
        }
        return count;
    }

    private static void log(String sql) {
        char c;
        if (StringUtils.isNotBlank((String)sql) && ((c = sql.charAt(0)) == '\r' || c == '\n')) {
            log.info("Execute SQL:".concat(sql));
            return;
        }
        log.info("Execute SQL:\n".concat(sql));
    }

    private static StringBuilder logPrefix(String id, String sql) {
        char c;
        StringBuilder logPrefix = new StringBuilder();
        if (StringUtils.isNotBlank((String)sql) && ((c = sql.charAt(0)) == '\r' || c == '\n')) {
            if (id == null) {
                return logPrefix.append("Execute SQL:");
            }
            return logPrefix.append("Execute SQL(").append(id).append("):");
        }
        if (id == null) {
            return logPrefix.append("Execute SQL:").append(LINE_SPLITOR);
        }
        return logPrefix.append("Execute SQL(").append(id).append("):").append(LINE_SPLITOR);
    }
}

