/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.transaction;

import cn.tenmg.dsl.Script;
import cn.tenmg.dsl.utils.CollectionUtils;
import cn.tenmg.dsql.DSQLFactory;
import cn.tenmg.dsql.NamedSQL;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.executer.ExecuteSQLExecuter;
import cn.tenmg.sqltool.sql.executer.ExecuteUpdateSQLExecuter;
import cn.tenmg.sqltool.sql.executer.GetSQLExecuter;
import cn.tenmg.sqltool.sql.executer.SelectSQLExecuter;
import cn.tenmg.sqltool.sql.parser.DeleteDMLParser;
import cn.tenmg.sqltool.sql.parser.GetDMLParser;
import cn.tenmg.sqltool.sql.parser.InsertDMLParser;
import cn.tenmg.sqltool.sql.parser.UpdateDMLParser;
import cn.tenmg.sqltool.sql.utils.EntityUtils;
import cn.tenmg.sqltool.transaction.CurrentConnectionHolder;
import cn.tenmg.sqltool.utils.JDBCExecuteUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class TransactionExecutor
implements Serializable {
    private static final long serialVersionUID = -4415310449248911047L;
    private boolean showSql = true;
    private DSQLFactory DSQLFactory;
    private SQLDialect dialect;

    public TransactionExecutor(boolean showSql, DSQLFactory DSQLFactory2, SQLDialect dialect) {
        this.showSql = showSql;
        this.DSQLFactory = DSQLFactory2;
        this.dialect = dialect;
    }

    public int insert(Object obj) throws SQLException {
        DML dml = InsertDMLParser.getInstance().parse(obj.getClass());
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), ExecuteUpdateSQLExecuter.getInstance(), null, dml.getSql(), EntityUtils.getParams(obj, dml.getFields()), this.showSql);
    }

    public <T extends Serializable> int insert(List<T> rows) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JDBCExecuteUtils.executeBatch(CurrentConnectionHolder.get(), InsertDMLParser.getInstance(), rows, this.showSql);
    }

    public <T extends Serializable> int update(T obj) throws SQLException {
        Script<List<Object>> sql = this.dialect.update(obj);
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), ExecuteUpdateSQLExecuter.getInstance(), null, sql.getValue(), (List)sql.getParams(), this.showSql);
    }

    public <T extends Serializable> int update(T obj, String ... hardFields) throws SQLException {
        Script<List<Object>> sql = this.dialect.update(obj, hardFields);
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), ExecuteUpdateSQLExecuter.getInstance(), null, sql.getValue(), (List)sql.getParams(), this.showSql);
    }

    public <T extends Serializable> int update(List<T> rows) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JDBCExecuteUtils.update(CurrentConnectionHolder.get(), this.dialect.update(((Serializable)rows.get(0)).getClass()), rows, this.showSql);
    }

    public <T extends Serializable> int update(List<T> rows, String ... hardFields) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JDBCExecuteUtils.update(CurrentConnectionHolder.get(), this.dialect.update(((Serializable)rows.get(0)).getClass(), hardFields), rows, this.showSql);
    }

    public <T extends Serializable> int hardUpdate(T obj) throws SQLException {
        DML dml = UpdateDMLParser.getInstance().parse(obj.getClass());
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), ExecuteUpdateSQLExecuter.getInstance(), null, dml.getSql(), EntityUtils.getParams(obj, dml.getFields()), this.showSql);
    }

    public <T extends Serializable> int hardUpdate(List<T> rows) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JDBCExecuteUtils.hardUpdate(CurrentConnectionHolder.get(), rows, this.showSql);
    }

    public <T extends Serializable> int save(T obj) throws SQLException {
        Script<List<Object>> sql = this.dialect.save(obj);
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), ExecuteUpdateSQLExecuter.getInstance(), null, sql.getValue(), (List)sql.getParams(), this.showSql);
    }

    public <T extends Serializable> int save(T obj, String ... hardFields) throws SQLException {
        Script<List<Object>> sql = this.dialect.save(obj, hardFields);
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), ExecuteUpdateSQLExecuter.getInstance(), null, sql.getValue(), (List)sql.getParams(), this.showSql);
    }

    public <T extends Serializable> int save(List<T> rows) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JDBCExecuteUtils.save(CurrentConnectionHolder.get(), this.dialect.save(((Serializable)rows.get(0)).getClass()), rows, this.showSql);
    }

    public <T extends Serializable> int save(List<T> rows, String ... hardFields) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JDBCExecuteUtils.save(CurrentConnectionHolder.get(), this.dialect.save(((Serializable)rows.get(0)).getClass(), hardFields), rows, this.showSql);
    }

    public <T extends Serializable> int hardSave(T obj) throws SQLException {
        Script<List<Object>> sql = this.dialect.hardSave(obj);
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), ExecuteUpdateSQLExecuter.getInstance(), null, sql.getValue(), (List)sql.getParams(), this.showSql);
    }

    public <T extends Serializable> int hardSave(List<T> rows) throws SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JDBCExecuteUtils.hardSave(CurrentConnectionHolder.get(), this.dialect, rows, this.showSql);
    }

    public <T extends Serializable> int delete(T obj) throws SQLException {
        DML dml = DeleteDMLParser.getInstance().parse(obj.getClass());
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), ExecuteUpdateSQLExecuter.getInstance(), null, dml.getSql(), EntityUtils.getParams(obj, dml.getFields()), this.showSql);
    }

    public <T extends Serializable> int delete(List<T> rows) throws SQLException {
        return JDBCExecuteUtils.executeBatch(CurrentConnectionHolder.get(), DeleteDMLParser.getInstance(), rows, this.showSql);
    }

    public <T extends Serializable> T get(T obj) throws SQLException {
        Class<?> type = obj.getClass();
        DML dml = GetDMLParser.getInstance().parse(type);
        return (T)((Serializable)JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), new GetSQLExecuter(type), null, dml.getSql(), EntityUtils.getParams(obj, dml.getFields()), this.showSql));
    }

    public <T extends Serializable> T get(Class<T> type, String dsql, Object ... params) throws SQLException {
        return this.get(this.DSQLFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> T get(Class<T> type, String dsql, Map<String, ?> params) throws SQLException {
        return this.get(this.DSQLFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Object ... params) throws SQLException {
        return this.select(this.DSQLFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Map<String, ?> params) throws SQLException {
        return this.select(this.DSQLFactory.parse(dsql, params), type);
    }

    public boolean execute(String dsql, Object ... params) throws SQLException {
        return this.execute(this.DSQLFactory.parse(dsql, params));
    }

    public boolean execute(String dsql, Map<String, ?> params) throws SQLException {
        return this.execute(this.DSQLFactory.parse(dsql, params));
    }

    public int executeUpdate(String dsql, Object ... params) throws SQLException {
        return this.executeUpdate(this.DSQLFactory.parse(dsql, params));
    }

    public int executeUpdate(String dsql, Map<String, ?> params) throws SQLException {
        return this.executeUpdate(this.DSQLFactory.parse(dsql, params));
    }

    private boolean execute(NamedSQL namedSQL) throws SQLException {
        Script sql = this.DSQLFactory.toJDBC(namedSQL);
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), ExecuteSQLExecuter.getInstance(), namedSQL.getId(), sql.getValue(), (List)sql.getParams(), this.showSql);
    }

    private int executeUpdate(NamedSQL namedSQL) throws SQLException {
        Script sql = this.DSQLFactory.toJDBC(namedSQL);
        return JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), ExecuteUpdateSQLExecuter.getInstance(), namedSQL.getId(), sql.getValue(), (List)sql.getParams(), this.showSql);
    }

    private <T extends Serializable> T get(NamedSQL namedSQL, Class<T> type) throws SQLException {
        Script sql = this.DSQLFactory.toJDBC(namedSQL);
        return (T)((Serializable)JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), new GetSQLExecuter<T>(type), namedSQL.getId(), sql.getValue(), (List)sql.getParams(), this.showSql));
    }

    private <T extends Serializable> List<T> select(NamedSQL namedSQL, Class<T> type) throws SQLException {
        Script sql = this.DSQLFactory.toJDBC(namedSQL);
        return (List)JDBCExecuteUtils.execute(CurrentConnectionHolder.get(), new SelectSQLExecuter<T>(type), namedSQL.getId(), sql.getValue(), (List)sql.getParams(), this.showSql);
    }
}

