/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.plugin.agp8;

import com.android.build.api.instrumentation.AsmClassVisitorFactory;
import com.android.build.api.instrumentation.ClassContext;
import com.android.build.api.instrumentation.ClassData;
import com.therouter.plugin.AddCodeVisitor;
import com.therouter.plugin.agp8.TextParameters;
import com.therouter.plugin.agp8.TheRouterFieldVisitor;
import com.therouter.plugin.utils.TheRouterPluginUtils;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import org.objectweb.asm.ClassVisitor;

public abstract class TheRouterASM
implements AsmClassVisitorFactory<TextParameters> {
    public static final String INJECTER_FULL_CLASSNAME = "a.TheRouterServiceProvideInjecter";

    public ClassVisitor createClassVisitor(ClassContext classContext, ClassVisitor classVisitor) {
        String currentClassName = classContext.getCurrentClassData().getClassName();
        if (INJECTER_FULL_CLASSNAME.equals(currentClassName)) {
            String buildDataText = (String)((TextParameters)this.getParameters().get()).getBuildDataText().get();
            String[] classNameArray = buildDataText.split("\n");
            HashMap<String, String> serviceProvideMap = new HashMap<String, String>();
            HashSet<String> autowiredSet = new HashSet<String>();
            HashSet<String> routeSet = new HashSet<String>();
            for (String name : classNameArray) {
                if (name.contains("RouterMap__TheRouter__")) {
                    routeSet.add(name.trim());
                    continue;
                }
                if (name.contains("ServiceProvider__TheRouter__")) {
                    serviceProvideMap.put(name.trim().substring(2), "1.2.3-rc8");
                    continue;
                }
                if (!name.contains("__TheRouter__Autowired")) continue;
                autowiredSet.add(name.trim());
            }
            return new AddCodeVisitor(classVisitor, serviceProvideMap, autowiredSet, routeSet, false);
        }
        if (currentClassName.contains("RouterMap__TheRouter__") || currentClassName.contains("ServiceProvider__TheRouter__") || currentClassName.contains("__TheRouter__Autowired")) {
            return new TheRouterFieldVisitor(classVisitor, currentClassName);
        }
        return null;
    }

    public boolean isInstrumentable(ClassData classData) {
        if (classData.getClassName().contains("$")) {
            return false;
        }
        String className = classData.getClassName().replaceAll("\\.", "/");
        if (className.contains("RouterMap__TheRouter__") || className.contains("ServiceProvider__TheRouter__") || className.contains("__TheRouter__Autowired")) {
            File buildCacheFile = (File)((TextParameters)this.getParameters().get()).getBuildCacheFile().get();
            boolean isDebug = (Boolean)((TextParameters)this.getParameters().get()).getDebugValue().get();
            TheRouterPluginUtils.addTextToFile(buildCacheFile, className, isDebug);
            return className.contains("RouterMap__TheRouter__") || className.contains("ServiceProvider__TheRouter__");
        }
        return INJECTER_FULL_CLASSNAME.equals(classData.getClassName());
    }
}

