/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.plugin.agp8;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.therouter.plugin.AddCodeVisitor;
import com.therouter.plugin.LogUI;
import com.therouter.plugin.RouteItem;
import com.therouter.plugin.TheRouterExtension;
import com.therouter.plugin.TheRouterInjects;
import com.therouter.plugin.utils.TheRouterPluginUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public abstract class TheRouterTask
extends DefaultTask {
    private TheRouterExtension theRouterExtension;
    private File asmTargetFile;
    private File allClassFile;
    private File flowTaskFile;
    private File routeFile;
    private boolean isFirst;

    @InputFiles
    public abstract ListProperty<RegularFile> getAllJars();

    @InputFiles
    public abstract ListProperty<Directory> getAllDirectories();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    public void setTheRouterExtension(TheRouterExtension theRouterExtension) {
        this.theRouterExtension = theRouterExtension;
    }

    public void setAsmTargetFile(File file) {
        this.asmTargetFile = file;
    }

    public void setAllClassFile(File file) {
        this.allClassFile = file;
    }

    public void setFlowTaskFile(File flowTaskFile) {
        this.flowTaskFile = flowTaskFile;
    }

    public void setRouteFile(File routeFile) {
        this.routeFile = routeFile;
    }

    public void setFirst(boolean first) {
        this.isFirst = first;
    }

    @TaskAction
    public void taskAction() throws ClassNotFoundException, IOException {
        System.out.println("TheRouter\u7f16\u8bd1\u63d2\u4ef6\uff1a" + LogUI.C_BLACK_GREEN.getValue() + "cn.therouter:plugin:1.2.4-rc2" + LogUI.E_NORMAL.getValue());
        System.out.println("JDK Version::" + System.getProperty("java.version"));
        System.out.println("Gradle Version::" + this.getProject().getGradle().getGradleVersion());
        System.out.println("\u672c\u6b21\u662f\u589e\u91cf\u7f16\u8bd1::" + !this.isFirst);
        System.out.println("checkRouteMap::" + this.theRouterExtension.checkRouteMap);
        System.out.println("checkFlowDepend::" + this.theRouterExtension.checkFlowDepend);
        if (this.isFirst) {
            System.out.println("\u9996\u6b21\u7f16\u8bd1\u901f\u5ea6\u4f1a\u6162\u662f\u6b63\u5e38\u7684\uff0c\u5b9e\u73b0\u539f\u7406\u8bf7\u67e5\u770b\uff1a\nhttps://kymjs.com/code/2024/10/31/01/\n");
        }
        System.out.println("----------------------TheRouter build start------------------------------");
        this.theRouterTransform();
        System.out.println("----------------------TheRouter build finish-----------------------------");
    }

    private void theRouterTransform() throws ClassNotFoundException, IOException {
        Object buffer;
        JarFile jarFile;
        String tempText = "";
        if (TheRouterPluginUtils.needCheckRouteItemClass(this.theRouterExtension.checkRouteMap)) {
            tempText = TheRouterPluginUtils.getTextFromFile(this.allClassFile);
        }
        String allClassText = tempText;
        String asmTargetText = TheRouterPluginUtils.getTextFromFile(this.asmTargetFile);
        String routeText = TheRouterPluginUtils.getTextFromFile(this.routeFile);
        String flowTaskText = TheRouterPluginUtils.getTextFromFile(this.flowTaskFile);
        File theRouterJar = null;
        ZipEntry theRouterServiceProvideInjecter = null;
        JarOutputStream jarOutput = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(((RegularFile)this.getOutputFile().get()).getAsFile())));
        HashSet<String> addedEntries = new HashSet<String>();
        for (RegularFile file : (List)this.getAllJars().get()) {
            File jar = file.getAsFile();
            jarFile = new JarFile(jar);
            Iterator e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                String name = jarEntry.getName();
                if (name.contains("META-INF/") || !addedEntries.add(name)) continue;
                if (!allClassText.contains(name) && TheRouterPluginUtils.needCheckRouteItemClass(this.theRouterExtension.checkRouteMap)) {
                    TheRouterPluginUtils.addTextToFile(this.allClassFile, name, this.theRouterExtension.debug);
                }
                if (this.isFirst && name.contains("TheRouterServiceProvideInjecter")) {
                    theRouterJar = jar;
                    theRouterServiceProvideInjecter = jarEntry;
                    continue;
                }
                if (!name.contains("$")) {
                    if (name.contains("RouterMap__TheRouter__")) {
                        if (!asmTargetText.contains(name)) {
                            TheRouterPluginUtils.addTextToFile(this.asmTargetFile, name, this.theRouterExtension.debug);
                        }
                        reader = new ClassReader(jarFile.getInputStream(jarEntry));
                        cn = new ClassNode();
                        reader.accept((ClassVisitor)cn, 0);
                        List fieldList = cn.fields;
                        for (FieldNode fieldNode : fieldList) {
                            if (!"ROUTERMAP".equals(fieldNode.name) || routeText.contains(v = fieldNode.value.toString())) continue;
                            TheRouterPluginUtils.addTextToFileIgnoreCheck(this.routeFile, v, this.theRouterExtension.debug);
                        }
                    } else if (name.contains("ServiceProvider__TheRouter__")) {
                        if (!asmTargetText.contains(name)) {
                            TheRouterPluginUtils.addTextToFile(this.asmTargetFile, name, this.theRouterExtension.debug);
                        }
                        if (!this.theRouterExtension.checkFlowDepend.isEmpty()) {
                            reader = new ClassReader(jarFile.getInputStream(jarEntry));
                            cn = new ClassNode();
                            reader.accept((ClassVisitor)cn, 0);
                            List fieldList = cn.fields;
                            for (FieldNode fieldNode : fieldList) {
                                if (!"FLOW_TASK_JSON".equals(fieldNode.name) || flowTaskText.contains(v = fieldNode.value.toString())) continue;
                                TheRouterPluginUtils.addTextToFileIgnoreCheck(this.flowTaskFile, v, this.theRouterExtension.debug);
                            }
                        }
                    } else if (name.contains("__TheRouter__Autowired") && !asmTargetText.contains(name)) {
                        TheRouterPluginUtils.addTextToFile(this.asmTargetFile, name, this.theRouterExtension.debug);
                    }
                }
                try {
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    try {
                        int bytesRead;
                        jarOutput.putNextEntry(new JarEntry(name));
                        buffer = new byte[1024];
                        while ((bytesRead = inputStream.read((byte[])buffer)) != -1) {
                            jarOutput.write((byte[])buffer, 0, bytesRead);
                        }
                        jarOutput.closeEntry();
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            jarFile.close();
        }
        for (Directory directory : (List)this.getAllDirectories().get()) {
            for (Object file : directory.getAsFileTree()) {
                String name = directory.getAsFile().toURI().relativize(((File)file).toURI()).getPath().replace(File.separatorChar, '/');
                if (name.contains("META-INF/") || !addedEntries.add(name)) continue;
                if (!allClassText.contains(name) && TheRouterPluginUtils.needCheckRouteItemClass(this.theRouterExtension.checkRouteMap)) {
                    TheRouterPluginUtils.addTextToFile(this.allClassFile, name, this.theRouterExtension.debug);
                }
                if (!name.contains("$")) {
                    if (name.contains("RouterMap__TheRouter__")) {
                        if (!asmTargetText.contains(name)) {
                            TheRouterPluginUtils.addTextToFile(this.asmTargetFile, name, this.theRouterExtension.debug);
                        }
                        try {
                            reader = new ClassReader((InputStream)new FileInputStream((File)file));
                            cn = new ClassNode();
                            reader.accept((ClassVisitor)cn, 0);
                            List fieldList = cn.fields;
                            buffer = fieldList.iterator();
                            while (buffer.hasNext()) {
                                FieldNode fieldNode = (FieldNode)buffer.next();
                                if (!"ROUTERMAP".equals(fieldNode.name) || routeText.contains((CharSequence)(v = fieldNode.value.toString()))) continue;
                                TheRouterPluginUtils.addTextToFileIgnoreCheck(this.routeFile, (String)v, this.theRouterExtension.debug);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (name.contains("ServiceProvider__TheRouter__")) {
                        if (!asmTargetText.contains(name)) {
                            TheRouterPluginUtils.addTextToFile(this.asmTargetFile, name, this.theRouterExtension.debug);
                        }
                        try {
                            reader = new ClassReader((InputStream)new FileInputStream((File)file));
                            cn = new ClassNode();
                            reader.accept((ClassVisitor)cn, 0);
                            List fieldList = cn.fields;
                            for (FieldNode fieldNode : fieldList) {
                                if (!"FLOW_TASK_JSON".equals(fieldNode.name) || flowTaskText.contains((CharSequence)(v = fieldNode.value.toString()))) continue;
                                TheRouterPluginUtils.addTextToFileIgnoreCheck(this.flowTaskFile, (String)v, this.theRouterExtension.debug);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (name.contains("__TheRouter__Autowired") && !asmTargetText.contains(name)) {
                        TheRouterPluginUtils.addTextToFile(this.asmTargetFile, name, this.theRouterExtension.debug);
                    }
                }
                try (FileInputStream inputStream = new FileInputStream((File)file);){
                    int bytesRead;
                    jarOutput.putNextEntry(new JarEntry(name));
                    byte[] buffer2 = new byte[1024];
                    while ((bytesRead = inputStream.read(buffer2)) != -1) {
                        jarOutput.write(buffer2, 0, bytesRead);
                    }
                    jarOutput.closeEntry();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.isFirst && theRouterJar != null && theRouterServiceProvideInjecter != null) {
            HashMap<String, String> serviceProvideMap = new HashMap<String, String>();
            HashSet<String> autowiredSet = new HashSet<String>();
            HashSet routeSet = new HashSet();
            for (String name : TheRouterPluginUtils.getSetFromFile(this.asmTargetFile)) {
                if ((name = name.substring(0, name.length() - ".class".length())).contains("RouterMap__TheRouter__")) {
                    routeSet.add(name.trim());
                    continue;
                }
                if (name.contains("ServiceProvider__TheRouter__")) {
                    serviceProvideMap.put(name.trim().substring(2), "1.2.4-rc2");
                    continue;
                }
                if (!name.contains("__TheRouter__Autowired")) continue;
                autowiredSet.add(name.trim());
            }
            jarFile = new JarFile(theRouterJar);
            jarOutput.putNextEntry(new JarEntry(theRouterServiceProvideInjecter.getName()));
            ClassReader cr = new ClassReader(jarFile.getInputStream(theRouterServiceProvideInjecter));
            ClassWriter cw = new ClassWriter(2);
            AddCodeVisitor cv = new AddCodeVisitor((ClassVisitor)cw, serviceProvideMap, autowiredSet, routeSet, false);
            cr.accept((ClassVisitor)cv, 2);
            byte[] bytes = cw.toByteArray();
            jarOutput.write(bytes);
            jarOutput.closeEntry();
            jarFile.close();
        }
        jarOutput.close();
        HashSet<RouteItem> pageSet = new HashSet<RouteItem>();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        TheRouterInjects.routeMapStringSet.addAll(TheRouterPluginUtils.getSetFromFile(this.routeFile));
        for (String routeMapString : TheRouterInjects.routeMapStringSet) {
            pageSet.addAll((Collection)gson.fromJson(routeMapString, new TypeToken<List<RouteItem>>(){}.getType()));
        }
        File assetRouteMap = new File(this.getProject().getProjectDir(), "src/main/assets/therouter/routeMap.json");
        if (assetRouteMap.exists()) {
            if ("delete".equalsIgnoreCase(this.theRouterExtension.checkRouteMap)) {
                System.out.println("---------TheRouter delete route map------------------------------------------");
                assetRouteMap.delete();
                try {
                    assetRouteMap.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                String assetString = null;
                try {
                    assetString = ResourceGroovyMethods.getText((File)assetRouteMap, (String)StandardCharsets.UTF_8.displayName());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("---------TheRouter get route map from: /assets/therouter/routeMap.json-------");
                try {
                    ArrayList assetsList = (ArrayList)gson.fromJson(assetString, new TypeToken<List<RouteItem>>(){}.getType());
                    if (assetsList == null) {
                        assetsList = new ArrayList();
                    }
                    for (RouteItem item : assetsList) {
                        if (pageSet.contains(item)) continue;
                        pageSet.add(item);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println("---------TheRouter route map does not exist: /assets/therouter/routeMap.json-------");
            try {
                assetRouteMap.getParentFile().mkdirs();
                assetRouteMap.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, ArrayList<RouteItem>> result = new HashMap<String, ArrayList<RouteItem>>();
        for (RouteItem routeItem : pageSet) {
            ArrayList<RouteItem> routeList;
            String url = routeItem.path;
            if (url.contains("?")) {
                try {
                    URI uri = new URI(routeItem.path);
                    Map<String, String> map = TheRouterTask.extractQueryParams(uri);
                    routeItem.params.putAll(map);
                    url = url.substring(0, url.indexOf(63));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            if ((routeList = (ArrayList<RouteItem>)result.get(url)) == null) {
                routeList = new ArrayList<RouteItem>();
                result.put(url, routeList);
            }
            routeList.add(routeItem);
        }
        for (List routeItems : result.values()) {
            String className = null;
            for (Iterator<String> routeItem : routeItems) {
                if (className == null) {
                    className = ((RouteItem)((Object)routeItem)).className;
                } else if (!className.equals(((RouteItem)((Object)routeItem)).className)) {
                    throw new RuntimeException("Multiple Activity to single Url: " + className + " and " + ((RouteItem)((Object)routeItem)).className);
                }
                if (!TheRouterPluginUtils.needCheckRouteItemClass(this.theRouterExtension.checkRouteMap)) continue;
                boolean classNotFound = true;
                TheRouterInjects.allClass.addAll(TheRouterPluginUtils.getSetFromFile(this.allClassFile));
                for (String item : TheRouterInjects.allClass) {
                    if (!item.contains(((RouteItem)((Object)routeItem)).className.replace(".", "/"))) continue;
                    classNotFound = false;
                    break;
                }
                if (!classNotFound) continue;
                if ("error".equalsIgnoreCase(this.theRouterExtension.checkRouteMap)) {
                    throw new ClassNotFoundException(((RouteItem)((Object)routeItem)).className + " in /assets/therouter/routeMap.json");
                }
                if (!"warning".equalsIgnoreCase(this.theRouterExtension.checkRouteMap)) continue;
                System.out.println(LogUI.C_WARN.getValue() + "[" + ((RouteItem)((Object)routeItem)).className + " in /assets/therouter/routeMap.json]" + LogUI.E_NORMAL.getValue());
            }
        }
        ArrayList pageList = new ArrayList(pageSet);
        Collections.sort(pageList);
        String json = gson.toJson(pageList);
        ResourceGroovyMethods.write((File)assetRouteMap, (String)json, (String)StandardCharsets.UTF_8.displayName());
        System.out.println("---------TheRouter create new route map--------------");
        HashMap<String, Set<String>> flowTaskDependMap = new HashMap<String, Set<String>>();
        Set<String> stringSet = TheRouterPluginUtils.getSetFromFile(this.flowTaskFile);
        for (String str : stringSet) {
            Map map = (Map)TheRouterInjects.gson.fromJson(str, HashMap.class);
            TheRouterInjects.flowTaskMap.putAll(map);
        }
        for (String key : TheRouterInjects.flowTaskMap.keySet()) {
            String dependsOn;
            HashSet<String> value = (HashSet<String>)flowTaskDependMap.get(key);
            if (value == null) {
                value = new HashSet<String>();
            }
            if ((dependsOn = TheRouterInjects.flowTaskMap.get(key)) != null && !dependsOn.isBlank()) {
                String[] dependencies;
                for (String depend : dependencies = dependsOn.split(",")) {
                    if (depend.isBlank()) continue;
                    value.add(depend.trim());
                }
            }
            flowTaskDependMap.put(key, value);
        }
        if (!this.theRouterExtension.checkFlowDepend.isEmpty()) {
            for (String taskName : flowTaskDependMap.keySet()) {
                Set dependencies = (Set)flowTaskDependMap.get(taskName);
                for (String dependency : dependencies) {
                    if (flowTaskDependMap.containsKey(dependency)) continue;
                    if ("error".equalsIgnoreCase(this.theRouterExtension.checkFlowDepend)) {
                        throw new RuntimeException("\n\n==========================================\nTheRouter:: FlowTask::\nCan not found Task: [" + dependency + "] from " + taskName + " dependsOn\n==========================================\n\n");
                    }
                    if (!"warning".equalsIgnoreCase(this.theRouterExtension.checkFlowDepend)) continue;
                    System.out.println();
                    System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "TheRouter:: FlowTask::   " + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "Can not found Task: [" + dependency + "] from " + taskName + " dependsOn" + LogUI.E_NORMAL.getValue());
                    System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
                    System.out.println();
                }
            }
        }
        for (String key : flowTaskDependMap.keySet()) {
            TheRouterPluginUtils.fillTodoList(flowTaskDependMap, key);
        }
        if (this.theRouterExtension.showFlowDepend) {
            for (String key : flowTaskDependMap.keySet()) {
                TheRouterPluginUtils.fillNode(TheRouterPluginUtils.createNode(flowTaskDependMap, key), null);
            }
            System.out.println();
            System.out.println(LogUI.C_WARN.getValue() + "TheRouter:: FlowTask::dependency   " + LogUI.E_NORMAL.getValue());
            System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
            ArrayList<String> dependStack = new ArrayList<String>(TheRouterPluginUtils.dependStack);
            Collections.sort(dependStack);
            for (String it : dependStack) {
                System.out.println(LogUI.C_WARN.getValue() + "[Root --> " + it + "]" + LogUI.E_NORMAL.getValue());
            }
            System.out.println(LogUI.C_WARN.getValue() + "==========================================" + LogUI.E_NORMAL.getValue());
            System.out.println();
        }
        System.out.println("---------TheRouter check flow task map--------------");
    }

    private void checkBuildCache() {
        if (this.isFirst) {
            if (this.theRouterExtension.lang.equals("en")) {
                throw new RuntimeException("\nTheRouter has module additions or removals; please rebuild it again. \nYou can visit the link for more details\uff1a\nhttps://kymjs.com/code/2024/10/31/01/\n\n\n");
            }
            throw new RuntimeException("\nTheRouter \u6709\u6a21\u5757\u589e\u51cf\uff0c\u8bf7\u518d\u6784\u5efa\u4e00\u6b21\u3002\n\u53ef\u8bbf\u95ee\u94fe\u63a5\u67e5\u770b\u8be6\u7ec6\u539f\u56e0\uff1a\nhttps://kymjs.com/code/2024/10/31/01/\n\n\n");
        }
    }

    private static Map<String, String> extractQueryParams(URI uri) {
        LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
        String query = uri.getQuery();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                queryPairs.put(pair.substring(0, idx), pair.substring(idx + 1));
            }
        }
        return queryPairs;
    }
}

