/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.apt;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a#\u0010\u0000\u001a\u00020\u00012\u0016\u0010\u0002\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040\u0003\"\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u000e\u001a\u0016\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0014"}, d2={"closeIO", "", "closeables", "", "Ljava/io/Closeable;", "([Ljava/io/Closeable;)V", "copyFile", "inputStream", "Ljava/io/InputStream;", "out", "Ljava/io/OutputStream;", "getMD5", "", "file", "Ljava/io/File;", "inputStream2String", "readFile", "filePath", "writeStringToFile", "content", "apt"})
public final class FileUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeStringToFile(@NotNull String content, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = new FileOutputStream(file);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileOutputStream fileOutputStream = (FileOutputStream)closeable;
            boolean bl3 = false;
            String string = content;
            Charset charset = Charsets.UTF_8;
            boolean bl4 = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public static final String readFile(@NotNull File filePath) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        InputStream inputStream2 = null;
        try {
            inputStream = new FileInputStream(filePath);
        }
        catch (Exception e) {
            throw new RuntimeException("FileUtils:readFile---->" + filePath + " not found");
        }
        inputStream2 = inputStream;
        return FileUtilsKt.inputStream2String(inputStream2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    public static final String inputStream2String(@Nullable InputStream inputStream) {
        Object object;
        if (inputStream == null) {
            return null;
        }
        StringBuilder resultSb = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            resultSb = new StringBuilder();
            String len = null;
            while (true) {
                String string = br.readLine();
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                len = it;
                if (string == null) break;
                resultSb.append(len);
            }
        }
        catch (Exception exception) {
            object = new Closeable[]{inputStream};
            FileUtilsKt.closeIO((Closeable[])object);
            catch (Throwable throwable) {
                Closeable[] closeableArray = new Closeable[]{inputStream};
                FileUtilsKt.closeIO(closeableArray);
                throw throwable;
            }
        }
        object = new Closeable[]{inputStream};
        FileUtilsKt.closeIO((Closeable[])object);
        object = resultSb;
        return object == null ? null : ((StringBuilder)object).toString();
    }

    public static final void copyFile(@NotNull InputStream inputStream, @NotNull OutputStream out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        byte[] buffer = new byte[1024];
        int read = 0;
        while (true) {
            int n = inputStream.read(buffer);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            read = it;
            if (n == -1) break;
            out.write(buffer, 0, read);
        }
    }

    @Nullable
    public static final String getMD5(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isFile()) {
            return null;
        }
        MessageDigest digest = null;
        FileInputStream inputStream = null;
        byte[] buffer = new byte[1024];
        int len = 0;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(\"MD5\")");
            digest = messageDigest;
            inputStream = new FileInputStream(file);
            while (true) {
                int n = inputStream.read(buffer, 0, 1024);
                boolean bl = false;
                boolean bl2 = false;
                int it = n;
                boolean bl3 = false;
                len = it;
                if (n == -1) break;
                digest.update(buffer, 0, len);
            }
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        BigInteger bigInt = new BigInteger(1, digest.digest());
        return bigInt.toString(16);
    }

    public static final void closeIO(Closeable ... closeables) {
        Intrinsics.checkNotNullParameter((Object)closeables, (String)"closeables");
        Closeable[] closeableArray = closeables;
        int n = 0;
        if (closeableArray.length == 0) {
            return;
        }
        for (Closeable cb : closeables) {
            try {
                if (cb == null) continue;
                cb.close();
            }
            catch (IOException e) {
                throw new RuntimeException("FileUtils", e);
            }
        }
    }
}

