/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.okjdy.core.client.impl;

import cn.toint.okjdy.core.client.JdyClient;
import cn.toint.okjdy.core.config.JdyClientConfig;
import cn.toint.okjdy.core.enums.JdyFieldTypeEnum;
import cn.toint.okjdy.core.enums.JdyUrlEnum;
import cn.toint.okjdy.core.event.JdyRequestEvent;
import cn.toint.okjdy.core.exception.JdyRequestLimitException;
import cn.toint.okjdy.core.model.JdyApp;
import cn.toint.okjdy.core.model.JdyAppListRequest;
import cn.toint.okjdy.core.model.JdyCondition;
import cn.toint.okjdy.core.model.JdyDataDeleteBatchRequest;
import cn.toint.okjdy.core.model.JdyDataDeleteRequest;
import cn.toint.okjdy.core.model.JdyDataGetRequest;
import cn.toint.okjdy.core.model.JdyDataSaveBatchRequest;
import cn.toint.okjdy.core.model.JdyDataSaveRequest;
import cn.toint.okjdy.core.model.JdyDataUpdateBatchRequest;
import cn.toint.okjdy.core.model.JdyDataUpdateRequest;
import cn.toint.okjdy.core.model.JdyDo;
import cn.toint.okjdy.core.model.JdyEntry;
import cn.toint.okjdy.core.model.JdyEntryListRequest;
import cn.toint.okjdy.core.model.JdyField;
import cn.toint.okjdy.core.model.JdyFieldListRequest;
import cn.toint.okjdy.core.model.JdyFieldListResponse;
import cn.toint.okjdy.core.model.JdyFileGetUploadTokenResponse;
import cn.toint.okjdy.core.model.JdyFileUploadRequest;
import cn.toint.okjdy.core.model.JdyFileUploadResponse;
import cn.toint.okjdy.core.model.JdyListDataRequest;
import cn.toint.okjdy.core.util.JdyDataRequestConvertUtil;
import cn.toint.okjdy.core.util.JdyHttpUtil;
import cn.toint.oktool.util.Assert;
import cn.toint.oktool.util.ExceptionUtil;
import cn.toint.oktool.util.JacksonUtil;
import cn.toint.oktool.util.KeyBuilderUtil;
import cn.toint.oktool.util.RetryUtil;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.cache.CacheUtil;
import org.dromara.hutool.core.cache.impl.TimedCache;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.date.TimeUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.net.url.UrlBuilder;
import org.dromara.hutool.core.net.url.UrlQuery;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.client.body.HttpBody;
import org.dromara.hutool.http.client.body.MultipartBody;
import org.dromara.hutool.http.meta.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdyClientImpl
implements JdyClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdyClientImpl.class);
    private final JdyClientConfig jdyClientConfig;
    private final List<String> whiteContentType = List.of("application/json;charset=UTF-8", "application/json");
    private final TimedCache<String, JdyFieldListResponse> fieldCache = CacheUtil.newTimedCache((long)Duration.ofSeconds(30L).toMillis(), (long)Duration.ofSeconds(30L).toMillis());

    public JdyClientImpl(@Nonnull JdyClientConfig jdyClientConfig) {
        Assert.validate((Object)jdyClientConfig, (CharSequence)"jdyClient init error, cause: {}", (Object[])new Object[0]);
        this.jdyClientConfig = jdyClientConfig;
    }

    @Override
    @Nonnull
    public List<JdyApp> listApp(@Nonnull JdyAppListRequest jdyAppListRequest) {
        List apps;
        Assert.notNull((Object)jdyAppListRequest, (CharSequence)"jdyAppRequest must not be null", (Object[])new Object[0]);
        int onceSize = 100;
        AtomicInteger limit = new AtomicInteger(jdyAppListRequest.getLimit());
        AtomicInteger skip = new AtomicInteger(jdyAppListRequest.getSkip());
        ArrayList<JdyApp> response = new ArrayList<JdyApp>();
        do {
            JdyAppListRequest reqBody = new JdyAppListRequest();
            reqBody.setLimit(Math.min(limit.get(), 100));
            reqBody.setSkip(skip.get());
            Request request = Request.of((String)JdyUrlEnum.LIST_APP.getUrl()).method(JdyUrlEnum.LIST_APP.getMethod()).body(JacksonUtil.writeValueAsString((Object)reqBody));
            String resBody = this.request(request);
            apps = Optional.of(resBody).map(JacksonUtil::readTree).map(jsonNode -> jsonNode.path("apps")).filter(JsonNode::isArray).map(jsonNode -> (List)JacksonUtil.treeToValue((TreeNode)jsonNode, (TypeReference)new TypeReference<List<JdyApp>>(this){})).orElseThrow(() -> ExceptionUtil.wrapRuntimeException((String)"\u7b80\u9053\u4e91\u54cd\u5e94\u5f02\u5e38, body: {}", (Object[])new Object[]{resBody}));
            response.addAll(apps);
            limit.addAndGet(-apps.size());
            skip.addAndGet(apps.size());
        } while (apps.size() >= 100 && limit.get() > 0);
        return response;
    }

    @Override
    @Nonnull
    public List<JdyEntry> listEntry(@Nonnull JdyEntryListRequest jdyEntryListRequest) {
        List forms;
        Assert.validate((Object)jdyEntryListRequest, (CharSequence)"jdyEntryRequest valid error, cause: {}", (Object[])new Object[0]);
        int onceSize = 100;
        AtomicInteger limit = new AtomicInteger(jdyEntryListRequest.getLimit());
        AtomicInteger skip = new AtomicInteger(jdyEntryListRequest.getSkip());
        ArrayList<JdyEntry> response = new ArrayList<JdyEntry>();
        do {
            JdyEntryListRequest reqBody = new JdyEntryListRequest();
            reqBody.setAppId(jdyEntryListRequest.getAppId());
            reqBody.setLimit(Math.min(limit.get(), 100));
            reqBody.setSkip(skip.get());
            Request request = Request.of((String)JdyUrlEnum.LIST_ENTRY.getUrl()).method(JdyUrlEnum.LIST_ENTRY.getMethod()).body(JacksonUtil.writeValueAsString((Object)reqBody));
            String resBody = this.request(request);
            forms = Optional.of(resBody).map(JacksonUtil::readTree).map(jsonNode -> jsonNode.path("forms")).filter(JsonNode::isArray).map(jsonNode -> (List)JacksonUtil.treeToValue((TreeNode)jsonNode, (TypeReference)new TypeReference<List<JdyEntry>>(this){})).orElseThrow(() -> ExceptionUtil.wrapRuntimeException((String)"\u7b80\u9053\u4e91\u54cd\u5e94\u5f02\u5e38, body: {}", (Object[])new Object[]{resBody}));
            response.addAll(forms);
            limit.addAndGet(-forms.size());
            skip.addAndGet(forms.size());
        } while (forms.size() >= 100 && limit.get() > 0);
        return response;
    }

    @Override
    @Nonnull
    public JdyFieldListResponse listField(@Nonnull JdyFieldListRequest jdyFieldListRequest) {
        Assert.validate((Object)jdyFieldListRequest, (CharSequence)"jdyFieldListRequest valid error, cause: {}", (Object[])new Object[0]);
        String key = KeyBuilderUtil.of((String)jdyFieldListRequest.getAppId()).build(jdyFieldListRequest.getEntryId());
        JdyFieldListResponse responseByCache = (JdyFieldListResponse)this.fieldCache.get((Object)key, false);
        if (responseByCache != null) {
            return responseByCache;
        }
        Request request = Request.of((String)JdyUrlEnum.LIST_WIDGET.getUrl()).method(JdyUrlEnum.LIST_WIDGET.getMethod()).body(JacksonUtil.writeValueAsString((Object)jdyFieldListRequest));
        String resBody = this.request(request);
        JdyFieldListResponse jdyFieldListResponse = Optional.of(resBody).map(str -> (JdyFieldListResponse)JacksonUtil.readValue((String)str, JdyFieldListResponse.class)).orElseThrow(() -> ExceptionUtil.wrapRuntimeException((String)"\u7b80\u9053\u4e91\u54cd\u5e94\u5f02\u5e38, body: {}", (Object[])new Object[]{resBody}));
        Assert.validate((Object)jdyFieldListResponse, (CharSequence)"\u7b80\u9053\u4e91\u54cd\u5e94\u5f02\u5e38, body: {}, cause: {}", (Object[])new Object[]{resBody});
        this.fieldCache.put((Object)key, (Object)jdyFieldListResponse);
        return jdyFieldListResponse;
    }

    @Override
    @Nullable
    public JsonNode getData(@Nonnull JdyDataGetRequest jdyDataGetRequest) {
        Assert.validate((Object)jdyDataGetRequest, (CharSequence)"jdyDataGetRequest valid error, cause: {}", (Object[])new Object[0]);
        Request request = Request.of((String)JdyUrlEnum.GET_DATA.getUrl()).method(JdyUrlEnum.GET_DATA.getMethod()).body(JacksonUtil.writeValueAsString((Object)jdyDataGetRequest));
        String resBody = this.request(request);
        return Optional.of(resBody).map(JacksonUtil::readTree).map(jsonNode -> jsonNode.get("data")).orElse(null);
    }

    @Override
    @Nonnull
    public <T extends JdyDo> T getData(@Nonnull JdyDataGetRequest jdyDataGetRequest, @Nonnull Class<T> responseClass) {
        Assert.notNull(responseClass, (CharSequence)"responseClass must not be null", (Object[])new Object[0]);
        return (T)((JdyDo)JacksonUtil.treeToValue((TreeNode)this.getData(jdyDataGetRequest), responseClass));
    }

    @Override
    @Nonnull
    public JsonNode listData(@Nonnull JdyListDataRequest jdyListDataRequest) {
        return this.listData(jdyListDataRequest, (JsonNode jsonNode) -> true);
    }

    @Override
    @Nonnull
    public <T extends JdyDo> List<T> listData(@Nonnull JdyListDataRequest jdyListDataRequest, @Nonnull Class<T> responseType) {
        return this.listData(jdyListDataRequest, responseType, jsonNode -> true);
    }

    @Override
    @Nonnull
    public JsonNode listData(@Nonnull JdyListDataRequest jdyListDataRequest, @Nullable Predicate<JsonNode> predicate) {
        Assert.validate((Object)jdyListDataRequest, (CharSequence)"jdyListRequest valid error, cause: {}", (Object[])new Object[0]);
        this.convertConditionFieldValue(jdyListDataRequest);
        int onceSize = 100;
        AtomicInteger limit = new AtomicInteger(jdyListDataRequest.getLimit());
        ArrayNode response = JacksonUtil.createArrayNode();
        while (true) {
            JdyListDataRequest reqBody = new JdyListDataRequest();
            reqBody.setAppId(jdyListDataRequest.getAppId());
            reqBody.setEntryId(jdyListDataRequest.getEntryId());
            reqBody.setDataId(jdyListDataRequest.getDataId());
            reqBody.setFields(jdyListDataRequest.getFields());
            reqBody.setFilter(jdyListDataRequest.getFilter());
            reqBody.setLimit(Math.min(limit.get(), 100));
            Request request = Request.of((String)JdyUrlEnum.LIST_DATA.getUrl()).method(JdyUrlEnum.LIST_DATA.getMethod()).body(JacksonUtil.writeValueAsString((Object)reqBody));
            String resBody = this.request(request);
            JsonNode data = Optional.of(resBody).map(JacksonUtil::readTree).map(jsonNode -> jsonNode.path("data")).filter(JsonNode::isArray).orElseThrow(() -> ExceptionUtil.wrapRuntimeException((String)"\u7b80\u9053\u4e91\u54cd\u5e94\u5f02\u5e38, body: {}", (Object[])new Object[]{resBody}));
            try {
                if (!JacksonUtil.isEmpty((JsonNode)data) && (predicate == null || predicate.test(data))) {
                    ArrayNode arr = (ArrayNode)data.deepCopy();
                    response.addAll(arr);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            limit.addAndGet(-data.size());
            String lastDataId = this.getLastDataId(data);
            if (data.size() < 100 || limit.get() <= 0 || StringUtils.isBlank((CharSequence)lastDataId)) break;
            jdyListDataRequest.setDataId(lastDataId);
        }
        return response;
    }

    @Override
    @Nonnull
    public <T extends JdyDo> List<T> listData(@Nonnull JdyListDataRequest jdyListDataRequest, @Nonnull Class<T> responseType, @Nullable Predicate<JsonNode> predicate) {
        Assert.notNull(responseType, (CharSequence)"responseType must not be null", (Object[])new Object[0]);
        ArrayList<JdyDo> response = new ArrayList<JdyDo>();
        for (JsonNode item : this.listData(jdyListDataRequest, predicate)) {
            response.add((JdyDo)JacksonUtil.treeToValue((TreeNode)item, responseType));
        }
        return response;
    }

    @Override
    @Nonnull
    public JsonNode saveData(@Nonnull JdyDataSaveRequest jdyDataSaveRequest) {
        Assert.validate((Object)jdyDataSaveRequest, (CharSequence)"jdyDataSaveRequest valid error, cause: {}", (Object[])new Object[0]);
        JdyFieldListResponse jdyFieldListResponse = this.listField(JdyFieldListRequest.of(jdyDataSaveRequest.getData()));
        JsonNode newData = JdyDataRequestConvertUtil.convert(jdyDataSaveRequest.getData(), jdyFieldListResponse.getWidgets());
        jdyDataSaveRequest.setData(newData);
        Request request = Request.of((String)JdyUrlEnum.SAVE_ONE_DATA.getUrl()).method(JdyUrlEnum.SAVE_ONE_DATA.getMethod()).body(JacksonUtil.writeValueAsString((Object)jdyDataSaveRequest));
        String resBody = this.request(request);
        return Optional.of(resBody).map(JacksonUtil::readTree).map(jsonNode -> jsonNode.path("data")).filter(jsonNode -> StringUtils.isNotBlank((CharSequence)jsonNode.path("_id").asText())).orElseThrow(() -> ExceptionUtil.wrapRuntimeException((String)"\u7b80\u9053\u4e91\u54cd\u5e94\u5f02\u5e38, body: {}", (Object[])new Object[]{resBody}));
    }

    @Override
    @Nonnull
    public <T> T saveData(@Nonnull JdyDataSaveRequest jdyDataSaveRequest, @Nonnull Class<T> responseClass) {
        return (T)JacksonUtil.treeToValue((TreeNode)this.saveData(jdyDataSaveRequest), responseClass);
    }

    @Override
    @Nonnull
    public List<String> saveBatchData(@Nonnull JdyDataSaveBatchRequest jdyDataSaveBatchRequest) {
        Assert.validate((Object)jdyDataSaveBatchRequest, (CharSequence)"jdyDataSaveRequest valid error, cause: {}", (Object[])new Object[0]);
        JsonNode datas = jdyDataSaveBatchRequest.getDatas();
        Assert.notEmpty((Iterable)datas, (CharSequence)"datas must not be empty", (Object[])new Object[0]);
        Assert.isTrue((boolean)datas.isArray(), (CharSequence)"datas must be array", (Object[])new Object[0]);
        JdyFieldListResponse jdyFieldListResponse = this.listField(JdyFieldListRequest.of(datas.path(0)));
        ArrayList<JsonNode> newDatas = new ArrayList<JsonNode>();
        for (JsonNode item : datas) {
            JsonNode newData = JdyDataRequestConvertUtil.convert(item, jdyFieldListResponse.getWidgets());
            newDatas.add(newData);
        }
        ArrayList<String> successIds = new ArrayList<String>();
        for (List jsonNodes : CollUtil.partition(newDatas, (int)100)) {
            jdyDataSaveBatchRequest.setDatas(JacksonUtil.valueToTree((Object)jsonNodes));
            Request request = Request.of((String)JdyUrlEnum.SAVE_BATCH_DATA.getUrl()).method(JdyUrlEnum.SAVE_BATCH_DATA.getMethod()).body(JacksonUtil.writeValueAsString((Object)jdyDataSaveBatchRequest));
            String resBody = this.request(request);
            List ids = Optional.of(resBody).map(JacksonUtil::readTree).map(jsonNode -> jsonNode.path("success_ids")).filter(JsonNode::isArray).map(jsonNode -> (List)JacksonUtil.treeToValue((TreeNode)jsonNode, (TypeReference)new TypeReference<List<String>>(this){})).orElseThrow(() -> ExceptionUtil.wrapRuntimeException((String)"\u7b80\u9053\u4e91\u54cd\u5e94\u5f02\u5e38, body: {}", (Object[])new Object[]{resBody}));
            successIds.addAll(ids);
        }
        return successIds;
    }

    @Override
    @Nonnull
    public JsonNode updateData(@Nonnull JdyDataUpdateRequest jdyDataUpdateRequest, boolean ignoreNull) {
        Assert.validate((Object)jdyDataUpdateRequest, (CharSequence)"jdyDataUpdateRequest valid error, cause: {}", (Object[])new Object[0]);
        if (ignoreNull) {
            Iterator iterator = jdyDataUpdateRequest.getData().iterator();
            while (iterator.hasNext()) {
                if (!JacksonUtil.isNull((JsonNode)((JsonNode)iterator.next()))) continue;
                iterator.remove();
            }
        }
        JdyFieldListResponse jdyFieldListResponse = this.listField(JdyFieldListRequest.of(jdyDataUpdateRequest.getData()));
        JsonNode newData = JdyDataRequestConvertUtil.convert(jdyDataUpdateRequest.getData(), jdyFieldListResponse.getWidgets());
        jdyDataUpdateRequest.setData(newData);
        Request request = Request.of((String)JdyUrlEnum.UPDATE_ONE_DATA.getUrl()).method(JdyUrlEnum.UPDATE_ONE_DATA.getMethod()).body(JacksonUtil.writeValueAsString((Object)jdyDataUpdateRequest));
        String resBody = this.request(request);
        return Optional.of(resBody).map(JacksonUtil::readTree).map(jsonNode -> jsonNode.path("data")).filter(jsonNode -> StringUtils.isNotBlank((CharSequence)jsonNode.path("_id").asText())).orElseThrow(() -> ExceptionUtil.wrapRuntimeException((String)"\u7b80\u9053\u4e91\u54cd\u5e94\u5f02\u5e38, body: {}", (Object[])new Object[]{resBody}));
    }

    @Override
    @Nonnull
    public <T extends JdyDo> T updateData(@Nonnull JdyDataUpdateRequest jdyDataUpdateRequest, boolean ignoreNull, @Nonnull Class<T> responseType) {
        Assert.notNull(responseType, (CharSequence)"responseType must not be null", (Object[])new Object[0]);
        return (T)((JdyDo)JacksonUtil.treeToValue((TreeNode)this.updateData(jdyDataUpdateRequest, ignoreNull), responseType));
    }

    @Override
    public int updateBatchData(@Nonnull JdyDataUpdateBatchRequest jdyDataUpdateBatchRequest, boolean ignoreNull) {
        Assert.validate((Object)jdyDataUpdateBatchRequest, (CharSequence)"jdyDataUpdateBatchRequest valid error, cause: {}", (Object[])new Object[0]);
        if (ignoreNull) {
            Iterator iterator = jdyDataUpdateBatchRequest.getData().iterator();
            while (iterator.hasNext()) {
                if (!JacksonUtil.isNull((JsonNode)((JsonNode)iterator.next()))) continue;
                iterator.remove();
            }
        }
        JdyFieldListResponse jdyFieldListResponse = this.listField(JdyFieldListRequest.of(jdyDataUpdateBatchRequest.getData()));
        JsonNode newData = JdyDataRequestConvertUtil.convert(jdyDataUpdateBatchRequest.getData(), jdyFieldListResponse.getWidgets());
        jdyDataUpdateBatchRequest.setData(newData);
        AtomicInteger successCount = new AtomicInteger();
        CollUtil.partition(jdyDataUpdateBatchRequest.getDataIds(), (int)100).forEach(dataIds -> {
            jdyDataUpdateBatchRequest.setDataIds((Collection<String>)dataIds);
            Request request = Request.of((String)JdyUrlEnum.UPDATE_BATCH_DATA.getUrl()).method(JdyUrlEnum.UPDATE_BATCH_DATA.getMethod()).body(JacksonUtil.writeValueAsString((Object)jdyDataUpdateBatchRequest));
            String resBody = this.request(request);
            int count = Optional.of(resBody).map(JacksonUtil::readTree).map(jsonNode -> jsonNode.path("success_count").asInt(-1)).filter(num -> num >= 0).orElseThrow(() -> ExceptionUtil.wrapRuntimeException((String)"\u7b80\u9053\u4e91\u54cd\u5e94\u5f02\u5e38, body: {}", (Object[])new Object[]{resBody}));
            successCount.addAndGet(count);
        });
        return successCount.get();
    }

    @Override
    public boolean deleteData(@Nonnull JdyDataDeleteRequest jdyDataDeleteRequest) {
        String resBody;
        Assert.validate((Object)jdyDataDeleteRequest, (CharSequence)"jdyDataDeleteRequest valid error, cause: {}", (Object[])new Object[0]);
        Request request = Request.of((String)JdyUrlEnum.DELETE_ONE_DATA.getUrl()).method(JdyUrlEnum.DELETE_ONE_DATA.getMethod()).body(JacksonUtil.writeValueAsString((Object)jdyDataDeleteRequest));
        try {
            resBody = this.request(request);
        }
        catch (Exception e) {
            return false;
        }
        return Optional.of(resBody).map(JacksonUtil::readTree).map(jsonNode -> jsonNode.path("status").asText()).filter(str -> Objects.equals("success", str)).isPresent();
    }

    @Override
    public int deleteBatchData(@Nonnull JdyDataDeleteBatchRequest jdyDataDeleteBatchRequest) {
        Assert.validate((Object)jdyDataDeleteBatchRequest, (CharSequence)"jdyDataDeleteBatchRequest valid error, cause: {}", (Object[])new Object[0]);
        AtomicInteger successCount = new AtomicInteger();
        CollUtil.partition(jdyDataDeleteBatchRequest.getDataIds(), (int)100).forEach(dataIds -> {
            jdyDataDeleteBatchRequest.setDataIds((Collection<String>)dataIds);
            Request request = Request.of((String)JdyUrlEnum.DELETE_BATCH_DATA.getUrl()).method(JdyUrlEnum.DELETE_BATCH_DATA.getMethod()).body(JacksonUtil.writeValueAsString((Object)jdyDataDeleteBatchRequest));
            String resBody = this.request(request);
            int count = Optional.of(resBody).map(JacksonUtil::readTree).map(jsonNode -> jsonNode.path("success_count").asInt()).orElseThrow(() -> ExceptionUtil.wrapRuntimeException((String)"\u7b80\u9053\u4e91\u54cd\u5e94\u5f02\u5e38, body: {}", (Object[])new Object[]{resBody}));
            successCount.addAndGet(count);
        });
        return successCount.get();
    }

    @Override
    @Nonnull
    public JdyFileUploadResponse uploadFile(@Nonnull JdyFileUploadRequest jdyFileUploadRequest, @Nonnull Collection<File> files) {
        Assert.validate((Object)jdyFileUploadRequest, (CharSequence)"jdyFileUploadRequest valid error, cause: {}", (Object[])new Object[0]);
        Assert.notEmpty(files, (CharSequence)"files must not be empty", (Object[])new Object[0]);
        Set fileSet = files.stream().filter(FileUtil::exists).collect(Collectors.toSet());
        Assert.notEmpty(fileSet, (CharSequence)"files must not be empty", (Object[])new Object[0]);
        ArrayDeque tokenAndUrls = new ArrayDeque();
        Request request = Request.of((String)JdyUrlEnum.GET_UPLOAD_TOKEN.getUrl()).method(JdyUrlEnum.GET_UPLOAD_TOKEN.getMethod()).body(JacksonUtil.writeValueAsString((Object)jdyFileUploadRequest));
        do {
            String resBody = this.request(request);
            List getUploadTokenResponses = Optional.of(resBody).map(JacksonUtil::readTree).map(jsonNode -> jsonNode.path("token_and_url_list")).filter(JsonNode::isArray).map(jsonNode -> (List)JacksonUtil.treeToValue((TreeNode)jsonNode, (TypeReference)new TypeReference<List<JdyFileGetUploadTokenResponse>>(this){})).orElseThrow(() -> ExceptionUtil.wrapRuntimeException((String)"\u7b80\u9053\u4e91\u54cd\u5e94\u5f02\u5e38, body: {}", (Object[])new Object[]{resBody}));
            getUploadTokenResponses.forEach(item -> Assert.validate((Object)item, (CharSequence)"jdyGetUploadTokenResponse valid error, cause: {}", (Object[])new Object[0]));
            tokenAndUrls.addAll(getUploadTokenResponses);
        } while (tokenAndUrls.size() < fileSet.size());
        JdyFileUploadResponse jdyFileUploadResponse = new JdyFileUploadResponse();
        jdyFileUploadResponse.setTransactionId(jdyFileUploadRequest.getTransactionId());
        for (File file : fileSet) {
            JdyFileGetUploadTokenResponse tokenAndUrl = (JdyFileGetUploadTokenResponse)tokenAndUrls.pop();
            HashMap<String, Object> bodyMap = new HashMap<String, Object>();
            bodyMap.put("token", tokenAndUrl.getToken());
            bodyMap.put("file", file);
            Request uploadFileRequest = Request.of((String)tokenAndUrl.getUrl()).method(Method.POST).body((HttpBody)MultipartBody.of(bodyMap, (Charset)StandardCharsets.UTF_8));
            String resBody = (String)RetryUtil.execute(() -> this.executeRequest(uploadFileRequest), this.jdyClientConfig.getRetryPolicy());
            String key = Optional.of(resBody).map(JacksonUtil::readTree).map(jsonNode -> jsonNode.path("key").asText()).filter(StringUtils::isNotBlank).orElseThrow(() -> ExceptionUtil.wrapRuntimeException((String)"\u7b80\u9053\u4e91\u54cd\u5e94\u5f02\u5e38, body: {}", (Object[])new Object[]{resBody}));
            jdyFileUploadResponse.getFileKeyMap().put(file, key);
        }
        return jdyFileUploadResponse;
    }

    @Nonnull
    private String request(@Nonnull Request request) {
        Assert.notNull((Object)request, (CharSequence)"request must not be null", (Object[])new Object[0]);
        Assert.validate((Object)this.jdyClientConfig, (CharSequence)"jdyClientConfig valid error, cause: {}", (Object[])new Object[0]);
        Assert.notNull((Object)request.url(), (CharSequence)"url must not be null", (Object[])new Object[0]);
        String pathStr = request.url().getPathStr();
        UrlQuery query = request.url().getQuery();
        Assert.notBlank((CharSequence)pathStr, (CharSequence)"path must not be blank", (Object[])new Object[0]);
        request.url(UrlBuilder.ofHttp((String)this.jdyClientConfig.getUrl()).addPath((CharSequence)pathStr).setQuery(query));
        request.header("Authorization", "Bearer " + this.jdyClientConfig.getApiKey());
        return (String)RetryUtil.execute(() -> this.executeRequest(request), this.jdyClientConfig.getRetryPolicy());
    }

    /*
     * Loose catch block
     */
    @Nonnull
    private String executeRequest(@Nonnull Request request) throws IOException {
        String string;
        Response response;
        LocalDateTime startTime;
        Map headers;
        Integer status;
        String bodyStr;
        block14: {
            block13: {
                bodyStr = null;
                status = null;
                headers = null;
                startTime = LocalDateTime.now();
                response = this.jdyClientConfig.getClientEngine().send(request);
                bodyStr = response.bodyStr();
                headers = response.headers();
                status = response.getStatus();
                if (JdyHttpUtil.isLimitException(bodyStr)) {
                    throw new JdyRequestLimitException(StrUtil.format((CharSequence)"\u7b80\u9053\u4e91\u63a5\u53e3\u8d85\u51fa\u9891\u7387\u9650\u5236, status: {}, body: {}", (Object[])new Object[]{status, bodyStr}));
                }
                if (StringUtils.isBlank((CharSequence)bodyStr)) {
                    throw new RuntimeException(StrUtil.format((CharSequence)"\u7b80\u9053\u4e91\u54cd\u5e94\u5f02\u5e38, status: {}, body: {}", (Object[])new Object[]{status, bodyStr}));
                }
                string = bodyStr;
                if (response == null) break block13;
                response.close();
            }
            if (this.jdyClientConfig.getJdyRequestConsumer() == null) break block14;
            JdyRequestEvent.RequestInfo requestInfo = new JdyRequestEvent.RequestInfo();
            requestInfo.setUrl(request.url() == null ? null : request.url().build());
            requestInfo.setMethod(request.method() == null ? null : request.method().name());
            requestInfo.setRequestHeader(request.headers());
            requestInfo.setRequestTime(startTime);
            requestInfo.setResponseBody(bodyStr);
            requestInfo.setResponseHeader(headers);
            requestInfo.setStatus(status);
            requestInfo.setResponseTime(LocalDateTime.now());
            requestInfo.setDurationTime(TimeUtil.between((LocalDateTime)requestInfo.getRequestTime(), (LocalDateTime)requestInfo.getResponseTime(), (ChronoUnit)ChronoUnit.MILLIS));
            String contentType = request.header("Content-Type");
            if (StringUtils.isNotBlank((CharSequence)contentType) && this.whiteContentType.contains(contentType)) {
                requestInfo.setRequestBody(request.bodyStr());
            }
            Thread.startVirtualThread(() -> this.jdyClientConfig.getJdyRequestConsumer().accept(new JdyRequestEvent(requestInfo)));
        }
        return string;
        {
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    if (this.jdyClientConfig.getJdyRequestConsumer() != null) {
                        JdyRequestEvent.RequestInfo requestInfo2 = new JdyRequestEvent.RequestInfo();
                        requestInfo2.setUrl(request.url() == null ? null : request.url().build());
                        requestInfo2.setMethod(request.method() == null ? null : request.method().name());
                        requestInfo2.setRequestHeader(request.headers());
                        requestInfo2.setRequestTime(startTime);
                        requestInfo2.setResponseBody(bodyStr);
                        requestInfo2.setResponseHeader(headers);
                        requestInfo2.setStatus(status);
                        requestInfo2.setResponseTime(LocalDateTime.now());
                        requestInfo2.setDurationTime(TimeUtil.between((LocalDateTime)requestInfo2.getRequestTime(), (LocalDateTime)requestInfo2.getResponseTime(), (ChronoUnit)ChronoUnit.MILLIS));
                        String contentType2 = request.header("Content-Type");
                        if (StringUtils.isNotBlank((CharSequence)contentType2) && this.whiteContentType.contains(contentType2)) {
                            requestInfo2.setRequestBody(request.bodyStr());
                        }
                        Thread.startVirtualThread(() -> this.jdyClientConfig.getJdyRequestConsumer().accept(new JdyRequestEvent(requestInfo)));
                    }
                    throw throwable3;
                }
            }
        }
    }

    @Nullable
    private String getLastDataId(@Nonnull JsonNode jsonNode) {
        if (JacksonUtil.isEmpty((JsonNode)jsonNode) || !jsonNode.isArray()) {
            return null;
        }
        int index = jsonNode.size() - 1;
        return jsonNode.path(index).path("_id").asText(null);
    }

    private void convertConditionFieldValue(@Nonnull JdyListDataRequest jdyListDataRequest) {
        Collection<JdyCondition> conditions = jdyListDataRequest.getFilter().getCondition();
        if (CollUtil.isEmpty(conditions) || conditions.stream().map(JdyCondition::getValue).noneMatch(Objects::nonNull)) {
            return;
        }
        JdyFieldListRequest jdyFieldListRequest = new JdyFieldListRequest();
        jdyFieldListRequest.setAppId(jdyListDataRequest.getAppId());
        jdyFieldListRequest.setEntryId(jdyListDataRequest.getEntryId());
        JdyFieldListResponse jdyFieldListResponse = this.listField(jdyFieldListRequest);
        List<JdyField> fields = jdyFieldListResponse.getWidgets();
        if (CollUtil.isEmpty(fields)) {
            return;
        }
        Map<String, String> nameTypeMap = fields.stream().collect(Collectors.toMap(JdyField::getName, JdyField::getType));
        for (JdyCondition condition : conditions) {
            String fieldName = condition.getField();
            Collection<Object> values = condition.getValue();
            String type = nameTypeMap.get(fieldName);
            condition.setType(type);
            if (CollUtil.isEmpty(values)) continue;
            ArrayList<Object> newValues = new ArrayList<Object>();
            for (Object value : values) {
                Object newValue = JdyFieldTypeEnum.NUMBER.getValue().equals(type) ? ConvertUtil.toNumber((Object)value) : ConvertUtil.toStr((Object)value);
                Assert.notNull((Object)newValue, (CharSequence)("\u5b57\u6bb5[" + fieldName + "]\u503c\u8f6c\u6362\u5931\u8d25"), (Object[])new Object[0]);
                newValues.add(newValue);
            }
            condition.setValue(newValues);
        }
    }
}

