/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.okjdy.core.config;

import cn.toint.okjdy.core.event.JdyRequestEvent;
import cn.toint.okjdy.core.exception.JdyRequestLimitException;
import cn.toint.oktool.model.RetryPolicy;
import cn.toint.oktool.util.HttpClientUtil;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.http.client.ClientConfig;
import org.dromara.hutool.http.client.engine.ClientEngine;
import org.dromara.hutool.http.client.engine.okhttp.OkHttpEngine;

public class JdyClientConfig {
    @NotBlank
    private String url = "https://api.jiandaoyun.com";
    @NotBlank
    private String apiKey;
    @NotNull
    private ClientEngine clientEngine = this.defaultClientEngine();
    @NotNull
    private List<RetryPolicy> retryPolicy = this.defaultRetryPolicies();
    @Nullable
    private Consumer<JdyRequestEvent> jdyRequestConsumer;

    public JdyClientConfig(String apiKey) {
        Assert.notBlank((CharSequence)apiKey, (String)"apiKey must not be blank", (Object[])new Object[0]);
        this.apiKey = apiKey;
    }

    private ClientEngine defaultClientEngine() {
        ClientConfig clientConfig = ClientConfig.of().setTimeout((int)Duration.ofSeconds(10L).toMillis());
        return HttpClientUtil.clientEngine(OkHttpEngine.class, (ClientConfig)clientConfig);
    }

    private List<RetryPolicy> defaultRetryPolicies() {
        ArrayList<RetryPolicy> retryPolicies = new ArrayList<RetryPolicy>();
        retryPolicies.add(new RetryPolicy(Integer.MAX_VALUE, Duration.ofSeconds(1L), JdyRequestLimitException.class, true));
        retryPolicies.add(new RetryPolicy(3, Duration.ofSeconds(1L), Exception.class, true));
        return retryPolicies;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    @Generated
    public ClientEngine getClientEngine() {
        return this.clientEngine;
    }

    @Generated
    public List<RetryPolicy> getRetryPolicy() {
        return this.retryPolicy;
    }

    @Nullable
    @Generated
    public Consumer<JdyRequestEvent> getJdyRequestConsumer() {
        return this.jdyRequestConsumer;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Generated
    public void setClientEngine(ClientEngine clientEngine) {
        this.clientEngine = clientEngine;
    }

    @Generated
    public void setRetryPolicy(List<RetryPolicy> retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @Generated
    public void setJdyRequestConsumer(@Nullable Consumer<JdyRequestEvent> jdyRequestConsumer) {
        this.jdyRequestConsumer = jdyRequestConsumer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdyClientConfig)) {
            return false;
        }
        JdyClientConfig other = (JdyClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        ClientEngine this$clientEngine = this.getClientEngine();
        ClientEngine other$clientEngine = other.getClientEngine();
        if (this$clientEngine == null ? other$clientEngine != null : !this$clientEngine.equals(other$clientEngine)) {
            return false;
        }
        List<RetryPolicy> this$retryPolicy = this.getRetryPolicy();
        List<RetryPolicy> other$retryPolicy = other.getRetryPolicy();
        if (this$retryPolicy == null ? other$retryPolicy != null : !((Object)this$retryPolicy).equals(other$retryPolicy)) {
            return false;
        }
        Consumer<JdyRequestEvent> this$jdyRequestConsumer = this.getJdyRequestConsumer();
        Consumer<JdyRequestEvent> other$jdyRequestConsumer = other.getJdyRequestConsumer();
        return !(this$jdyRequestConsumer == null ? other$jdyRequestConsumer != null : !this$jdyRequestConsumer.equals(other$jdyRequestConsumer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JdyClientConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        ClientEngine $clientEngine = this.getClientEngine();
        result = result * 59 + ($clientEngine == null ? 43 : $clientEngine.hashCode());
        List<RetryPolicy> $retryPolicy = this.getRetryPolicy();
        result = result * 59 + ($retryPolicy == null ? 43 : ((Object)$retryPolicy).hashCode());
        Consumer<JdyRequestEvent> $jdyRequestConsumer = this.getJdyRequestConsumer();
        result = result * 59 + ($jdyRequestConsumer == null ? 43 : $jdyRequestConsumer.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JdyClientConfig(url=" + this.getUrl() + ", apiKey=" + this.getApiKey() + ", clientEngine=" + String.valueOf(this.getClientEngine()) + ", retryPolicy=" + String.valueOf(this.getRetryPolicy()) + ", jdyRequestConsumer=" + String.valueOf(this.getJdyRequestConsumer()) + ")";
    }
}

