/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.okjdy.core.model;

import cn.toint.okjdy.core.model.JdyDo;
import cn.toint.oktool.util.Assert;
import cn.toint.oktool.util.JacksonUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class JdyDataDeleteBatchRequest {
    @JsonProperty(value="app_id")
    @NotBlank
    private String appId;
    @JsonProperty(value="entry_id")
    @NotBlank
    private String entryId;
    @JsonProperty(value="data_ids")
    @NotEmpty
    private Collection<String> dataIds;

    public JdyDataDeleteBatchRequest() {
    }

    public JdyDataDeleteBatchRequest(String appId, String entryId, Collection<String> dataIds) {
        Assert.notBlank((CharSequence)appId, (CharSequence)"appId must not be blank", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)entryId, (CharSequence)"entryId must not be blank", (Object[])new Object[0]);
        Assert.notEmpty(dataIds, (CharSequence)"dataIds must not be empty", (Object[])new Object[0]);
        this.appId = appId;
        this.entryId = entryId;
        this.dataIds = dataIds;
    }

    public static JdyDataDeleteBatchRequest of(JsonNode data) {
        Assert.notNull((Object)data, (CharSequence)"data must not be null", (Object[])new Object[0]);
        Assert.isTrue((boolean)data.isArray(), (CharSequence)"data must not be array", (Object[])new Object[0]);
        List jdyDos = (List)JacksonUtil.treeToValue((TreeNode)data, (TypeReference)new TypeReference<List<JdyDo>>(){});
        return JdyDataDeleteBatchRequest.of(jdyDos);
    }

    public static <T extends JdyDo> JdyDataDeleteBatchRequest of(List<T> data) {
        Assert.notEmpty(data, (CharSequence)"data must not be empty", (Object[])new Object[0]);
        Set<String> dataIds = data.stream().map(JdyDo::getDataId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        return new JdyDataDeleteBatchRequest(((JdyDo)data.getFirst()).getAppId(), ((JdyDo)data.getFirst()).getEntryId(), dataIds);
    }

    @Generated
    public String getAppId() {
        return this.appId;
    }

    @Generated
    public String getEntryId() {
        return this.entryId;
    }

    @Generated
    public Collection<String> getDataIds() {
        return this.dataIds;
    }

    @JsonProperty(value="app_id")
    @Generated
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @JsonProperty(value="entry_id")
    @Generated
    public void setEntryId(String entryId) {
        this.entryId = entryId;
    }

    @JsonProperty(value="data_ids")
    @Generated
    public void setDataIds(Collection<String> dataIds) {
        this.dataIds = dataIds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdyDataDeleteBatchRequest)) {
            return false;
        }
        JdyDataDeleteBatchRequest other = (JdyDataDeleteBatchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$entryId = this.getEntryId();
        String other$entryId = other.getEntryId();
        if (this$entryId == null ? other$entryId != null : !this$entryId.equals(other$entryId)) {
            return false;
        }
        Collection<String> this$dataIds = this.getDataIds();
        Collection<String> other$dataIds = other.getDataIds();
        return !(this$dataIds == null ? other$dataIds != null : !((Object)this$dataIds).equals(other$dataIds));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JdyDataDeleteBatchRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $entryId = this.getEntryId();
        result = result * 59 + ($entryId == null ? 43 : $entryId.hashCode());
        Collection<String> $dataIds = this.getDataIds();
        result = result * 59 + ($dataIds == null ? 43 : ((Object)$dataIds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JdyDataDeleteBatchRequest(appId=" + this.getAppId() + ", entryId=" + this.getEntryId() + ", dataIds=" + String.valueOf(this.getDataIds()) + ")";
    }
}

