/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.okjdy.core.model;

import cn.toint.okjdy.core.model.JdyDo;
import cn.toint.oktool.util.Assert;
import cn.toint.oktool.util.JacksonUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import lombok.Generated;
import org.dromara.hutool.core.data.id.IdUtil;

public class JdyDataSaveBatchRequest {
    @JsonProperty(value="app_id")
    @NotBlank
    private String appId;
    @JsonProperty(value="entry_id")
    @NotBlank
    private String entryId;
    @JsonProperty(value="data_list")
    @NotNull
    private JsonNode datas;
    @JsonProperty(value="data_creator")
    private String dataCreator;
    @JsonProperty(value="is_start_workflow")
    private boolean startWorkflow = true;
    @JsonProperty(value="transaction_id")
    private String transactionId = IdUtil.fastSimpleUUID();

    public JdyDataSaveBatchRequest() {
    }

    public JdyDataSaveBatchRequest(@Nonnull String appId, @Nonnull String entryId, @Nonnull JsonNode datas) {
        Assert.notBlank((CharSequence)appId, (CharSequence)"appId must not be blank", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)entryId, (CharSequence)"entryId must not be blank", (Object[])new Object[0]);
        Assert.notNull((Object)datas, (CharSequence)"datas must not be null", (Object[])new Object[0]);
        this.appId = appId;
        this.entryId = entryId;
        this.datas = datas;
    }

    public static JdyDataSaveBatchRequest of(@Nonnull JsonNode datas) {
        Assert.notEmpty((Iterable)datas, (CharSequence)"datas must not be empty", (Object[])new Object[0]);
        JdyDo jdyDo = (JdyDo)JacksonUtil.treeToValue((TreeNode)datas.get(0), JdyDo.class);
        return new JdyDataSaveBatchRequest(jdyDo.getAppId(), jdyDo.getEntryId(), datas);
    }

    public static <T extends JdyDo> JdyDataSaveBatchRequest of(Collection<T> datas) {
        Assert.notEmpty(datas, (CharSequence)"datas must not be empty", (Object[])new Object[0]);
        return JdyDataSaveBatchRequest.of(JacksonUtil.valueToTree(datas));
    }

    public JdyDataSaveBatchRequest transactionId(String transactionId) {
        Assert.notBlank((CharSequence)transactionId, (CharSequence)"transactionId must not be blank", (Object[])new Object[0]);
        this.transactionId = transactionId;
        return this;
    }

    @Generated
    public String getAppId() {
        return this.appId;
    }

    @Generated
    public String getEntryId() {
        return this.entryId;
    }

    @Generated
    public JsonNode getDatas() {
        return this.datas;
    }

    @Generated
    public String getDataCreator() {
        return this.dataCreator;
    }

    @Generated
    public boolean isStartWorkflow() {
        return this.startWorkflow;
    }

    @Generated
    public String getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty(value="app_id")
    @Generated
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @JsonProperty(value="entry_id")
    @Generated
    public void setEntryId(String entryId) {
        this.entryId = entryId;
    }

    @JsonProperty(value="data_list")
    @Generated
    public void setDatas(JsonNode datas) {
        this.datas = datas;
    }

    @JsonProperty(value="data_creator")
    @Generated
    public void setDataCreator(String dataCreator) {
        this.dataCreator = dataCreator;
    }

    @JsonProperty(value="is_start_workflow")
    @Generated
    public void setStartWorkflow(boolean startWorkflow) {
        this.startWorkflow = startWorkflow;
    }

    @JsonProperty(value="transaction_id")
    @Generated
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdyDataSaveBatchRequest)) {
            return false;
        }
        JdyDataSaveBatchRequest other = (JdyDataSaveBatchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStartWorkflow() != other.isStartWorkflow()) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$entryId = this.getEntryId();
        String other$entryId = other.getEntryId();
        if (this$entryId == null ? other$entryId != null : !this$entryId.equals(other$entryId)) {
            return false;
        }
        JsonNode this$datas = this.getDatas();
        JsonNode other$datas = other.getDatas();
        if (this$datas == null ? other$datas != null : !this$datas.equals(other$datas)) {
            return false;
        }
        String this$dataCreator = this.getDataCreator();
        String other$dataCreator = other.getDataCreator();
        if (this$dataCreator == null ? other$dataCreator != null : !this$dataCreator.equals(other$dataCreator)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        return !(this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JdyDataSaveBatchRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStartWorkflow() ? 79 : 97);
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $entryId = this.getEntryId();
        result = result * 59 + ($entryId == null ? 43 : $entryId.hashCode());
        JsonNode $datas = this.getDatas();
        result = result * 59 + ($datas == null ? 43 : $datas.hashCode());
        String $dataCreator = this.getDataCreator();
        result = result * 59 + ($dataCreator == null ? 43 : $dataCreator.hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JdyDataSaveBatchRequest(appId=" + this.getAppId() + ", entryId=" + this.getEntryId() + ", datas=" + String.valueOf(this.getDatas()) + ", dataCreator=" + this.getDataCreator() + ", startWorkflow=" + this.isStartWorkflow() + ", transactionId=" + this.getTransactionId() + ")";
    }
}

