/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.okjdy.core.model;

import cn.toint.okjdy.core.model.JdyDo;
import cn.toint.oktool.util.Assert;
import cn.toint.oktool.util.JacksonUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import lombok.Generated;

public class JdyDataUpdateBatchRequest {
    @JsonProperty(value="app_id")
    @NotBlank
    private String appId;
    @JsonProperty(value="entry_id")
    @NotBlank
    private String entryId;
    @JsonProperty(value="data_ids")
    @NotNull
    private Collection<String> dataIds;
    @JsonProperty(value="data")
    @NotNull
    private JsonNode data;
    @JsonProperty(value="transaction_id")
    private String transactionId;

    public JdyDataUpdateBatchRequest() {
    }

    public JdyDataUpdateBatchRequest(String appId, String entryId, Collection<String> dataIds, JsonNode data) {
        Assert.notBlank((CharSequence)appId, (CharSequence)"appId can not be blank", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)entryId, (CharSequence)"entryId can not be blank", (Object[])new Object[0]);
        Assert.notEmpty(dataIds, (CharSequence)"dataIds can not be null", (Object[])new Object[0]);
        Assert.notNull((Object)data, (CharSequence)"data can not be null", (Object[])new Object[0]);
        this.appId = appId;
        this.entryId = entryId;
        this.dataIds = dataIds;
        this.data = data;
    }

    public static JdyDataUpdateBatchRequest of(JsonNode data, Collection<String> dataIds) {
        Assert.notNull((Object)data, (CharSequence)"data can not be null", (Object[])new Object[0]);
        Assert.notEmpty(dataIds, (CharSequence)"dataIds can not be null", (Object[])new Object[0]);
        JdyDo jdyDo = (JdyDo)JacksonUtil.treeToValue((TreeNode)data, JdyDo.class);
        return new JdyDataUpdateBatchRequest(jdyDo.getAppId(), jdyDo.getEntryId(), dataIds, data);
    }

    public static <T extends JdyDo> JdyDataUpdateBatchRequest of(T data, Collection<String> dataIds) {
        Assert.notNull(data, (CharSequence)"data can not be null", (Object[])new Object[0]);
        Assert.notEmpty(dataIds, (CharSequence)"dataIds can not be null", (Object[])new Object[0]);
        return new JdyDataUpdateBatchRequest(data.getAppId(), data.getEntryId(), dataIds, JacksonUtil.valueToTree(data));
    }

    public JdyDataUpdateBatchRequest transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Generated
    public String getAppId() {
        return this.appId;
    }

    @Generated
    public String getEntryId() {
        return this.entryId;
    }

    @Generated
    public Collection<String> getDataIds() {
        return this.dataIds;
    }

    @Generated
    public JsonNode getData() {
        return this.data;
    }

    @Generated
    public String getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty(value="app_id")
    @Generated
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @JsonProperty(value="entry_id")
    @Generated
    public void setEntryId(String entryId) {
        this.entryId = entryId;
    }

    @JsonProperty(value="data_ids")
    @Generated
    public void setDataIds(Collection<String> dataIds) {
        this.dataIds = dataIds;
    }

    @JsonProperty(value="data")
    @Generated
    public void setData(JsonNode data) {
        this.data = data;
    }

    @JsonProperty(value="transaction_id")
    @Generated
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdyDataUpdateBatchRequest)) {
            return false;
        }
        JdyDataUpdateBatchRequest other = (JdyDataUpdateBatchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$entryId = this.getEntryId();
        String other$entryId = other.getEntryId();
        if (this$entryId == null ? other$entryId != null : !this$entryId.equals(other$entryId)) {
            return false;
        }
        Collection<String> this$dataIds = this.getDataIds();
        Collection<String> other$dataIds = other.getDataIds();
        if (this$dataIds == null ? other$dataIds != null : !((Object)this$dataIds).equals(other$dataIds)) {
            return false;
        }
        JsonNode this$data = this.getData();
        JsonNode other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        return !(this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JdyDataUpdateBatchRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $entryId = this.getEntryId();
        result = result * 59 + ($entryId == null ? 43 : $entryId.hashCode());
        Collection<String> $dataIds = this.getDataIds();
        result = result * 59 + ($dataIds == null ? 43 : ((Object)$dataIds).hashCode());
        JsonNode $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JdyDataUpdateBatchRequest(appId=" + this.getAppId() + ", entryId=" + this.getEntryId() + ", dataIds=" + String.valueOf(this.getDataIds()) + ", data=" + String.valueOf(this.getData()) + ", transactionId=" + this.getTransactionId() + ")";
    }
}

