/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.okjdy.core.model;

import cn.toint.okjdy.core.model.JdyDo;
import cn.toint.oktool.util.Assert;
import cn.toint.oktool.util.JacksonUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;

public class JdyDataUpdateRequest {
    @JsonProperty(value="app_id")
    @NotBlank
    private String appId;
    @JsonProperty(value="entry_id")
    @NotBlank
    private String entryId;
    @JsonProperty(value="data_id")
    @NotBlank
    private String dataId;
    @JsonProperty(value="data")
    @NotNull
    private JsonNode data;
    @JsonProperty(value="is_start_trigger")
    private boolean startTrigger = true;
    @JsonProperty(value="transaction_id")
    private String transactionId;

    public JdyDataUpdateRequest() {
    }

    public JdyDataUpdateRequest(@Nonnull String appId, @Nonnull String entryId, @Nonnull String dataId, @Nonnull JsonNode data) {
        Assert.notBlank((CharSequence)appId, (CharSequence)"appId must not be blank", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)entryId, (CharSequence)"entryId must not be blank", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)dataId, (CharSequence)"dataId must not be blank", (Object[])new Object[0]);
        Assert.notNull((Object)data, (CharSequence)"data must not be null", (Object[])new Object[0]);
        this.appId = appId;
        this.entryId = entryId;
        this.dataId = dataId;
        this.data = data;
    }

    public static JdyDataUpdateRequest of(@Nonnull JsonNode data) {
        Assert.notNull((Object)data, (CharSequence)"data must not be null", (Object[])new Object[0]);
        JdyDo jdyDo = (JdyDo)JacksonUtil.treeToValue((TreeNode)data, JdyDo.class);
        return new JdyDataUpdateRequest(jdyDo.getAppId(), jdyDo.getEntryId(), jdyDo.getDataId(), data);
    }

    public static <T extends JdyDo> JdyDataUpdateRequest of(@Nonnull T data) {
        Assert.notNull(data, (CharSequence)"data must not be null", (Object[])new Object[0]);
        return new JdyDataUpdateRequest(data.getAppId(), data.getEntryId(), data.getDataId(), JacksonUtil.valueToTree(data));
    }

    public JdyDataUpdateRequest transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Generated
    public String getAppId() {
        return this.appId;
    }

    @Generated
    public String getEntryId() {
        return this.entryId;
    }

    @Generated
    public String getDataId() {
        return this.dataId;
    }

    @Generated
    public JsonNode getData() {
        return this.data;
    }

    @Generated
    public boolean isStartTrigger() {
        return this.startTrigger;
    }

    @Generated
    public String getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty(value="app_id")
    @Generated
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @JsonProperty(value="entry_id")
    @Generated
    public void setEntryId(String entryId) {
        this.entryId = entryId;
    }

    @JsonProperty(value="data_id")
    @Generated
    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    @JsonProperty(value="data")
    @Generated
    public void setData(JsonNode data) {
        this.data = data;
    }

    @JsonProperty(value="is_start_trigger")
    @Generated
    public void setStartTrigger(boolean startTrigger) {
        this.startTrigger = startTrigger;
    }

    @JsonProperty(value="transaction_id")
    @Generated
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdyDataUpdateRequest)) {
            return false;
        }
        JdyDataUpdateRequest other = (JdyDataUpdateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStartTrigger() != other.isStartTrigger()) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$entryId = this.getEntryId();
        String other$entryId = other.getEntryId();
        if (this$entryId == null ? other$entryId != null : !this$entryId.equals(other$entryId)) {
            return false;
        }
        String this$dataId = this.getDataId();
        String other$dataId = other.getDataId();
        if (this$dataId == null ? other$dataId != null : !this$dataId.equals(other$dataId)) {
            return false;
        }
        JsonNode this$data = this.getData();
        JsonNode other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        return !(this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JdyDataUpdateRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStartTrigger() ? 79 : 97);
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $entryId = this.getEntryId();
        result = result * 59 + ($entryId == null ? 43 : $entryId.hashCode());
        String $dataId = this.getDataId();
        result = result * 59 + ($dataId == null ? 43 : $dataId.hashCode());
        JsonNode $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JdyDataUpdateRequest(appId=" + this.getAppId() + ", entryId=" + this.getEntryId() + ", dataId=" + this.getDataId() + ", data=" + String.valueOf(this.getData()) + ", startTrigger=" + this.isStartTrigger() + ", transactionId=" + this.getTransactionId() + ")";
    }
}

