/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.okjdy.core.model;

import cn.toint.okjdy.core.model.JdyCondition;
import cn.toint.okjdy.core.model.JdyDo;
import cn.toint.okjdy.core.model.JdyFilter;
import cn.toint.okjdy.core.model.JdyMethodEnum;
import cn.toint.okjdy.core.model.JdyRelationshipEnum;
import cn.toint.oktool.util.Assert;
import cn.toint.oktool.util.JacksonUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.func.SerFunction;
import org.dromara.hutool.core.reflect.ConstructorUtil;

public class JdyListDataRequest {
    @JsonProperty(value="app_id")
    @NotBlank
    private String appId;
    @JsonProperty(value="entry_id")
    @NotBlank
    private String entryId;
    @JsonProperty(value="data_id")
    private String dataId;
    @JsonProperty(value="fields")
    private Collection<String> fields;
    @JsonProperty(value="filter")
    @Valid
    @NotNull
    private JdyFilter filter = new JdyFilter();
    @JsonProperty(value="limit")
    private int limit = Integer.MAX_VALUE;

    @Nonnull
    public static JdyListDataRequest of() {
        return new JdyListDataRequest();
    }

    @Nonnull
    public JdyListDataRequest select(String ... fields) {
        if (this.fields == null) {
            this.fields = new HashSet<String>();
        }
        if (ArrayUtil.isNotEmpty((Object[])fields)) {
            this.fields.addAll(Arrays.stream(fields).filter(StringUtils::isNotBlank).collect(Collectors.toSet()));
        }
        return this;
    }

    @Nonnull
    public JdyListDataRequest from(@Nonnull JdyDo jdyTable) {
        this.from(jdyTable.getAppId(), jdyTable.getEntryId());
        return this;
    }

    @Nonnull
    public JdyListDataRequest from(@Nonnull Class<? extends JdyDo> clazz) {
        JdyDo jdyTable = (JdyDo)ConstructorUtil.newInstance(clazz, (Object[])new Object[0]);
        this.from(jdyTable);
        return this;
    }

    @Nonnull
    public JdyListDataRequest from(@Nonnull String appId, @Nonnull String entryId) {
        Assert.notBlank((CharSequence)appId, (CharSequence)"appId must not be blank", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)entryId, (CharSequence)"entryId must not be blank", (Object[])new Object[0]);
        this.appId = appId;
        this.entryId = entryId;
        return this;
    }

    @Nonnull
    public JdyListDataRequest notEmpty(@Nonnull String fieldName) {
        Assert.notBlank((CharSequence)fieldName, (CharSequence)"fieldName must not be blank", (Object[])new Object[0]);
        JdyCondition condition = new JdyCondition();
        condition.setField(fieldName);
        condition.setMethod(JdyMethodEnum.NOT_EMPTY.getValue());
        this.addCondition(condition);
        return this;
    }

    @Nonnull
    public <T, R> JdyListDataRequest notEmpty(@Nonnull SerFunction<T, R> func) {
        return this.notEmpty(JacksonUtil.getAlias(func));
    }

    @Nonnull
    public JdyListDataRequest empty(@Nonnull String fieldName) {
        Assert.notBlank((CharSequence)fieldName, (CharSequence)"fieldName must not be blank", (Object[])new Object[0]);
        JdyCondition condition = new JdyCondition();
        condition.setField(fieldName);
        condition.setMethod(JdyMethodEnum.EMPTY.getValue());
        this.addCondition(condition);
        return this;
    }

    @Nonnull
    public <T, R> JdyListDataRequest empty(@Nonnull SerFunction<T, R> func) {
        return this.empty(JacksonUtil.getAlias(func));
    }

    @Nonnull
    public JdyListDataRequest eq(@Nonnull String fieldName, @Nullable Object value) {
        Assert.notBlank((CharSequence)fieldName, (CharSequence)"fieldName must not be blank", (Object[])new Object[0]);
        if (value != null) {
            JdyCondition condition = new JdyCondition();
            condition.setField(fieldName);
            condition.setMethod(JdyMethodEnum.EQ.getValue());
            condition.setValue(List.of(value));
            this.addCondition(condition);
        }
        return this;
    }

    @Nonnull
    public <T, R> JdyListDataRequest eq(@Nonnull SerFunction<T, R> func, @Nullable Object value) {
        return this.eq(JacksonUtil.getAlias(func), value);
    }

    @Nonnull
    public JdyListDataRequest in(@Nonnull String fieldName, @Nullable Collection<?> values) {
        Assert.notBlank((CharSequence)fieldName, (CharSequence)"fieldName must not be blank", (Object[])new Object[0]);
        if (CollUtil.isNotEmpty(values)) {
            Set<Object> set = values.stream().filter(Objects::nonNull).collect(Collectors.toSet());
            Assert.isTrue((set.size() <= 200 ? 1 : 0) != 0, (CharSequence)"\u6761\u4ef6\u53c2\u6570\u6700\u591a\u53ef\u4f20\u9012200\u4e2a", (Object[])new Object[0]);
            JdyCondition condition = new JdyCondition();
            condition.setField(fieldName);
            condition.setMethod(JdyMethodEnum.IN.getValue());
            condition.setValue(set);
            this.addCondition(condition);
        }
        return this;
    }

    @Nonnull
    public <T, R> JdyListDataRequest in(@Nonnull SerFunction<T, R> func, @Nullable Collection<?> value) {
        return this.in(JacksonUtil.getAlias(func), value);
    }

    @Nonnull
    public JdyListDataRequest range(@Nonnull String fieldName, @Nullable Object x, @Nullable Object y) {
        Assert.notBlank((CharSequence)fieldName, (CharSequence)"fieldName must not be blank", (Object[])new Object[0]);
        if (x != null || y != null) {
            JdyCondition condition = new JdyCondition();
            condition.setField(fieldName);
            condition.setMethod(JdyMethodEnum.RANGE.getValue());
            condition.setValue(Arrays.asList(x, y));
            this.addCondition(condition);
        }
        return this;
    }

    @Nonnull
    public <T, R> JdyListDataRequest range(@Nonnull SerFunction<T, R> func, @Nullable Object x, @Nullable Object y) {
        return this.range(JacksonUtil.getAlias(func), x, y);
    }

    @Nonnull
    public JdyListDataRequest ge(@Nonnull String fieldName, @Nullable Object value) {
        Assert.notBlank((CharSequence)fieldName, (CharSequence)"fieldName must not be blank", (Object[])new Object[0]);
        if (value != null) {
            this.range(fieldName, value, null);
        }
        return this;
    }

    @Nonnull
    public <T, R> JdyListDataRequest ge(@Nonnull SerFunction<T, R> func, @Nullable Object value) {
        if (value != null) {
            this.range(func, value, null);
        }
        return this;
    }

    @Nonnull
    public JdyListDataRequest le(@Nonnull String fieldName, @Nullable Object value) {
        Assert.notBlank((CharSequence)fieldName, (CharSequence)"fieldName must not be blank", (Object[])new Object[0]);
        if (value != null) {
            this.range(fieldName, null, value);
        }
        return this;
    }

    @Nonnull
    public <T, R> JdyListDataRequest le(@Nonnull SerFunction<T, R> func, @Nullable Object value) {
        if (value != null) {
            return this.range(func, null, value);
        }
        return this;
    }

    @Nonnull
    public JdyListDataRequest notIn(@Nonnull String fieldName, @Nullable Collection<?> value) {
        Assert.notBlank((CharSequence)fieldName, (CharSequence)"fieldName must not be blank", (Object[])new Object[0]);
        if (CollUtil.isNotEmpty(value)) {
            Set<Object> set = value.stream().filter(Objects::nonNull).collect(Collectors.toSet());
            Assert.isTrue((set.size() <= 200 ? 1 : 0) != 0, (CharSequence)"\u6761\u4ef6\u53c2\u6570\u6700\u591a\u53ef\u4f20\u9012200\u4e2a", (Object[])new Object[0]);
            JdyCondition condition = new JdyCondition();
            condition.setField(fieldName);
            condition.setMethod(JdyMethodEnum.NIN.getValue());
            condition.setValue(set);
            this.addCondition(condition);
        }
        return this;
    }

    @Nonnull
    public <T, R> JdyListDataRequest notIn(@Nonnull SerFunction<T, R> func, @Nullable Collection<?> value) {
        return this.notIn(JacksonUtil.getAlias(func), value);
    }

    @Nonnull
    public JdyListDataRequest ne(@Nonnull String fieldName, @Nullable Object value) {
        Assert.notBlank((CharSequence)fieldName, (CharSequence)"fieldName must not be blank", (Object[])new Object[0]);
        if (value != null) {
            JdyCondition condition = new JdyCondition();
            condition.setField(fieldName);
            condition.setMethod(JdyMethodEnum.NE.getValue());
            condition.setValue(List.of(value));
            this.addCondition(condition);
        }
        return this;
    }

    @Nonnull
    public <T, R> JdyListDataRequest ne(@Nonnull SerFunction<T, R> func, @Nullable Object value) {
        return this.ne(JacksonUtil.getAlias(func), value);
    }

    @Nonnull
    public JdyListDataRequest like(@Nonnull String fieldName, @Nullable Object value) {
        Assert.notBlank((CharSequence)fieldName, (CharSequence)"fieldName must not be blank", (Object[])new Object[0]);
        if (value != null) {
            JdyCondition condition = new JdyCondition();
            condition.setField(fieldName);
            condition.setMethod(JdyMethodEnum.LIKE.getValue());
            condition.setValue(List.of(value));
            this.addCondition(condition);
        }
        return this;
    }

    @Nonnull
    public <T, R> JdyListDataRequest like(@Nonnull SerFunction<T, R> func, @Nullable Object value) {
        return this.like(JacksonUtil.getAlias(func), value);
    }

    @Nonnull
    public JdyListDataRequest verified(@Nonnull String fieldName) {
        Assert.notBlank((CharSequence)fieldName, (CharSequence)"fieldName must not be blank", (Object[])new Object[0]);
        JdyCondition condition = new JdyCondition();
        condition.setField(fieldName);
        condition.setMethod(JdyMethodEnum.VERIFIED.getValue());
        this.addCondition(condition);
        return this;
    }

    @Nonnull
    public <T, R> JdyListDataRequest verified(@Nonnull SerFunction<T, R> func) {
        return this.verified(JacksonUtil.getAlias(func));
    }

    @Nonnull
    public JdyListDataRequest unverified(@Nonnull String fieldName) {
        Assert.notBlank((CharSequence)fieldName, (CharSequence)"fieldName must not be blank", (Object[])new Object[0]);
        JdyCondition condition = new JdyCondition();
        condition.setField(fieldName);
        condition.setMethod(JdyMethodEnum.UNVERIFIED.getValue());
        this.addCondition(condition);
        return this;
    }

    @Nonnull
    public <T, R> JdyListDataRequest unverified(@Nonnull SerFunction<T, R> func) {
        return this.unverified(JacksonUtil.getAlias(func));
    }

    @Nonnull
    public JdyListDataRequest and() {
        this.filter.setRelationship(JdyRelationshipEnum.AND.getValue());
        return this;
    }

    @Nonnull
    public JdyListDataRequest or() {
        this.filter.setRelationship(JdyRelationshipEnum.OR.getValue());
        return this;
    }

    @Nonnull
    public JdyListDataRequest limit(int limit) {
        this.limit = limit;
        return this;
    }

    private void addCondition(JdyCondition jdyCondition) {
        this.filter.getCondition().add(jdyCondition);
    }

    @Generated
    public String getAppId() {
        return this.appId;
    }

    @Generated
    public String getEntryId() {
        return this.entryId;
    }

    @Generated
    public String getDataId() {
        return this.dataId;
    }

    @Generated
    public Collection<String> getFields() {
        return this.fields;
    }

    @Generated
    public JdyFilter getFilter() {
        return this.filter;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @JsonProperty(value="app_id")
    @Generated
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @JsonProperty(value="entry_id")
    @Generated
    public void setEntryId(String entryId) {
        this.entryId = entryId;
    }

    @JsonProperty(value="data_id")
    @Generated
    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    @JsonProperty(value="fields")
    @Generated
    public void setFields(Collection<String> fields) {
        this.fields = fields;
    }

    @JsonProperty(value="filter")
    @Generated
    public void setFilter(JdyFilter filter) {
        this.filter = filter;
    }

    @JsonProperty(value="limit")
    @Generated
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdyListDataRequest)) {
            return false;
        }
        JdyListDataRequest other = (JdyListDataRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$entryId = this.getEntryId();
        String other$entryId = other.getEntryId();
        if (this$entryId == null ? other$entryId != null : !this$entryId.equals(other$entryId)) {
            return false;
        }
        String this$dataId = this.getDataId();
        String other$dataId = other.getDataId();
        if (this$dataId == null ? other$dataId != null : !this$dataId.equals(other$dataId)) {
            return false;
        }
        Collection<String> this$fields = this.getFields();
        Collection<String> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        JdyFilter this$filter = this.getFilter();
        JdyFilter other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JdyListDataRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLimit();
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $entryId = this.getEntryId();
        result = result * 59 + ($entryId == null ? 43 : $entryId.hashCode());
        String $dataId = this.getDataId();
        result = result * 59 + ($dataId == null ? 43 : $dataId.hashCode());
        Collection<String> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        JdyFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JdyListDataRequest(appId=" + this.getAppId() + ", entryId=" + this.getEntryId() + ", dataId=" + this.getDataId() + ", fields=" + String.valueOf(this.getFields()) + ", filter=" + String.valueOf(this.getFilter()) + ", limit=" + this.getLimit() + ")";
    }
}

