/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.okjdy.core.util;

import cn.toint.okjdy.core.enums.JdyFieldTypeEnum;
import cn.toint.okjdy.core.model.JdyAddress;
import cn.toint.okjdy.core.model.JdyDept;
import cn.toint.okjdy.core.model.JdyDeptGroup;
import cn.toint.okjdy.core.model.JdyField;
import cn.toint.okjdy.core.model.JdyFile;
import cn.toint.okjdy.core.model.JdyLocation;
import cn.toint.okjdy.core.model.JdyPhone;
import cn.toint.okjdy.core.model.JdyUser;
import cn.toint.okjdy.core.model.JdyUserGroup;
import cn.toint.oktool.util.JacksonUtil;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.lang.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdyDataRequestConvertUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdyDataRequestConvertUtil.class);
    private static final Map<String, Converter> CONVERTER_MAP = JdyDataRequestConvertUtil.init();
    private static final String VALUE = "value";

    private static Map<String, Converter> init() {
        HashMap<String, Converter> converterMap = new HashMap<String, Converter>();
        converterMap.put(JdyFieldTypeEnum.TEXT.getValue(), new TextConverter());
        converterMap.put(JdyFieldTypeEnum.TEXT_AREA.getValue(), new TextareaConverter());
        converterMap.put(JdyFieldTypeEnum.NUMBER.getValue(), new NumberConverter());
        converterMap.put(JdyFieldTypeEnum.RADIO_GROUP.getValue(), new RadioGroupConverter());
        converterMap.put(JdyFieldTypeEnum.DATE_TIME.getValue(), new DateTimeConverter());
        converterMap.put(JdyFieldTypeEnum.CHECK_BOX_GROUP.getValue(), new CheckBoxGroupConverter());
        converterMap.put(JdyFieldTypeEnum.COMBO.getValue(), new ComboConverter());
        converterMap.put(JdyFieldTypeEnum.COMBO_CHECK.getValue(), new ComboCheckConverter());
        converterMap.put(JdyFieldTypeEnum.ADDRESS.getValue(), new AddressConverter());
        converterMap.put(JdyFieldTypeEnum.LOCATION.getValue(), new LocationConverter());
        converterMap.put(JdyFieldTypeEnum.IMAGE.getValue(), new ImageConverter());
        converterMap.put(JdyFieldTypeEnum.UPLOAD.getValue(), new UploadConverter());
        converterMap.put(JdyFieldTypeEnum.SUBFORM.getValue(), new SubFormConverter());
        converterMap.put(JdyFieldTypeEnum.USER.getValue(), new UserConverter());
        converterMap.put(JdyFieldTypeEnum.USERG_ROUP.getValue(), new UserGroupConverter());
        converterMap.put(JdyFieldTypeEnum.DEPT.getValue(), new DeptConverter());
        converterMap.put(JdyFieldTypeEnum.DEPT_GROUP.getValue(), new DeptGroupConverter());
        converterMap.put(JdyFieldTypeEnum.PHONE.getValue(), new PhoneConverter());
        return converterMap;
    }

    @Nonnull
    public static JsonNode convert(@Nonnull JsonNode data, @Nonnull List<JdyField> jdyFields) {
        Assert.notNull((Object)data, (String)"data must not be null", (Object[])new Object[0]);
        if (CollUtil.isEmpty(jdyFields)) {
            return JacksonUtil.ofObjectNode();
        }
        HashMap<String, JdyField> fieldNameTypeMap = new HashMap<String, JdyField>();
        jdyFields.forEach(jdyField -> fieldNameTypeMap.put(jdyField.getName(), (JdyField)jdyField));
        ObjectNode newData = JacksonUtil.ofObjectNode();
        fieldNameTypeMap.forEach((fieldName, field) -> {
            if (!data.has(fieldName)) {
                return;
            }
            JsonNode oldValue = data.get(fieldName);
            if (JacksonUtil.isNull((JsonNode)oldValue)) {
                newData.set(fieldName, JdyDataRequestConvertUtil.ofNewValue(null));
                return;
            }
            Converter converter = JdyDataRequestConvertUtil.getConverter(field);
            if (converter == null) {
                return;
            }
            try {
                JsonNode newValue = converter.executeConvert(oldValue, (JdyField)field);
                if (newValue == null) {
                    return;
                }
                newData.set(fieldName, newValue);
            }
            catch (Exception e) {
                log.error("\u5b57\u6bb5[{}]\u8f6c\u6362\u5931\u8d25: {}", fieldName, (Object)e.getMessage());
                throw new RuntimeException("\u5b57\u6bb5[" + fieldName + "]\u8f6c\u6362\u5931\u8d25: " + e.getMessage(), e);
            }
        });
        return newData;
    }

    private static JsonNode ofNewValue(@Nullable Object value) {
        return JacksonUtil.ofObjectNode().set(VALUE, JacksonUtil.valueToTree((Object)value));
    }

    private static Converter getConverter(JdyField jdyField) {
        return CONVERTER_MAP.get(jdyField.getType());
    }

    private static class TextConverter
    extends StringConverter {
        private TextConverter() {
        }
    }

    private static class TextareaConverter
    extends StringConverter {
        private TextareaConverter() {
        }
    }

    private static class NumberConverter
    implements Converter {
        private NumberConverter() {
        }

        @Override
        @Nullable
        public JsonNode executeConvert(@Nonnull JsonNode value, @Nonnull JdyField jdyField) {
            if (StringUtils.isBlank((CharSequence)value.asText())) {
                return JdyDataRequestConvertUtil.ofNewValue(null);
            }
            try {
                return JdyDataRequestConvertUtil.ofNewValue(new BigDecimal(value.asText()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("\u65e0\u6548\u7684\u6570\u5b57\u683c\u5f0f: " + value.asText(), e);
            }
        }
    }

    private static class RadioGroupConverter
    extends StringConverter {
        private RadioGroupConverter() {
        }
    }

    private static class DateTimeConverter
    implements Converter {
        private DateTimeConverter() {
        }

        @Override
        @Nullable
        public JsonNode executeConvert(@Nonnull JsonNode value, @Nonnull JdyField jdyField) {
            try {
                if (value.isTextual()) {
                    Instant instant = Instant.parse(value.asText());
                    return JdyDataRequestConvertUtil.ofNewValue(instant.toString());
                }
                if (value.isNumber()) {
                    long time = value.asLong();
                    int length = String.valueOf(time).length();
                    if (length == 10) {
                        return JdyDataRequestConvertUtil.ofNewValue(Instant.ofEpochSecond(time).toString());
                    }
                    if (length == 13) {
                        return JdyDataRequestConvertUtil.ofNewValue(Instant.ofEpochMilli(time).toString());
                    }
                }
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u65f6\u95f4\u683c\u5f0f: " + String.valueOf(value));
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("\u65e0\u6548\u7684\u65e5\u671f\u65f6\u95f4\u683c\u5f0f: " + value.asText(), e);
            }
        }
    }

    private static class CheckBoxGroupConverter
    extends StrArrayConverter {
        private CheckBoxGroupConverter() {
        }
    }

    private static class ComboConverter
    extends StringConverter {
        private ComboConverter() {
        }
    }

    private static class ComboCheckConverter
    extends StrArrayConverter {
        private ComboCheckConverter() {
        }
    }

    private static class AddressConverter
    implements Converter {
        private AddressConverter() {
        }

        @Override
        @Nullable
        public JsonNode executeConvert(@Nonnull JsonNode value, @Nonnull JdyField jdyField) {
            JdyAddress address = (JdyAddress)JacksonUtil.treeToValue((TreeNode)value, JdyAddress.class);
            return JdyDataRequestConvertUtil.ofNewValue(address);
        }
    }

    private static class LocationConverter
    implements Converter {
        private LocationConverter() {
        }

        @Override
        @Nullable
        public JsonNode executeConvert(@Nonnull JsonNode value, @Nonnull JdyField jdyField) {
            JdyLocation location = (JdyLocation)JacksonUtil.treeToValue((TreeNode)value, JdyLocation.class);
            return JdyDataRequestConvertUtil.ofNewValue(location);
        }
    }

    private static class ImageConverter
    extends FileConverter {
        private ImageConverter() {
        }
    }

    private static class UploadConverter
    extends FileConverter {
        private UploadConverter() {
        }
    }

    private static class SubFormConverter
    implements Converter {
        private SubFormConverter() {
        }

        @Override
        @Nullable
        public JsonNode executeConvert(@Nonnull JsonNode value, @Nonnull JdyField jdyField) {
            Assert.isTrue((boolean)value.isArray(), (String)"value must be array", (Object[])new Object[0]);
            List<JdyField> jdyFields = jdyField.getItems();
            if (CollUtil.isEmpty(jdyFields)) {
                return JdyDataRequestConvertUtil.ofNewValue(JacksonUtil.createArrayNode());
            }
            HashMap<String, JdyField> fieldNameTypeMap = new HashMap<String, JdyField>();
            jdyFields.forEach(jdyFieldItem -> fieldNameTypeMap.put(jdyFieldItem.getName(), (JdyField)jdyFieldItem));
            ArrayNode arrayValue = JacksonUtil.createArrayNode();
            for (JsonNode subFormItem : value) {
                ObjectNode newSubFormItem = JacksonUtil.ofObjectNode();
                if (subFormItem.has("_id")) {
                    newSubFormItem.set("_id", JdyDataRequestConvertUtil.ofNewValue(subFormItem.get("_id").asText()));
                }
                fieldNameTypeMap.forEach((fieldName, field) -> {
                    JsonNode oldValue = subFormItem.get(fieldName);
                    if (JacksonUtil.isNull((JsonNode)oldValue)) {
                        newSubFormItem.set(fieldName, JdyDataRequestConvertUtil.ofNewValue(null));
                        return;
                    }
                    Converter converter = JdyDataRequestConvertUtil.getConverter(field);
                    if (converter == null) {
                        return;
                    }
                    JsonNode newValue = converter.executeConvert(oldValue, (JdyField)field);
                    if (newValue == null) {
                        return;
                    }
                    newSubFormItem.set(fieldName, newValue);
                });
                arrayValue.add((JsonNode)newSubFormItem);
            }
            return JdyDataRequestConvertUtil.ofNewValue(arrayValue);
        }
    }

    private static class UserConverter
    implements Converter {
        private UserConverter() {
        }

        @Override
        @Nullable
        public JsonNode executeConvert(@Nonnull JsonNode value, @Nonnull JdyField jdyField) {
            JdyUser user = (JdyUser)JacksonUtil.treeToValue((TreeNode)value, JdyUser.class);
            return JdyDataRequestConvertUtil.ofNewValue(user.getUsername());
        }
    }

    private static class UserGroupConverter
    implements Converter {
        private UserGroupConverter() {
        }

        @Override
        @Nullable
        public JsonNode executeConvert(@Nonnull JsonNode value, @Nonnull JdyField jdyField) {
            Assert.isTrue((boolean)value.isArray(), (String)"value must be array", (Object[])new Object[0]);
            JdyUserGroup users = (JdyUserGroup)JacksonUtil.treeToValue((TreeNode)value, JdyUserGroup.class);
            Set usernames = users.stream().map(JdyUser::getUsername).collect(Collectors.toSet());
            return JdyDataRequestConvertUtil.ofNewValue(usernames);
        }
    }

    private static class DeptConverter
    implements Converter {
        private DeptConverter() {
        }

        @Override
        @Nullable
        public JsonNode executeConvert(@Nonnull JsonNode value, @Nonnull JdyField jdyField) {
            JdyDept dept = (JdyDept)JacksonUtil.treeToValue((TreeNode)value, JdyDept.class);
            return JdyDataRequestConvertUtil.ofNewValue(dept.getDeptNo());
        }
    }

    private static class DeptGroupConverter
    implements Converter {
        private DeptGroupConverter() {
        }

        @Override
        @Nullable
        public JsonNode executeConvert(@Nonnull JsonNode value, @Nonnull JdyField jdyField) {
            Assert.isTrue((boolean)value.isArray(), (String)"value must be array", (Object[])new Object[0]);
            JdyDeptGroup depts = (JdyDeptGroup)JacksonUtil.treeToValue((TreeNode)value, JdyDeptGroup.class);
            Set deptnos = depts.stream().map(JdyDept::getDeptNo).collect(Collectors.toSet());
            return JdyDataRequestConvertUtil.ofNewValue(deptnos);
        }
    }

    private static class PhoneConverter
    implements Converter {
        private PhoneConverter() {
        }

        @Override
        @Nullable
        public JsonNode executeConvert(@Nonnull JsonNode value, @Nonnull JdyField jdyField) {
            JdyPhone phone = (JdyPhone)JacksonUtil.treeToValue((TreeNode)value, JdyPhone.class);
            return JdyDataRequestConvertUtil.ofNewValue(phone.getPhone());
        }
    }

    private static interface Converter {
        @Nullable
        public JsonNode executeConvert(@Nonnull JsonNode var1, @Nonnull JdyField var2);
    }

    private static class StrArrayConverter
    implements Converter {
        private StrArrayConverter() {
        }

        @Override
        @Nullable
        public JsonNode executeConvert(@Nonnull JsonNode value, @Nonnull JdyField jdyField) {
            Assert.isTrue((boolean)value.isArray(), (String)"value must be array", (Object[])new Object[0]);
            ArrayNode stringArray = JacksonUtil.createArrayNode();
            for (JsonNode element : value) {
                stringArray.add(element.asText());
            }
            return JdyDataRequestConvertUtil.ofNewValue(stringArray);
        }
    }

    private static class StringConverter
    implements Converter {
        private StringConverter() {
        }

        @Override
        @Nullable
        public JsonNode executeConvert(@Nonnull JsonNode value, @Nonnull JdyField jdyField) {
            return JdyDataRequestConvertUtil.ofNewValue(value.asText());
        }
    }

    private static class FileConverter
    implements Converter {
        private FileConverter() {
        }

        @Override
        @Nullable
        public JsonNode executeConvert(@Nonnull JsonNode value, @Nonnull JdyField jdyField) {
            JdyFile jdyFile = (JdyFile)JacksonUtil.treeToValue((TreeNode)value, JdyFile.class);
            Assert.notNull((Object)jdyFile, (String)"jdyFile convert error, must not be null", (Object[])new Object[0]);
            Set keys = jdyFile.stream().map(JdyFile.Detail::getKey).collect(Collectors.toSet());
            if (keys.isEmpty()) {
                return null;
            }
            return JdyDataRequestConvertUtil.ofNewValue(keys);
        }
    }

    private static class ReadOnlyConverter
    implements Converter {
        private ReadOnlyConverter() {
        }

        @Override
        @Nullable
        public JsonNode executeConvert(@Nonnull JsonNode value, @Nonnull JdyField jdyField) {
            return null;
        }
    }
}

