/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.okjdy.core.util;

import cn.toint.okjdy.core.model.JdyWebhookRequest;
import cn.toint.oktool.util.Assert;
import cn.toint.oktool.util.JacksonUtil;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.http.server.servlet.ServletUtil;

public class JdyWebhookUtil {
    public static JdyWebhookRequest decode(HttpServletRequest request, String secret) {
        Assert.notNull((Object)request, (CharSequence)"request must not be null", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)secret, (CharSequence)"secret must not be null", (Object[])new Object[0]);
        String body = ServletUtil.getBody((ServletRequest)request);
        Map param = ServletUtil.getParamMap((ServletRequest)request);
        Map header = ServletUtil.getHeaderMap((HttpServletRequest)request);
        String nonce = (String)param.get("nonce");
        Assert.notBlank((CharSequence)nonce, (CharSequence)"nonce must not be blank", (Object[])new Object[0]);
        String timestamp = (String)param.get("timestamp");
        Assert.notBlank((CharSequence)timestamp, (CharSequence)"timestamp must not be blank", (Object[])new Object[0]);
        String signature = (String)header.get("x-jdy-signature");
        Assert.notBlank((CharSequence)signature, (CharSequence)"signature must not be blank", (Object[])new Object[0]);
        String deliverId = (String)header.get("x-jdy-deliverid");
        Assert.notBlank((CharSequence)deliverId, (CharSequence)"deliverId must not be blank", (Object[])new Object[0]);
        HashMap<String, String> signatureParamMap = new HashMap<String, String>();
        signatureParamMap.put("nonce", nonce);
        signatureParamMap.put("timestamp", timestamp);
        signatureParamMap.put("secret", secret);
        signatureParamMap.put("payload", body);
        String signatureStr = SecureUtil.sha1((String)StrUtil.formatByMap((CharSequence)"{nonce}:{payload}:{secret}:{timestamp}", signatureParamMap));
        Assert.isTrue((boolean)Objects.equals(signatureStr, signature), (CharSequence)"signature error", (Object[])new Object[0]);
        JdyWebhookRequest jdyWebhookRequest = (JdyWebhookRequest)JacksonUtil.readValue((String)body, JdyWebhookRequest.class);
        jdyWebhookRequest.setDeliverId(deliverId);
        return jdyWebhookRequest;
    }
}

