/*
 * Copyright 2025 Toint (599818663@qq.com)
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.toint.oktool.properties;

import cn.toint.oktool.model.CacheType;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author Toint
 * @date 2025/7/2
 */
@ConfigurationProperties(prefix = "oktool")
@Data
public class OkToolProperties {
    /**
     * 缓存类型
     */
    private CacheType cacheType = CacheType.AUTO;

    /**
     * jackson LocalDateTime日期模块
     */
    private JacksonLocalDateTimeModule jacksonLocalDateTimeModule;

    /**
     * jackson 安全Long模块
     */
    private JacksonSafeLongModule jacksonSafeLongModule;

    /**
     * jackson LocalDateTime日期模块
     */
    @Data
    public static class JacksonLocalDateTimeModule {
        private boolean enabled = true;
        private String zoneId = "Asia/Shanghai";
        private String pattern =  "yyyy-MM-dd HH:mm:ss";
    }

    /**
     * jackson 安全Long模块
     */
    @Data
    public static class JacksonSafeLongModule {
        private boolean enabled = true;
    }
}
