/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.config;

import cn.toint.oktool.model.CacheType;
import cn.toint.oktool.properties.OkToolProperties;
import cn.toint.oktool.service.CacheService;
import cn.toint.oktool.service.impl.LocalCacheServiceImpl;
import cn.toint.oktool.service.impl.RedisCacheServiceImpl;
import cn.toint.oktool.util.JacksonUtil;
import com.fasterxml.jackson.databind.Module;
import jakarta.annotation.Resource;
import java.time.ZoneId;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ClassUtils;

@AutoConfiguration
@ConfigurationPropertiesScan(value={"cn.toint.oktool.properties"})
public class OkToolAutoConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OkToolAutoConfig.class);
    @Resource
    private OkToolProperties okToolProperties;

    @Bean
    @ConditionalOnProperty(name={"oktool.jackson-local-date-time-module.enabled"}, havingValue="true")
    public Module jacksonLocalDateTimeModule() {
        OkToolProperties.JacksonLocalDateTimeModule jacksonLocalDateTimeModule = this.okToolProperties.getJacksonLocalDateTimeModule();
        ZoneId zoneId = ZoneId.of(jacksonLocalDateTimeModule.getZoneId());
        String pattern = jacksonLocalDateTimeModule.getPattern();
        Module timeModule = JacksonUtil.createLocalDateTimeModule(pattern, zoneId);
        log.info("Jackson LocalDateTimeModule\u521d\u59cb\u5316\u6210\u529f, zoneId={}, pattern={}", (Object)zoneId, (Object)pattern);
        return timeModule;
    }

    @Bean
    @ConditionalOnProperty(name={"oktool.jackson-safe-long-module.enabled"}, havingValue="true")
    public Module jacksonSafeLongModule() {
        Module longModule = JacksonUtil.createSafeLongModule();
        log.info("Jackson SafeLongModule\u521d\u59cb\u5316\u6210\u529f");
        return longModule;
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheService cacheService() {
        boolean hasRedis;
        CacheType cacheType = this.okToolProperties.getCacheType();
        CacheService cacheService = cacheType == null || cacheType == CacheType.AUTO ? ((hasRedis = ClassUtils.isPresent((String)"org.springframework.data.redis.core.StringRedisTemplate", null)) ? new RedisCacheServiceImpl() : new LocalCacheServiceImpl()) : (cacheType == CacheType.REDIS ? new RedisCacheServiceImpl() : new LocalCacheServiceImpl());
        log.info("\u7f13\u5b58\u670d\u52a1\u521d\u59cb\u5316\u6210\u529f, \u5b9e\u73b0\u7c7b: {}", (Object)cacheService.getClass().getName());
        return cacheService;
    }
}

