/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.util;

import cn.toint.oktool.util.Assert;
import cn.toint.oktool.util.JacksonUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.digest.mac.HMac;
import org.dromara.hutool.crypto.digest.mac.HmacAlgorithm;
import org.dromara.hutool.http.HttpUtil;
import org.dromara.hutool.http.client.Response;

public class FeiShuUtil {
    public static String createWebhookSign(String secret, Long timestamp) {
        Assert.notBlank(secret, "secret must not be blank", new Object[0]);
        Assert.notNull(timestamp, "timestamp must not be null", new Object[0]);
        String stringToSign = timestamp + "\n" + secret;
        HMac hmac = SecureUtil.hmac((HmacAlgorithm)HmacAlgorithm.HmacSHA256, (byte[])stringToSign.getBytes(StandardCharsets.UTF_8));
        byte[] signData = hmac.digest(new byte[0]);
        return Base64.encode((byte[])signData);
    }

    public static void sendWebhookTextMsgAsync(String url, String secret, String text) {
        Thread.startVirtualThread(() -> FeiShuUtil.sendWebhookTextMsg(url, secret, text));
    }

    public static void sendWebhookTextMsg(String url, String secret, String text) {
        Assert.notBlank(url, "url must not be blank", new Object[0]);
        Assert.notBlank(secret, "secret must not be blank", new Object[0]);
        Assert.notBlank(text, "text must not be blank", new Object[0]);
        long timestamp = DateUtil.currentSeconds();
        String sign = FeiShuUtil.createWebhookSign(secret, timestamp);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("timestamp", timestamp);
        body.put("sign", sign);
        body.put("msg_type", "text");
        body.put("content", Map.of("text", text));
        try (Response response = HttpUtil.createPost((String)url).body(JacksonUtil.writeValueAsString(body)).send();){
            String bodyStr = response.bodyStr();
            Assert.isTrue(response.isOk() && StringUtils.isBlank((CharSequence)bodyStr), "\u8bf7\u6c42\u98de\u4e66\u5931\u8d25, status: {}, body: {}", response.getStatus(), bodyStr);
            int code = JacksonUtil.readTree(bodyStr).path("code").asInt(-1);
            Assert.isTrue(code == 0, bodyStr, new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

