/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.util;

import cn.toint.oktool.exception.RetryException;
import cn.toint.oktool.model.RetryPolicy;
import cn.toint.oktool.util.Assert;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.thread.ThreadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryUtil.class);

    @SafeVarargs
    public static <R> R execute(@Nonnull Callable<R> callable, int retrySize, @Nullable Duration intervalTime, Class<? extends Throwable> ... exceptionClass) {
        return RetryUtil.execute(callable, retrySize, intervalTime, false, exceptionClass);
    }

    @SafeVarargs
    public static <R> R execute(@Nonnull Callable<R> callable, int retrySize, @Nullable Duration intervalTime, boolean printStackTrace, Class<? extends Throwable> ... exceptionClass) {
        ArrayList<RetryPolicy> retryPolicies = new ArrayList<RetryPolicy>();
        if (ArrayUtil.isNotEmpty((Object[])exceptionClass)) {
            for (Class<? extends Throwable> item : exceptionClass) {
                if (item == null) continue;
                RetryPolicy retryPolicy = new RetryPolicy(retrySize, intervalTime, item, printStackTrace);
                retryPolicies.add(retryPolicy);
            }
        }
        if (CollUtil.isEmpty(retryPolicies)) {
            retryPolicies.add(new RetryPolicy(retrySize, intervalTime, Exception.class, printStackTrace));
        }
        return RetryUtil.execute(callable, retryPolicies);
    }

    public static <R> R execute(@Nonnull Callable<R> callable, @Nullable Collection<RetryPolicy> retryPolicies) {
        Assert.notNull(callable, "callable must not be null", new Object[0]);
        HashMap<RetryPolicy, AtomicInteger> retryCounters = new HashMap<RetryPolicy, AtomicInteger>();
        if (CollUtil.isNotEmpty(retryPolicies)) {
            for (RetryPolicy policy : retryPolicies) {
                retryCounters.put(policy, new AtomicInteger(policy.getRetrySize()));
            }
        }
        while (true) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                RetryPolicy retryPolicy = null;
                if (CollUtil.isNotEmpty(retryPolicies)) {
                    for (RetryPolicy item : retryPolicies) {
                        if (item.getExceptionClass() == null || !item.getExceptionClass().isAssignableFrom(e.getClass())) continue;
                        retryPolicy = item;
                        break;
                    }
                }
                if (retryPolicy == null) {
                    throw new RetryException(e.getMessage(), e);
                }
                AtomicInteger remainSize = (AtomicInteger)retryCounters.get(retryPolicy);
                if (remainSize == null || remainSize.decrementAndGet() < 0) {
                    throw new RetryException(e.getMessage(), e);
                }
                if (retryPolicy.isPrintStackTrace()) {
                    log.warn("({}/{}) {}", new Object[]{remainSize.get() + 1, retryPolicy.getRetrySize(), e.getMessage(), e});
                }
                if (retryPolicy.getIntervalTime() == null || !retryPolicy.getIntervalTime().isPositive()) continue;
                ThreadUtil.sleep((Duration)retryPolicy.getIntervalTime());
                continue;
            }
            break;
        }
    }
}

