/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.time.Duration;
import org.dromara.hutool.core.func.SerSupplier;
import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.http.HttpGlobalConfig;
import org.dromara.hutool.http.client.ClientConfig;
import org.dromara.hutool.http.client.engine.ClientEngine;
import org.dromara.hutool.http.client.engine.ClientEngineFactory;
import org.dromara.hutool.http.client.engine.jdk.JdkClientEngine;

public class HttpClientUtil {
    @Nonnull
    public static ClientEngine clientEngine(@Nullable Class<? extends ClientEngine> clientEngineClass, @Nullable ClientConfig clientConfig) {
        if (HttpGlobalConfig.getTimeout() <= 0) {
            HttpGlobalConfig.setTimeout((int)Math.toIntExact(Duration.ofSeconds(10L).toMillis()));
        }
        if (clientConfig == null) {
            clientConfig = ClientConfig.of();
        }
        if (clientConfig.getConnectionTimeout() <= 0) {
            clientConfig.setConnectionTimeout(HttpGlobalConfig.getTimeout());
        }
        if (clientConfig.getReadTimeout() <= 0) {
            clientConfig.setReadTimeout(HttpGlobalConfig.getTimeout());
        }
        if (clientEngineClass == null) {
            clientEngineClass = JdkClientEngine.class;
        }
        return ClientEngineFactory.createEngine((String)clientEngineClass.getName()).init(clientConfig);
    }

    @Nonnull
    public static ClientEngine clientEngine() {
        return (ClientEngine)Singleton.get((String)ClientEngine.class.getName(), (SerSupplier & Serializable)() -> HttpClientUtil.clientEngine(null, null));
    }

    public static void initGlobalConfig(@Nullable Class<? extends ClientEngine> clientEngineClass, @Nullable ClientConfig clientConfig, @Nullable Duration globalTimeout) {
        if (globalTimeout == null || globalTimeout.toSeconds() <= 0L) {
            globalTimeout = Duration.ofSeconds(10L);
        }
        HttpGlobalConfig.setTimeout((int)Math.toIntExact(globalTimeout.toMillis()));
        ClientEngine clientEngine = HttpClientUtil.clientEngine(clientEngineClass, clientConfig);
        Singleton.put((String)ClientEngine.class.getName(), (Object)clientEngine);
    }
}

