/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.model;

import cn.hutool.v7.core.date.SystemClock;
import cn.toint.oktool.constant.ResponseConstant;
import cn.toint.oktool.model.WriteValue;
import cn.toint.oktool.util.MdcUtil;
import lombok.Generated;

public class Response<T>
implements WriteValue {
    private Integer code;
    private String msg;
    private T data;
    private Long timestamp = SystemClock.now();
    private String traceId = MdcUtil.getTraceId();

    public static <T> Response<T> success() {
        Response<T> response = new Response<T>();
        response.setCode(ResponseConstant.successCode);
        response.setMsg(ResponseConstant.successMsg);
        return response;
    }

    public static <T> Response<T> success(T data) {
        Response<T> response = new Response<T>();
        response.setCode(ResponseConstant.successCode);
        response.setMsg(ResponseConstant.successMsg);
        response.setData(data);
        return response;
    }

    public static <T> Response<T> fail() {
        Response<T> response = new Response<T>();
        response.setCode(ResponseConstant.failCode);
        response.setMsg(ResponseConstant.failMsg);
        return response;
    }

    public static <T> Response<T> fail(T data) {
        Response<T> response = new Response<T>();
        response.setCode(ResponseConstant.failCode);
        response.setMsg(ResponseConstant.failMsg);
        response.setData(data);
        return response;
    }

    public static <T> Response<T> fail(String message) {
        Response<T> response = new Response<T>();
        response.setCode(ResponseConstant.failCode);
        response.setMsg(message);
        return response;
    }

    public static <T> Response<T> fail(int code, String message) {
        Response<T> response = new Response<T>();
        response.setCode(code);
        response.setMsg(message);
        return response;
    }

    public static <T> Response<T> fail(int code, String message, T data) {
        Response<T> response = new Response<T>();
        response.setCode(code);
        response.setMsg(message);
        response.setData(data);
        return response;
    }

    @Generated
    public Response() {
    }

    @Generated
    public Integer getCode() {
        return this.code;
    }

    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Generated
    public T getData() {
        return this.data;
    }

    @Generated
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public void setCode(Integer code) {
        this.code = code;
    }

    @Generated
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Generated
    public void setData(T data) {
        this.data = data;
    }

    @Generated
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        return !(this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Response(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + String.valueOf(this.getData()) + ", timestamp=" + this.getTimestamp() + ", traceId=" + this.getTraceId() + ")";
    }
}

