/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.model;

import cn.hutool.v7.core.date.SystemClock;
import cn.toint.oktool.model.ErrCode;
import cn.toint.oktool.model.WriteValue;
import java.util.Objects;
import org.slf4j.MDC;

public class Response<T>
implements WriteValue {
    private Integer code;
    private String msg;
    private T data;
    private Long timestamp = SystemClock.now();
    private String traceId = MDC.get((String)"traceId");

    public static <T> Response<T> success() {
        Response<T> response = new Response<T>();
        response.setCode(ErrCode.SUCCESS.getCode());
        response.setMsg(ErrCode.SUCCESS.getMsg());
        return response;
    }

    public static <T> Response<T> success(T data) {
        Response<T> response = new Response<T>();
        response.setCode(ErrCode.SUCCESS.getCode());
        response.setMsg(ErrCode.SUCCESS.getMsg());
        response.setData(data);
        return response;
    }

    public static <T> Response<T> fail() {
        Response<T> response = new Response<T>();
        response.setCode(ErrCode.FAIL.getCode());
        response.setMsg(ErrCode.FAIL.getMsg());
        return response;
    }

    public static <T> Response<T> fail(T data) {
        Response<T> response = new Response<T>();
        response.setCode(ErrCode.FAIL.getCode());
        response.setMsg(ErrCode.FAIL.getMsg());
        response.setData(data);
        return response;
    }

    public static <T> Response<T> fail(String message) {
        Response<T> response = new Response<T>();
        response.setCode(ErrCode.FAIL.getCode());
        response.setMsg(message);
        return response;
    }

    public static <T> Response<T> fail(int code, String message) {
        Response<T> response = new Response<T>();
        response.setCode(code);
        response.setMsg(message);
        return response;
    }

    public static <T> Response<T> fail(int code, String message, T data) {
        Response<T> response = new Response<T>();
        response.setCode(code);
        response.setMsg(message);
        response.setData(data);
        return response;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Response response = (Response)o;
        return Objects.equals(this.code, response.code) && Objects.equals(this.msg, response.msg) && Objects.equals(this.data, response.data) && Objects.equals(this.timestamp, response.timestamp) && Objects.equals(this.traceId, response.traceId);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.msg, this.data, this.timestamp, this.traceId);
    }

    public String toString() {
        return "Response{code=" + this.code + ", msg='" + this.msg + "', data=" + String.valueOf(this.data) + ", timestamp=" + this.timestamp + ", traceId='" + this.traceId + "'}";
    }
}

