/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.model;

import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Objects;

public class RetryPolicy {
    private final int retrySize;
    @Nullable
    private final Duration intervalTime;
    @Nullable
    private final Class<? extends Throwable> exceptionClass;
    private final boolean printStackTrace;

    public RetryPolicy(int retrySize, @Nullable Duration intervalTime, @Nullable Class<? extends Throwable> exceptionClass) {
        this.retrySize = retrySize;
        this.intervalTime = intervalTime;
        this.exceptionClass = exceptionClass;
        this.printStackTrace = false;
    }

    public RetryPolicy(int retrySize, @Nullable Duration intervalTime, @Nullable Class<? extends Throwable> exceptionClass, boolean printStackTrace) {
        this.retrySize = retrySize;
        this.intervalTime = intervalTime;
        this.exceptionClass = exceptionClass;
        this.printStackTrace = printStackTrace;
    }

    public int getRetrySize() {
        return this.retrySize;
    }

    @Nullable
    public Duration getIntervalTime() {
        return this.intervalTime;
    }

    @Nullable
    public Class<? extends Throwable> getExceptionClass() {
        return this.exceptionClass;
    }

    public boolean isPrintStackTrace() {
        return this.printStackTrace;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetryPolicy that = (RetryPolicy)o;
        return this.retrySize == that.retrySize && this.printStackTrace == that.printStackTrace && Objects.equals(this.intervalTime, that.intervalTime) && Objects.equals(this.exceptionClass, that.exceptionClass);
    }

    public int hashCode() {
        return Objects.hash(this.retrySize, this.intervalTime, this.exceptionClass, this.printStackTrace);
    }

    public String toString() {
        return "RetryPolicy{retrySize=" + this.retrySize + ", intervalTime=" + String.valueOf(this.intervalTime) + ", exceptionClass=" + String.valueOf(this.exceptionClass) + ", printStackTrace=" + this.printStackTrace + "}";
    }
}

