/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.oss;

import cn.hutool.v7.core.codec.binary.Base64;
import cn.hutool.v7.core.date.DateTime;
import cn.hutool.v7.core.date.DateUtil;
import cn.hutool.v7.core.net.url.UrlBuilder;
import cn.hutool.v7.core.text.StrUtil;
import cn.hutool.v7.core.util.EnumUtil;
import cn.toint.oktool.oss.OssClientConfig;
import cn.toint.oktool.oss.model.CalculatePostSignatureRequest;
import cn.toint.oktool.oss.model.CalculatePostSignatureResponse;
import cn.toint.oktool.oss.model.GeneratePresignedUrlRequest;
import cn.toint.oktool.oss.model.RegionAndEndpointEnum;
import cn.toint.oktool.util.Assert;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.comm.SignVersion;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class OssClient {
    private final OssClientConfig config;
    private final OSSClient oss;

    public OssClient(OssClientConfig config, OSSClient oss) {
        this.config = config;
        this.oss = oss;
    }

    public static OssClient of(OssClientConfig config) {
        Assert.notNull(config, "\u963f\u91cc\u4e91OSS\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Assert.validate((Object)config, new Class[0]);
        String accessKeyId = config.getAccessKeyId();
        String secretAccessKey = config.getSecretAccessKey();
        String endpoint = config.getEndpoint();
        String region = config.getRegion();
        ClientBuilderConfiguration clientBuilderConfiguration = new ClientBuilderConfiguration();
        clientBuilderConfiguration.setSignatureVersion(SignVersion.V4);
        clientBuilderConfiguration.setRequestTimeout(config.getRequestTimeout().intValue());
        clientBuilderConfiguration.setConnectionTimeout(config.getConnectionTimeout().intValue());
        clientBuilderConfiguration.setConnectionRequestTimeout(config.getConnectionRequestTimeout().intValue());
        DefaultCredentialProvider credentialsProvider = new DefaultCredentialProvider(accessKeyId, secretAccessKey);
        OSSClient oss = new OSSClient(endpoint, (CredentialsProvider)credentialsProvider, (ClientConfiguration)clientBuilderConfiguration);
        oss.setRegion(region);
        return new OssClient(config, oss);
    }

    public String generatePresignedUrl(GeneratePresignedUrlRequest request) {
        Assert.notNull(request, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Assert.validate((Object)request, new Class[0]);
        String bucketName = request.getBucketName();
        String objectKey = request.getObjectKey();
        Duration timeout = request.getTimeout();
        String cdnUrl = request.getCdnUrl();
        DateTime expiration = DateUtil.offsetMillisecond((Date)DateUtil.now(), (int)Math.toIntExact(timeout.toMillis()));
        URL url = this.oss.generatePresignedUrl(bucketName, objectKey, (Date)expiration);
        if (StringUtils.isBlank((CharSequence)cdnUrl)) {
            return url.toString();
        }
        UrlBuilder ossUrl = UrlBuilder.of((URL)url, (Charset)StandardCharsets.UTF_8);
        return UrlBuilder.ofHttp((String)cdnUrl).addPath((CharSequence)ossUrl.getPathStr()).setQuery(ossUrl.getQuery()).toString();
    }

    public CalculatePostSignatureResponse calculatePostSignature(CalculatePostSignatureRequest request) {
        RegionAndEndpointEnum regionAndEndpointEnum;
        Assert.notNull(request, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Assert.validate((Object)request, new Class[0]);
        String bucketName = request.getBucketName();
        String accessKeyId = this.config.getAccessKeyId();
        String objectKey = request.getObjectKey();
        String endpoint = this.config.getEndpoint();
        Long minFileSize = request.getMinFileSize();
        Long maxFileSize = request.getMaxFileSize();
        Assert.isTrue(minFileSize != null && minFileSize >= 0L, "\u6587\u4ef6\u6700\u5c0f\u503c\u4e0d\u5408\u6cd5", new Object[0]);
        Assert.isTrue(maxFileSize != null && maxFileSize >= 0L, "\u6587\u4ef6\u6700\u5927\u503c\u4e0d\u5408\u6cd5", new Object[0]);
        long seconds = request.getTimeout().toSeconds();
        DateTime expiration = DateUtil.offsetSecond((Date)DateUtil.now(), (int)Math.toIntExact(seconds));
        PolicyConditions policyConditions = new PolicyConditions();
        policyConditions.addConditionItem("content-length-range", minFileSize.longValue(), maxFileSize.longValue());
        policyConditions.addConditionItem(MatchMode.Exact, "key", objectKey);
        policyConditions.addConditionItem(MatchMode.Exact, "bucket", bucketName);
        String postPolicy = this.oss.generatePostPolicy((Date)expiration, policyConditions);
        String postPolicyBase64 = Base64.encode((CharSequence)postPolicy);
        String postSignature = this.oss.calculatePostSignature(postPolicy);
        Boolean internal = request.getInternal();
        if (internal != null && (regionAndEndpointEnum = (RegionAndEndpointEnum)EnumUtil.getBy(RegionAndEndpointEnum::getRegion, (Object)this.config.getRegion())) != null) {
            endpoint = internal != false ? regionAndEndpointEnum.getInternalEndpoint() : regionAndEndpointEnum.getEndpoint();
        }
        String uploadUrl = StrUtil.format((CharSequence)"https://{}.{}", (Object[])new Object[]{bucketName, endpoint});
        CalculatePostSignatureResponse.Form form = new CalculatePostSignatureResponse.Form();
        form.setSignature(postSignature);
        form.setOssAccessKeyId(accessKeyId);
        form.setKey(objectKey);
        form.setPolicy(postPolicyBase64);
        CalculatePostSignatureResponse calculatePostSignatureResponse = new CalculatePostSignatureResponse();
        calculatePostSignatureResponse.setUploadUrl(uploadUrl);
        calculatePostSignatureResponse.setForm(form);
        return calculatePostSignatureResponse;
    }
}

