/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.util;

import cn.toint.oktool.util.Assert;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;

public class GeoUtil {
    private static final GeodeticCalculator instance = new GeodeticCalculator();

    public static GeodeticCurve calculateCurve(Ellipsoid reference, GlobalCoordinates g1, GlobalCoordinates g2) {
        Assert.notNull(reference, "\u5750\u6807\u7cfb\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Assert.notNull(g1, "\u4f4d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Assert.notNull(g2, "\u4f4d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        return instance.calculateGeodeticCurve(reference, g1, g2);
    }

    public static GeodeticCurve calculateCurveWgs84(GlobalCoordinates g1, GlobalCoordinates g2) {
        Assert.notNull(g1, "\u4f4d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Assert.notNull(g2, "\u4f4d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        return instance.calculateGeodeticCurve(Ellipsoid.WGS84, g1, g2);
    }

    public static long getDistanceM(GeodeticCurve geodeticCurve) {
        Assert.notNull(geodeticCurve, "\u8ddd\u79bb\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        double ellipsoidalDistance = geodeticCurve.getEllipsoidalDistance();
        return Math.round(ellipsoidalDistance);
    }

    public static BigDecimal getDistanceKm(GeodeticCurve geodeticCurve) {
        Assert.notNull(geodeticCurve, "\u8ddd\u79bb\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        double ellipsoidalDistance = geodeticCurve.getEllipsoidalDistance();
        return BigDecimal.valueOf(ellipsoidalDistance).divide(BigDecimal.valueOf(1000L), 3, RoundingMode.HALF_UP);
    }
}

