/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.util;

import cn.hutool.v7.core.func.SerSupplier;
import cn.hutool.v7.core.lang.Singleton;
import cn.hutool.v7.http.HttpGlobalConfig;
import cn.hutool.v7.http.client.ClientConfig;
import cn.hutool.v7.http.client.engine.ClientEngine;
import cn.hutool.v7.http.client.engine.ClientEngineFactory;
import cn.hutool.v7.http.client.engine.okhttp.OkHttpEngine;
import java.io.Serializable;
import java.time.Duration;

public class HttpClientUtil {
    private static final Duration DEFAULT_GLOBAL_TIMEOUT = Duration.ofSeconds(30L);
    private static final Class<? extends ClientEngine> DEFAULT_CLIENT_ENGINE = OkHttpEngine.class;

    public static ClientEngine clientEngine(Class<? extends ClientEngine> clientEngineClass, ClientConfig clientConfig) {
        if (HttpGlobalConfig.getTimeout() <= 0) {
            HttpGlobalConfig.setTimeout((int)((int)DEFAULT_GLOBAL_TIMEOUT.toMillis()));
        }
        if (clientConfig == null) {
            clientConfig = ClientConfig.of();
        }
        if (clientConfig.getConnectionTimeout() <= 0) {
            clientConfig.setConnectionTimeout(HttpGlobalConfig.getTimeout());
        }
        if (clientConfig.getReadTimeout() <= 0) {
            clientConfig.setReadTimeout(HttpGlobalConfig.getTimeout());
        }
        if (clientEngineClass == null) {
            clientEngineClass = DEFAULT_CLIENT_ENGINE;
        }
        return ClientEngineFactory.createEngine((String)clientEngineClass.getName()).init(clientConfig);
    }

    public static ClientEngine clientEngine() {
        return (ClientEngine)Singleton.get((String)ClientEngine.class.getName(), (SerSupplier & Serializable)() -> HttpClientUtil.clientEngine(null, null));
    }

    public static void initGlobalConfig() {
        HttpClientUtil.initGlobalConfig(null);
    }

    public static void initGlobalConfig(Class<? extends ClientEngine> clientEngineClass) {
        HttpClientUtil.initGlobalConfig(clientEngineClass, null, null);
    }

    public static void initGlobalConfig(Class<? extends ClientEngine> clientEngineClass, ClientConfig clientConfig, Duration globalTimeout) {
        ClientEngine clientEngine = HttpClientUtil.clientEngine(clientEngineClass, clientConfig);
        Singleton.put((String)ClientEngine.class.getName(), (Object)clientEngine);
    }
}

