/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.util;

import cn.hutool.v7.core.collection.CollUtil;
import cn.hutool.v7.core.text.CharSequenceUtil;
import cn.hutool.v7.core.text.split.SplitUtil;
import cn.toint.oktool.util.Assert;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class KeyBuilder {
    private final List<String> values = new ArrayList<String>();

    public KeyBuilder add(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            SplitUtil.split((CharSequence)value, (CharSequence)":").stream().map(CharSequenceUtil::trim).filter(StringUtils::isNotBlank).forEach(this.values::add);
        }
        return this;
    }

    public KeyBuilder addAll(List<String> values) {
        if (CollUtil.isNotEmpty(values)) {
            values.forEach(this::add);
        }
        return this;
    }

    public static KeyBuilder of(String value) {
        return new KeyBuilder().add(value);
    }

    public static KeyBuilder of(List<String> values) {
        return new KeyBuilder().addAll(values);
    }

    public String build() {
        Assert.notEmpty(this.values, (CharSequence)"values must not be empty", new Object[0]);
        return String.join((CharSequence)":", this.values);
    }
}

