/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.slf4j.MDC;

public class ScopedValueUtil {
    private static final ExecutorService executorService = Executors.newVirtualThreadPerTaskExecutor();

    public static <V> CompletableFuture<Void> runAsync(ScopedValue<V> scopedValue, Runnable runnable) {
        return ScopedValueUtil.runAsync(Collections.singletonList(scopedValue), runnable);
    }

    public static <V, R> CompletableFuture<R> supplyAsync(ScopedValue<V> scopedValue, Supplier<R> supplier) {
        return ScopedValueUtil.supplyAsync(Collections.singletonList(scopedValue), supplier);
    }

    public static CompletableFuture<Void> runAsync(List<ScopedValue<?>> scopedValues, Runnable runnable) {
        Map<ScopedValue<?>, Object> scopedValueMap = ScopedValueUtil.captureContext(scopedValues);
        return ScopedValueUtil.runAsync(scopedValueMap, runnable);
    }

    public static <R> CompletableFuture<R> supplyAsync(List<ScopedValue<?>> scopedValues, Supplier<R> supplier) {
        Map<ScopedValue<?>, Object> scopedValueMap = ScopedValueUtil.captureContext(scopedValues);
        return ScopedValueUtil.supplyAsync(scopedValueMap, supplier);
    }

    public static <R> CompletableFuture<R> supplyAsync(Map<ScopedValue<?>, Object> scopedValueMap, Supplier<R> supplier) {
        Objects.requireNonNull(supplier, "supplier must not be null");
        Map mdcContext = MDC.getCopyOfContextMap();
        if (scopedValueMap == null || scopedValueMap.isEmpty()) {
            return CompletableFuture.supplyAsync(() -> {
                ScopedValueUtil.restoreMdc(mdcContext);
                try {
                    Object t = supplier.get();
                    return t;
                }
                finally {
                    MDC.clear();
                }
            }, executorService);
        }
        return CompletableFuture.supplyAsync(() -> {
            ScopedValueUtil.restoreMdc(mdcContext);
            try {
                ScopedValue.Carrier carrier = ScopedValueUtil.buildCarrier(scopedValueMap);
                Object object = carrier.call(((Supplier)supplier)::get);
                return object;
            }
            finally {
                MDC.clear();
            }
        }, executorService);
    }

    private static void restoreMdc(Map<String, String> mdcContext) {
        if (mdcContext != null && !mdcContext.isEmpty()) {
            MDC.setContextMap(mdcContext);
        }
    }

    public static CompletableFuture<Void> runAsync(Map<ScopedValue<?>, Object> scopedValueMap, Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable must not be null");
        return ScopedValueUtil.supplyAsync(scopedValueMap, () -> {
            runnable.run();
            return null;
        });
    }

    public static ScopedValue.Carrier buildCarrier(Map<ScopedValue<?>, Object> scopedValueMap) {
        if (scopedValueMap == null || scopedValueMap.isEmpty()) {
            return null;
        }
        ScopedValue.Carrier carrier = null;
        for (Map.Entry<ScopedValue<?>, Object> entry : scopedValueMap.entrySet()) {
            ScopedValue<?> key = entry.getKey();
            Object value = entry.getValue();
            if (carrier == null) {
                carrier = ScopedValue.where(key, value);
                continue;
            }
            carrier = carrier.where(key, value);
        }
        return carrier;
    }

    public static Map<ScopedValue<?>, Object> captureContext(List<ScopedValue<?>> scopedValues) {
        HashMap scopedValueMap = new HashMap();
        if (scopedValues != null && !scopedValues.isEmpty()) {
            scopedValues.forEach(scopedValue -> {
                if (scopedValue != null && scopedValue.isBound()) {
                    scopedValueMap.put((ScopedValue<?>)scopedValue, scopedValue.get());
                }
            });
        }
        return scopedValueMap;
    }

    public static <V> Optional<V> get(ScopedValue<V> scopedValue) {
        return Optional.ofNullable(ScopedValueUtil.getOrNull(scopedValue));
    }

    public static <V> V getOrNull(ScopedValue<V> scopedValue) {
        return ScopedValueUtil.orElse(scopedValue, null);
    }

    public static <V> V orElse(ScopedValue<V> scopedValue, V defaultValue) {
        if (scopedValue != null && scopedValue.isBound()) {
            return scopedValue.get();
        }
        return defaultValue;
    }

    public static <V> boolean isBound(ScopedValue<V> scopedValue) {
        return scopedValue != null && scopedValue.isBound();
    }
}

