/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql.config;

import com.wix.mysql.Sources;
import com.wix.mysql.SqlScriptSource;
import com.wix.mysql.config.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SchemaConfig {
    private final String name;
    private final Charset charset;
    private final List<SqlScriptSource> scripts;

    private SchemaConfig(String name, Charset charset, List<SqlScriptSource> scripts) {
        this.name = name;
        this.charset = charset;
        this.scripts = scripts;
    }

    public static Builder aSchemaConfig(String name) {
        return new Builder(name);
    }

    public String getName() {
        return this.name;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public List<SqlScriptSource> getScripts() {
        return this.scripts;
    }

    public static class Builder {
        private final String name;
        private Charset charset;
        private List<SqlScriptSource> scripts = new ArrayList<SqlScriptSource>();

        public Builder(String name) {
            this.name = name;
        }

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withScripts(SqlScriptSource ... scripts) {
            return this.withScripts(Arrays.asList(scripts));
        }

        public Builder withScripts(List<SqlScriptSource> scripts) {
            this.scripts.addAll(scripts);
            return this;
        }

        public Builder withCommands(String ... commands) {
            return this.withCommands(Arrays.asList(commands));
        }

        public Builder withCommands(List<String> commands) {
            for (String cmd : commands) {
                this.scripts.add(Sources.fromString(cmd));
            }
            return this;
        }

        public SchemaConfig build() {
            return new SchemaConfig(this.name, this.charset, this.scripts);
        }
    }
}

