/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel;

import cn.toutatis.xvoid.axolotl.excel.reader.annotations.ColumnBind;
import cn.toutatis.xvoid.axolotl.excel.reader.annotations.IndexWorkSheet;
import cn.toutatis.xvoid.axolotl.excel.reader.annotations.KeepIntact;
import cn.toutatis.xvoid.axolotl.excel.reader.annotations.NamingWorkSheet;
import cn.toutatis.xvoid.axolotl.excel.reader.annotations.SpecifyPositionBind;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.EntityCellMappingInfo;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.RowLevelReadPolicy;
import cn.toutatis.xvoid.axolotl.excel.reader.support.exceptions.AxolotlExcelReadException;
import cn.toutatis.xvoid.toolkit.constant.Regex;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ReaderConfig<T> {
    private int sheetIndex = 0;
    private String sheetName;
    private int initialRowPositionOffset = 0;
    private Class<T> castClass;
    private int startIndex = 0;
    private int endIndex = -1;
    private boolean readAsObject = false;
    private List<EntityCellMappingInfo<?>> indexMappingInfos;
    private List<EntityCellMappingInfo<?>> positionMappingInfos;
    private Map<RowLevelReadPolicy, Object> rowReadPolicyMap = new HashMap<RowLevelReadPolicy, Object>();
    private boolean readClassAnnotation = false;

    public ReaderConfig() {
        this(true);
    }

    public ReaderConfig(Class<T> castClass) {
        this(true);
        this.setCastClass(castClass);
    }

    public ReaderConfig(boolean withDefaultConfig) {
        if (withDefaultConfig) {
            this.rowReadPolicyMap.putAll(this.defaultReadPolicy());
        }
    }

    public ReaderConfig(Class<T> castClass, boolean withDefaultConfig) {
        if (withDefaultConfig) {
            this.rowReadPolicyMap.putAll(this.defaultReadPolicy());
        }
        this.setCastClass(castClass);
    }

    private Map<RowLevelReadPolicy, Object> defaultReadPolicy() {
        HashMap<RowLevelReadPolicy, Object> defaultReadPolicies = new HashMap<RowLevelReadPolicy, Object>();
        for (RowLevelReadPolicy policy : RowLevelReadPolicy.values()) {
            if (!policy.isDefaultPolicy()) continue;
            defaultReadPolicies.put(policy, policy.getValue());
        }
        return defaultReadPolicies;
    }

    public void setCastClass(Class<T> castClass) {
        this.setCastClass(castClass, true);
    }

    public void setCastClass(Class<T> castClass, boolean readClassAnnotation) {
        this.castClass = castClass;
        if (readClassAnnotation) {
            this.processClassAnnotation();
        }
        this.processEntityFieldMappingToCell();
    }

    private void processClassAnnotation() {
        NamingWorkSheet namingWorkSheet = this.castClass.getAnnotation(NamingWorkSheet.class);
        if (namingWorkSheet != null) {
            this.setSheetName(namingWorkSheet.sheetName());
            this.setReadClassAnnotation(true);
            return;
        }
        IndexWorkSheet indexWorkSheet = this.castClass.getAnnotation(IndexWorkSheet.class);
        if (indexWorkSheet != null) {
            this.setStartIndex(indexWorkSheet.sheetIndex());
            this.setReadClassAnnotation(true);
        }
    }

    private void processEntityFieldMappingToCell() {
        Field[] declaredFields = this.castClass.getDeclaredFields();
        ArrayList entityCellMappingInfos = new ArrayList();
        ArrayList positionMappingInfos = new ArrayList();
        boolean preciseLocalization = this.getReadPolicyAsBoolean(RowLevelReadPolicy.DATA_BIND_PRECISE_LOCALIZATION);
        AtomicInteger idx = new AtomicInteger(-1);
        for (Field declaredField : declaredFields) {
            SpecifyPositionBind specifyPositionBind;
            idx.getAndIncrement();
            EntityCellMappingInfo entityCellMappingInfo = new EntityCellMappingInfo(declaredField.getType());
            entityCellMappingInfo.setFieldIndex(idx.get());
            entityCellMappingInfo.setFieldName(declaredField.getName());
            KeepIntact keepIntact = declaredField.getAnnotation(KeepIntact.class);
            if (keepIntact != null) {
                RowLevelReadPolicy[] excludePolicies = keepIntact.excludePolicies();
                entityCellMappingInfo.setExcludePolicies(Arrays.stream(excludePolicies).collect(Collectors.toMap(policy -> policy, policy -> true)));
            }
            if ((specifyPositionBind = declaredField.getAnnotation(SpecifyPositionBind.class)) != null) {
                entityCellMappingInfo.setMappingType(EntityCellMappingInfo.MappingType.POSITION);
                entityCellMappingInfo.setFormat(specifyPositionBind.format());
                entityCellMappingInfo.setDataCastAdapter(specifyPositionBind.adapter());
                String position = specifyPositionBind.value().toUpperCase();
                String[] alphaNumeric = Regex.splitAlphaNumeric((String)position);
                if (alphaNumeric.length == 2) {
                    String columnString = alphaNumeric[0];
                    boolean bigSheetColumn = columnString.length() > 1;
                    int simpleIdx = columnString.charAt(0) - 65;
                    int columnIndex = bigSheetColumn ? (simpleIdx + 1) * 26 + (columnString.charAt(1) - 65) : simpleIdx;
                    entityCellMappingInfo.setColumnPosition(columnIndex);
                    entityCellMappingInfo.setRowPosition(Integer.parseInt(alphaNumeric[1]) - 1);
                    positionMappingInfos.add(entityCellMappingInfo);
                    continue;
                }
                throw new IllegalArgumentException("\u6307\u5b9a\u5355\u5143\u683c\u4f4d\u7f6e\u683c\u5f0f\u9519\u8bef");
            }
            ColumnBind columnBind = declaredField.getAnnotation(ColumnBind.class);
            if (columnBind != null) {
                entityCellMappingInfo.setMappingType(EntityCellMappingInfo.MappingType.INDEX);
                entityCellMappingInfo.setColumnPosition(columnBind.columnIndex());
                entityCellMappingInfo.setDataCastAdapter(columnBind.adapter());
                entityCellMappingInfo.setFormat(columnBind.format());
                entityCellMappingInfos.add(entityCellMappingInfo);
                continue;
            }
            if (preciseLocalization) continue;
            entityCellMappingInfo.setMappingType(EntityCellMappingInfo.MappingType.UNKNOWN);
            entityCellMappingInfo.setColumnPosition(idx.get());
            entityCellMappingInfos.add(entityCellMappingInfo);
        }
        this.positionMappingInfos = positionMappingInfos;
        this.indexMappingInfos = entityCellMappingInfos;
    }

    public boolean getReadPolicyAsBoolean(RowLevelReadPolicy policy) {
        if (policy.getType() != RowLevelReadPolicy.Type.BOOLEAN) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u7279\u6027\u4e0d\u662f\u4e00\u4e2a\u5e03\u5c14\u7c7b\u578b");
        }
        return this.rowReadPolicyMap.containsKey((Object)policy) && (Boolean)this.rowReadPolicyMap.get((Object)policy) != false;
    }

    public void addReadFeature(RowLevelReadPolicy policy, Object value) {
        this.rowReadPolicyMap.put(policy, value);
    }

    public T getCastClassInstance() {
        if (this.castClass != null) {
            try {
                if (this.castClass == Map.class) {
                    if (this.getReadPolicyAsBoolean(RowLevelReadPolicy.SORTED_READ_SHEET_DATA)) {
                        return (T)new LinkedHashMap();
                    }
                    return (T)new HashMap();
                }
                return this.castClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, "\u7c7b\u578b\u5b9e\u4f8b\u5316\u5931\u8d25:" + e.getMessage());
            }
        }
        throw new IllegalArgumentException("\u8f6c\u6362\u7c7b\u578b\u4e3a\u7a7a");
    }

    public String toString() {
        return "ReaderConfig(sheetIndex=" + this.getSheetIndex() + ", sheetName=" + this.getSheetName() + ", initialRowPositionOffset=" + this.getInitialRowPositionOffset() + ", castClass=" + this.getCastClass() + ", startIndex=" + this.getStartIndex() + ", endIndex=" + this.getEndIndex() + ", readAsObject=" + this.isReadAsObject() + ", indexMappingInfos=" + this.getIndexMappingInfos() + ", positionMappingInfos=" + this.getPositionMappingInfos() + ", rowReadPolicyMap=" + this.getRowReadPolicyMap() + ", readClassAnnotation=" + this.isReadClassAnnotation() + ")";
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public int getInitialRowPositionOffset() {
        return this.initialRowPositionOffset;
    }

    public Class<T> getCastClass() {
        return this.castClass;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public boolean isReadAsObject() {
        return this.readAsObject;
    }

    public List<EntityCellMappingInfo<?>> getIndexMappingInfos() {
        return this.indexMappingInfos;
    }

    public List<EntityCellMappingInfo<?>> getPositionMappingInfos() {
        return this.positionMappingInfos;
    }

    public Map<RowLevelReadPolicy, Object> getRowReadPolicyMap() {
        return this.rowReadPolicyMap;
    }

    public boolean isReadClassAnnotation() {
        return this.readClassAnnotation;
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void setInitialRowPositionOffset(int initialRowPositionOffset) {
        this.initialRowPositionOffset = initialRowPositionOffset;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public void setReadAsObject(boolean readAsObject) {
        this.readAsObject = readAsObject;
    }

    public void setIndexMappingInfos(List<EntityCellMappingInfo<?>> indexMappingInfos) {
        this.indexMappingInfos = indexMappingInfos;
    }

    public void setPositionMappingInfos(List<EntityCellMappingInfo<?>> positionMappingInfos) {
        this.positionMappingInfos = positionMappingInfos;
    }

    public void setRowReadPolicyMap(Map<RowLevelReadPolicy, Object> rowReadPolicyMap) {
        this.rowReadPolicyMap = rowReadPolicyMap;
    }

    public void setReadClassAnnotation(boolean readClassAnnotation) {
        this.readClassAnnotation = readClassAnnotation;
    }
}

