/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel;

import cn.toutatis.xvoid.axolotl.excel.reader.support.AbstractContext;
import cn.toutatis.xvoid.axolotl.excel.toolkit.ExcelToolkit;
import cn.toutatis.xvoid.axolotl.excel.toolkit.tika.DetectResult;
import java.io.File;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;

public class WorkBookContext
extends AbstractContext {
    private Workbook workbook;
    private FormulaEvaluator formulaEvaluator;
    private int currentReadRowIndex = -1;
    private int currentReadColumnIndex = -1;
    private boolean _eventDriven = false;

    public WorkBookContext(File file, DetectResult detectResult) {
        this.setFile(file);
        this.setMimeType(detectResult.getCatchMimeType());
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public FormulaEvaluator getFormulaEvaluator() {
        if (this.formulaEvaluator == null) {
            this.formulaEvaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
        }
        return this.formulaEvaluator;
    }

    public boolean getEventDriven() {
        return this._eventDriven;
    }

    public void setEventDriven() {
        this._eventDriven = true;
    }

    public void setCurrentReadRowIndex(int currentReadRowIndex) {
        this.currentReadRowIndex = currentReadRowIndex;
    }

    public void setCurrentReadColumnIndex(int currentReadColumnIndex) {
        this.currentReadColumnIndex = currentReadColumnIndex;
    }

    public String getHumanReadablePosition() {
        return ExcelToolkit.getHumanReadablePosition(this.currentReadRowIndex, this.currentReadColumnIndex);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public int getCurrentReadRowIndex() {
        return this.currentReadRowIndex;
    }

    public int getCurrentReadColumnIndex() {
        return this.currentReadColumnIndex;
    }
}

