/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.reader.support.exceptions;

import cn.toutatis.xvoid.axolotl.excel.WorkBookContext;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.EntityCellMappingInfo;
import cn.toutatis.xvoid.axolotl.excel.reader.support.CastContext;
import cn.toutatis.xvoid.axolotl.excel.toolkit.ExcelToolkit;

public class AxolotlExcelReadException
extends RuntimeException {
    private int currentReadRowIndex;
    private int currentReadColumnIndex;
    private String fieldName;
    private ExceptionType exceptionType;

    public AxolotlExcelReadException(ExceptionType exceptionType, Throwable cause) {
        super(cause);
    }

    public AxolotlExcelReadException(ExceptionType exceptionType, String message) {
        super(message);
    }

    public AxolotlExcelReadException(WorkBookContext workBookContext, String message) {
        this(ExceptionType.READ_EXCEL_ROW_ERROR, null, workBookContext.getCurrentReadRowIndex(), workBookContext.getCurrentReadColumnIndex(), message);
    }

    public AxolotlExcelReadException(EntityCellMappingInfo<?> mappingInfo, String message) {
        this(ExceptionType.READ_EXCEL_ROW_ERROR, mappingInfo.getFieldName(), mappingInfo.getRowPosition(), mappingInfo.getColumnPosition(), message);
    }

    public AxolotlExcelReadException(CastContext<?> castContext, String message) {
        this(ExceptionType.CONVERT_FIELD_ERROR, castContext.getCastType().getSimpleName(), castContext.getCurrentReadRowIndex(), castContext.getCurrentReadColumnIndex(), message);
    }

    public AxolotlExcelReadException(ExceptionType exceptionType, String fieldName, int currentReadRowIndex, int currentReadColumnIndex, String message) {
        super(message);
        this.exceptionType = exceptionType;
        this.fieldName = fieldName;
        this.setCurrentReadColumnIndex(currentReadColumnIndex);
        this.setCurrentReadRowIndex(currentReadRowIndex);
    }

    public String getHumanReadablePosition() {
        return ExcelToolkit.getHumanReadablePosition(this.currentReadRowIndex, this.currentReadColumnIndex);
    }

    public int getCurrentReadRowIndex() {
        return this.currentReadRowIndex;
    }

    public int getCurrentReadColumnIndex() {
        return this.currentReadColumnIndex;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public ExceptionType getExceptionType() {
        return this.exceptionType;
    }

    public void setCurrentReadRowIndex(int currentReadRowIndex) {
        this.currentReadRowIndex = currentReadRowIndex;
    }

    public void setCurrentReadColumnIndex(int currentReadColumnIndex) {
        this.currentReadColumnIndex = currentReadColumnIndex;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setExceptionType(ExceptionType exceptionType) {
        this.exceptionType = exceptionType;
    }

    public static enum ExceptionType {
        READ_EXCEL_ERROR,
        READ_EXCEL_ROW_ERROR,
        CONVERT_FIELD_ERROR,
        VALIDATION_ERROR;

    }
}

