/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.support.adapters;

import cn.toutatis.xvoid.axolotl.excel.ReaderConfig;
import cn.toutatis.xvoid.axolotl.excel.constant.EntityCellMappingInfo;
import cn.toutatis.xvoid.axolotl.excel.constant.RowLevelReadPolicy;
import cn.toutatis.xvoid.axolotl.excel.support.CastContext;
import cn.toutatis.xvoid.axolotl.excel.support.CellGetInfo;
import cn.toutatis.xvoid.axolotl.excel.support.DataCastAdapter;
import cn.toutatis.xvoid.axolotl.excel.support.adapters.AbstractDataCastAdapter;
import cn.toutatis.xvoid.axolotl.excel.support.exceptions.AxolotlExcelReadException;
import cn.toutatis.xvoid.toolkit.constant.Regex;
import cn.toutatis.xvoid.toolkit.validator.Validator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellType;

public class DefaultNumericAdapter<NT>
extends AbstractDataCastAdapter<NT>
implements DataCastAdapter<NT> {
    private final Class<NT> numberClass;

    public DefaultNumericAdapter(Class<NT> numberClass) {
        this.numberClass = numberClass;
    }

    @Override
    public NT cast(CellGetInfo cellGetInfo, CastContext<NT> context) {
        Object cellValue = cellGetInfo.getCellValue();
        if (!cellGetInfo.isAlreadyFillValue()) {
            return this.numberClass.cast(cellValue);
        }
        switch (cellGetInfo.getCellType()) {
            case NUMERIC: {
                Double doubleValue = (Double)cellValue;
                return this.castDoubleToOtherTypeNumber(doubleValue, context);
            }
            case STRING: {
                ReaderConfig<?> readerConfig = this.getReaderConfig();
                EntityCellMappingInfo<?> entityCellMappingInfo = this.getEntityCellMappingInfo();
                Map<RowLevelReadPolicy, Object> excelPolicies = entityCellMappingInfo.getExcludePolicies();
                if (!excelPolicies.containsKey((Object)RowLevelReadPolicy.TRIM_CELL_VALUE) && readerConfig.getReadPolicyAsBoolean(RowLevelReadPolicy.TRIM_CELL_VALUE)) {
                    cellValue = Regex.convertSingleLine((String)cellValue.toString());
                }
                if (Validator.strIsNumber((String)((String)cellValue))) {
                    Double cellDoubleValue = Double.valueOf((String)cellValue);
                    return this.castDoubleToOtherTypeNumber(cellDoubleValue, context);
                }
                throw new AxolotlExcelReadException(context, "\u5b57\u7b26\u4e32\u4e0d\u662f\u6570\u5b57\u683c\u5f0f\u65e0\u6cd5\u8f6c\u6362");
            }
            case BOOLEAN: {
                if (((Boolean)cellGetInfo.getCellValue()).booleanValue()) {
                    return this.numberClass.cast(1);
                }
                return this.numberClass.cast(0);
            }
        }
        return null;
    }

    private NT castDoubleToOtherTypeNumber(Double doubleValue, CastContext<NT> context) {
        if (this.numberClass.equals(Double.class)) {
            return (NT)doubleValue;
        }
        if (this.numberClass.equals(BigDecimal.class)) {
            BigDecimal bigDecimal = new BigDecimal(doubleValue.toString()).setScale(2, RoundingMode.HALF_UP);
            return (NT)bigDecimal;
        }
        if (this.numberClass.equals(Integer.class)) {
            return (NT)Integer.valueOf(doubleValue.intValue());
        }
        if (this.numberClass.equals(Float.class)) {
            return (NT)Float.valueOf(doubleValue.floatValue());
        }
        if (this.numberClass.equals(Long.class)) {
            return (NT)Long.valueOf(doubleValue.longValue());
        }
        if (this.numberClass.equals(Short.class)) {
            return (NT)Short.valueOf(doubleValue.shortValue());
        }
        throw new AxolotlExcelReadException(context, "\u4e0d\u652f\u6301\u7684\u6570\u5b57\u7c7b\u578b\u8f6c\u6362");
    }

    @Override
    public boolean support(CellType cellType, Class<NT> clazz) {
        return clazz == Integer.class || clazz == String.class || clazz == Integer.TYPE || clazz == BigDecimal.class || clazz == Long.class || clazz == Long.TYPE || clazz == Double.class || clazz == Double.TYPE || clazz == Float.class || clazz == Float.TYPE || clazz == Short.class || clazz == Short.TYPE || clazz == Byte.class || clazz == Byte.TYPE || clazz == Number.class;
    }
}

